/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge;

import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.annotate.UnknownObjectField;
import com.oracle.svm.core.annotate.UnknownPrimitiveField;
import org.graalvm.compiler.word.Word;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;

public final class ImageHeapInfo {
    public static final long NO_CHUNK = -1L;
    @UnknownObjectField(types={Object.class})
    public Object firstReadOnlyPrimitiveObject;
    @UnknownObjectField(types={Object.class})
    public Object lastReadOnlyPrimitiveObject;
    @UnknownObjectField(types={Object.class})
    public Object firstReadOnlyReferenceObject;
    @UnknownObjectField(types={Object.class})
    public Object lastReadOnlyReferenceObject;
    @UnknownObjectField(types={Object.class})
    public Object firstReadOnlyRelocatableObject;
    @UnknownObjectField(types={Object.class})
    public Object lastReadOnlyRelocatableObject;
    @UnknownObjectField(types={Object.class})
    public Object firstWritablePrimitiveObject;
    @UnknownObjectField(types={Object.class})
    public Object lastWritablePrimitiveObject;
    @UnknownObjectField(types={Object.class})
    public Object firstWritableReferenceObject;
    @UnknownObjectField(types={Object.class})
    public Object lastWritableReferenceObject;
    @UnknownObjectField(types={Object.class})
    public Object firstWritableHugeObject;
    @UnknownObjectField(types={Object.class})
    public Object lastWritableHugeObject;
    @UnknownObjectField(types={Object.class})
    public Object firstReadOnlyHugeObject;
    @UnknownObjectField(types={Object.class})
    public Object lastReadOnlyHugeObject;
    @UnknownObjectField(types={Object.class})
    public Object firstObject;
    @UnknownObjectField(types={Object.class})
    public Object lastObject;
    @UnknownPrimitiveField
    public long offsetOfFirstAlignedChunkWithRememberedSet;
    @UnknownPrimitiveField
    public long offsetOfFirstUnalignedChunkWithRememberedSet;
    @UnknownPrimitiveField
    public int dynamicHubCount;

    public void initialize(Object firstReadOnlyPrimitiveObject, Object lastReadOnlyPrimitiveObject, Object firstReadOnlyReferenceObject, Object lastReadOnlyReferenceObject, Object firstReadOnlyRelocatableObject, Object lastReadOnlyRelocatableObject, Object firstWritablePrimitiveObject, Object lastWritablePrimitiveObject, Object firstWritableReferenceObject, Object lastWritableReferenceObject, Object firstWritableHugeObject, Object lastWritableHugeObject, Object firstReadOnlyHugeObject, Object lastReadOnlyHugeObject, long offsetOfFirstAlignedChunkWithRememberedSet, long offsetOfFirstUnalignedChunkWithRememberedSet, int dynamicHubCount) {
        Object firstReadOnlyObject;
        assert (offsetOfFirstAlignedChunkWithRememberedSet == -1L || offsetOfFirstAlignedChunkWithRememberedSet >= 0L);
        assert (offsetOfFirstUnalignedChunkWithRememberedSet == -1L || offsetOfFirstUnalignedChunkWithRememberedSet >= 0L);
        this.firstReadOnlyPrimitiveObject = firstReadOnlyPrimitiveObject;
        this.lastReadOnlyPrimitiveObject = lastReadOnlyPrimitiveObject;
        this.firstReadOnlyReferenceObject = firstReadOnlyReferenceObject;
        this.lastReadOnlyReferenceObject = lastReadOnlyReferenceObject;
        this.firstReadOnlyRelocatableObject = firstReadOnlyRelocatableObject;
        this.lastReadOnlyRelocatableObject = lastReadOnlyRelocatableObject;
        this.firstWritablePrimitiveObject = firstWritablePrimitiveObject;
        this.lastWritablePrimitiveObject = lastWritablePrimitiveObject;
        this.firstWritableReferenceObject = firstWritableReferenceObject;
        this.lastWritableReferenceObject = lastWritableReferenceObject;
        this.firstWritableHugeObject = firstWritableHugeObject;
        this.lastWritableHugeObject = lastWritableHugeObject;
        this.firstReadOnlyHugeObject = firstReadOnlyHugeObject;
        this.lastReadOnlyHugeObject = lastReadOnlyHugeObject;
        this.offsetOfFirstAlignedChunkWithRememberedSet = offsetOfFirstAlignedChunkWithRememberedSet;
        this.offsetOfFirstUnalignedChunkWithRememberedSet = offsetOfFirstUnalignedChunkWithRememberedSet;
        this.dynamicHubCount = dynamicHubCount;
        Object object = firstReadOnlyPrimitiveObject != null ? firstReadOnlyPrimitiveObject : (firstReadOnlyObject = firstReadOnlyReferenceObject != null ? firstReadOnlyReferenceObject : firstReadOnlyRelocatableObject);
        Object lastReadOnlyObject = lastReadOnlyRelocatableObject != null ? lastReadOnlyRelocatableObject : (lastReadOnlyReferenceObject != null ? lastReadOnlyReferenceObject : lastReadOnlyPrimitiveObject);
        Object firstWritableObject = firstWritablePrimitiveObject != null ? firstWritablePrimitiveObject : firstWritableReferenceObject;
        Object lastWritableObject = lastWritableReferenceObject != null ? lastWritableReferenceObject : lastWritablePrimitiveObject;
        Object firstRegularObject = firstReadOnlyObject != null ? firstReadOnlyObject : firstWritableObject;
        Object lastRegularObject = lastWritableObject != null ? lastWritableObject : lastReadOnlyObject;
        Object firstHugeObject = firstWritableHugeObject != null ? firstWritableHugeObject : firstReadOnlyHugeObject;
        Object lastHugeObject = lastReadOnlyHugeObject != null ? lastReadOnlyHugeObject : lastWritableHugeObject;
        this.firstObject = firstRegularObject != null ? firstRegularObject : firstHugeObject;
        this.lastObject = lastHugeObject != null ? lastHugeObject : lastRegularObject;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean isInReadOnlyPrimitivePartition(Pointer ptr) {
        assert (ptr.isNonNull());
        return Word.objectToUntrackedPointer((Object)this.firstReadOnlyPrimitiveObject).belowOrEqual((UnsignedWord)ptr) && ptr.belowOrEqual((UnsignedWord)Word.objectToUntrackedPointer((Object)this.lastReadOnlyPrimitiveObject));
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean isInReadOnlyReferencePartition(Pointer ptr) {
        assert (ptr.isNonNull());
        return Word.objectToUntrackedPointer((Object)this.firstReadOnlyReferenceObject).belowOrEqual((UnsignedWord)ptr) && ptr.belowOrEqual((UnsignedWord)Word.objectToUntrackedPointer((Object)this.lastReadOnlyReferenceObject));
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean isInReadOnlyRelocatablePartition(Pointer ptr) {
        assert (ptr.isNonNull());
        return Word.objectToUntrackedPointer((Object)this.firstReadOnlyRelocatableObject).belowOrEqual((UnsignedWord)ptr) && ptr.belowOrEqual((UnsignedWord)Word.objectToUntrackedPointer((Object)this.lastReadOnlyRelocatableObject));
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean isInWritablePrimitivePartition(Pointer ptr) {
        assert (ptr.isNonNull());
        return Word.objectToUntrackedPointer((Object)this.firstWritablePrimitiveObject).belowOrEqual((UnsignedWord)ptr) && ptr.belowOrEqual((UnsignedWord)Word.objectToUntrackedPointer((Object)this.lastWritablePrimitiveObject));
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean isInWritableReferencePartition(Pointer ptr) {
        assert (ptr.isNonNull());
        return Word.objectToUntrackedPointer((Object)this.firstWritableReferenceObject).belowOrEqual((UnsignedWord)ptr) && ptr.belowOrEqual((UnsignedWord)Word.objectToUntrackedPointer((Object)this.lastWritableReferenceObject));
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean isInWritableHugePartition(Pointer ptr) {
        assert (ptr.isNonNull());
        return Word.objectToUntrackedPointer((Object)this.firstWritableHugeObject).belowOrEqual((UnsignedWord)ptr) && ptr.belowOrEqual((UnsignedWord)Word.objectToUntrackedPointer((Object)this.lastWritableHugeObject));
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean isInReadOnlyHugePartition(Pointer ptr) {
        assert (ptr.isNonNull());
        return Word.objectToUntrackedPointer((Object)this.firstReadOnlyHugeObject).belowOrEqual((UnsignedWord)ptr) && ptr.belowOrEqual((UnsignedWord)Word.objectToUntrackedPointer((Object)this.lastReadOnlyHugeObject));
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean isInImageHeap(Pointer objectPointer) {
        boolean result;
        if (objectPointer.isNull()) {
            result = false;
        } else {
            boolean bl = result = objectPointer.aboveOrEqual((UnsignedWord)Word.objectToUntrackedPointer((Object)this.firstObject)) && objectPointer.belowOrEqual((UnsignedWord)Word.objectToUntrackedPointer((Object)this.lastObject));
        }
        assert (result == this.isInImageHeapSlow(objectPointer));
        return result;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean isInImageHeapSlow(Pointer objectPointer) {
        boolean result = false;
        if (objectPointer.isNonNull()) {
            result |= this.isInReadOnlyPrimitivePartition(objectPointer);
            result |= this.isInReadOnlyReferencePartition(objectPointer);
            result |= this.isInReadOnlyRelocatablePartition(objectPointer);
            result |= this.isInWritablePrimitivePartition(objectPointer);
            result |= this.isInWritableReferencePartition(objectPointer);
            result |= this.isInWritableHugePartition(objectPointer);
            result |= this.isInReadOnlyHugePartition(objectPointer);
        }
        return result;
    }
}

