/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge;

import com.oracle.svm.core.SubstrateGCOptions;
import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.genscavenge.GCImpl;
import com.oracle.svm.core.genscavenge.GenScavengeGCCause;
import com.oracle.svm.core.genscavenge.HeapImpl;
import com.oracle.svm.core.genscavenge.HeapPolicyOptions;
import com.oracle.svm.core.heap.GCCause;
import com.oracle.svm.core.heap.PhysicalMemory;
import com.oracle.svm.core.heap.ReferenceAccess;
import com.oracle.svm.core.jdk.UninterruptibleUtils;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.option.XOptions;
import com.oracle.svm.core.thread.VMOperation;
import com.oracle.svm.core.util.UnsignedUtils;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.core.util.VMError;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.compiler.word.Word;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;
import org.graalvm.word.WordFactory;

public final class HeapPolicy {
    static final long LARGE_ARRAY_THRESHOLD_SENTINEL_VALUE = 0L;
    static final int ALIGNED_HEAP_CHUNK_FRACTION_FOR_LARGE_ARRAY_THRESHOLD = 8;
    private static UnsignedWord maximumYoungGenerationSize;
    private static UnsignedWord minimumHeapSize;
    private static UnsignedWord maximumHeapSize;
    private static final UnsignedWord producedHeapChunkZapInt;
    private static final UnsignedWord producedHeapChunkZapWord;
    private static final UnsignedWord consumedHeapChunkZapInt;
    private static final UnsignedWord consumedHeapChunkZapWord;
    private static final UninterruptibleUtils.AtomicUnsigned edenUsedBytes;
    private static final UninterruptibleUtils.AtomicUnsigned youngUsedBytes;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    HeapPolicy() {
        if (!SubstrateUtil.isPowerOf2(HeapPolicy.getAlignedHeapChunkSize().rawValue())) {
            throw UserError.abort("AlignedHeapChunkSize (%d) should be a power of 2.", HeapPolicy.getAlignedHeapChunkSize().rawValue());
        }
        if (!HeapPolicy.getLargeArrayThreshold().belowOrEqual(HeapPolicy.getAlignedHeapChunkSize())) {
            throw UserError.abort("LargeArrayThreshold (%d) should be below or equal to AlignedHeapChunkSize (%d).", HeapPolicy.getLargeArrayThreshold().rawValue(), HeapPolicy.getAlignedHeapChunkSize().rawValue());
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static Word getProducedHeapChunkZapWord() {
        return (Word)producedHeapChunkZapWord;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static int getProducedHeapChunkZapInt() {
        return (int)producedHeapChunkZapInt.rawValue();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static Word getConsumedHeapChunkZapWord() {
        return (Word)consumedHeapChunkZapWord;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static int getConsumedHeapChunkZapInt() {
        return (int)consumedHeapChunkZapInt.rawValue();
    }

    public static UnsignedWord m(long bytes) {
        assert (0L <= bytes);
        return WordFactory.unsigned((long)bytes).multiply(1024).multiply(1024);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static int getMaxSurvivorSpaces() {
        return HeapPolicyOptions.MaxSurvivorSpaces.getValue();
    }

    public static UnsignedWord getMaximumYoungGenerationSize() {
        UnsignedWord maxSize;
        Log trace = Log.noopLog().string("[HeapPolicy.getMaximumYoungGenerationSize:");
        if (maximumYoungGenerationSize.aboveThan((UnsignedWord)WordFactory.zero())) {
            trace.string("  returns maximumYoungGenerationSize: ").unsigned((WordBase)maximumYoungGenerationSize).string(" ]").newline();
            return maximumYoungGenerationSize;
        }
        XOptions.XFlag xmn = XOptions.getXmn();
        if (xmn.getEpoch() > 0L) {
            trace.string("  -Xmn.epoch: ").unsigned(xmn.getEpoch()).string("  -Xmn.value: ").unsigned(xmn.getValue());
            HeapPolicy.setMaximumYoungGenerationSize(WordFactory.unsigned((long)xmn.getValue()));
            trace.string("  returns: ").unsigned((WordBase)maximumYoungGenerationSize).string(" ]").newline();
            return maximumYoungGenerationSize;
        }
        long hostedValue = SubstrateGCOptions.MaxNewSize.getHostedValue();
        if (hostedValue != 0L) {
            trace.string("  returns maximumYoungGenerationSize: ").unsigned(hostedValue).string(" ]").newline();
            return WordFactory.unsigned((long)hostedValue);
        }
        UnsignedWord maxHeapSize = HeapPolicy.getMaximumHeapSize();
        UnsignedWord youngSizeAsFraction = maxHeapSize.unsignedDivide(100).multiply(HeapPolicy.getMaximumYoungGenerationSizePercent());
        UnsignedWord youngSize = youngSizeAsFraction.belowOrEqual(maxSize = HeapPolicy.m(256L)) ? youngSizeAsFraction : maxSize;
        trace.string("  youngSize: ").unsigned((WordBase)youngSize).string(" ]").newline();
        return youngSize;
    }

    private static int getMaximumYoungGenerationSizePercent() {
        int result = HeapPolicyOptions.MaximumYoungGenerationSizePercent.getValue();
        VMError.guarantee(result >= 0 && result <= 100, "MaximumYoungGenerationSizePercent should be in [0 ..100]");
        return result;
    }

    public static UnsignedWord setMaximumYoungGenerationSize(UnsignedWord value) {
        UnsignedWord result = maximumYoungGenerationSize;
        maximumYoungGenerationSize = value;
        return result;
    }

    public static UnsignedWord getMaximumHeapSize() {
        if (maximumHeapSize.aboveThan((UnsignedWord)WordFactory.zero())) {
            return maximumHeapSize;
        }
        XOptions.XFlag xmx = XOptions.getXmx();
        if (xmx.getEpoch() > 0L) {
            HeapPolicy.setMaximumHeapSize(WordFactory.unsigned((long)xmx.getValue()));
            return maximumHeapSize;
        }
        long hostedValue = SubstrateGCOptions.MaxHeapSize.getHostedValue();
        if (hostedValue != 0L) {
            return WordFactory.unsigned((long)hostedValue);
        }
        UnsignedWord addressSpaceSize = HeapPolicy.getAddressSpaceSize();
        if (PhysicalMemory.isInitialized()) {
            UnsignedWord physicalMemorySize = PhysicalMemory.getCachedSize();
            int maximumHeapSizePercent = HeapPolicy.getMaximumHeapSizePercent();
            UnsignedWord result = physicalMemorySize.unsignedDivide(100).multiply(maximumHeapSizePercent);
            if (result.belowThan(addressSpaceSize)) {
                return result;
            }
        }
        return addressSpaceSize;
    }

    private static UnsignedWord getAddressSpaceSize() {
        int compressionShift = ReferenceAccess.singleton().getCompressEncoding().getShift();
        if (compressionShift > 0) {
            int referenceSize = ConfigurationValues.getObjectLayout().getReferenceSize();
            return WordFactory.unsigned((long)(1L << referenceSize * 8)).shiftLeft(compressionShift);
        }
        return UnsignedUtils.MAX_VALUE;
    }

    private static int getMaximumHeapSizePercent() {
        int result = HeapPolicyOptions.MaximumHeapSizePercent.getValue();
        VMError.guarantee(result >= 0 && result <= 100, "MaximumHeapSizePercent should be in [0 ..100]");
        return result;
    }

    public static UnsignedWord setMaximumHeapSize(UnsignedWord value) {
        Log trace = Log.noopLog().string("[HeapPolicy.setMaximumHeapSize:");
        UnsignedWord result = maximumHeapSize;
        maximumHeapSize = value;
        trace.string("  old: ").unsigned((WordBase)result).string("  new: ").unsigned((WordBase)maximumHeapSize).string(" ]").newline();
        return result;
    }

    public static UnsignedWord getMinimumHeapSize() {
        Log trace = Log.noopLog().string("[HeapPolicy.getMinimumHeapSize:");
        if (minimumHeapSize.aboveThan((UnsignedWord)WordFactory.zero())) {
            trace.string("  returns: ").unsigned((WordBase)minimumHeapSize).string(" ]").newline();
            return minimumHeapSize;
        }
        XOptions.XFlag xms = XOptions.getXms();
        if (xms.getEpoch() > 0L) {
            trace.string("  -Xms.epoch: ").unsigned(xms.getEpoch()).string("  -Xms.value: ").unsigned(xms.getValue());
            HeapPolicy.setMinimumHeapSize(WordFactory.unsigned((long)xms.getValue()));
            trace.string("  returns: ").unsigned((WordBase)minimumHeapSize).string(" ]").newline();
            return minimumHeapSize;
        }
        long hostedValue = SubstrateGCOptions.MinHeapSize.getHostedValue();
        if (hostedValue != 0L) {
            trace.string("  returns: ").unsigned(hostedValue).string(" ]").newline();
            return WordFactory.unsigned((long)hostedValue);
        }
        UnsignedWord result = HeapPolicy.getMaximumYoungGenerationSize().multiply(2);
        if (result.aboveThan(HeapPolicy.getMaximumHeapSize())) {
            result = HeapPolicy.getMaximumHeapSize();
        }
        trace.string("  returns: ").unsigned((WordBase)result).string(" ]").newline();
        return result;
    }

    public static UnsignedWord setMinimumHeapSize(UnsignedWord value) {
        UnsignedWord result = minimumHeapSize;
        minimumHeapSize = value;
        return result;
    }

    @Fold
    public static UnsignedWord getAlignedHeapChunkSize() {
        return WordFactory.unsigned((long)HeapPolicyOptions.AlignedHeapChunkSize.getValue());
    }

    @Fold
    static UnsignedWord getAlignedHeapChunkAlignment() {
        return HeapPolicy.getAlignedHeapChunkSize();
    }

    @Fold
    public static UnsignedWord getLargeArrayThreshold() {
        long largeArrayThreshold = HeapPolicyOptions.LargeArrayThreshold.getValue();
        if (0L == largeArrayThreshold) {
            return HeapPolicy.getAlignedHeapChunkSize().unsignedDivide(8);
        }
        return WordFactory.unsigned((long)HeapPolicyOptions.LargeArrayThreshold.getValue());
    }

    public static boolean getZapProducedHeapChunks() {
        return HeapPolicyOptions.ZapChunks.getValue() != false || HeapPolicyOptions.ZapProducedHeapChunks.getValue() != false;
    }

    public static boolean getZapConsumedHeapChunks() {
        return HeapPolicyOptions.ZapChunks.getValue() != false || HeapPolicyOptions.ZapConsumedHeapChunks.getValue() != false;
    }

    public static void setEdenAndYoungGenBytes(UnsignedWord edenBytes, UnsignedWord youngBytes) {
        assert (VMOperation.isGCInProgress()) : "would cause races otherwise";
        youngUsedBytes.set(youngBytes);
        edenUsedBytes.set(edenBytes);
    }

    public static void increaseEdenUsedBytes(UnsignedWord value) {
        youngUsedBytes.addAndGet(value);
        edenUsedBytes.addAndGet(value);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static UnsignedWord getYoungUsedBytes() {
        assert (!VMOperation.isGCInProgress()) : "value is incorrect during a GC";
        return (UnsignedWord)youngUsedBytes.get();
    }

    public static UnsignedWord getEdenUsedBytes() {
        assert (!VMOperation.isGCInProgress()) : "value is incorrect during a GC";
        return (UnsignedWord)edenUsedBytes.get();
    }

    private static UnsignedWord getAllocationBeforePhysicalMemorySize() {
        return WordFactory.unsigned((long)HeapPolicyOptions.AllocationBeforePhysicalMemorySize.getValue());
    }

    public static void maybeCollectOnAllocation() {
        UnsignedWord maxYoungSize = HeapPolicy.getMaximumYoungGenerationSize();
        HeapPolicy.maybeCollectOnAllocation(maxYoungSize);
    }

    @Uninterruptible(reason="Avoid races with other threads that also try to trigger a GC")
    private static void maybeCollectOnAllocation(UnsignedWord maxYoungSize) {
        if (((UnsignedWord)youngUsedBytes.get()).aboveOrEqual(maxYoungSize)) {
            GCImpl.getGCImpl().collectWithoutAllocating(GenScavengeGCCause.OnAllocation, false);
        }
    }

    public static void maybeCauseUserRequestedCollection() {
        if (!SubstrateGCOptions.DisableExplicitGC.getValue().booleanValue()) {
            HeapImpl.getHeapImpl().getGC().collectCompletely(GCCause.JavaLangSystemGC);
        }
    }

    static void samplePhysicalMemorySize() {
        if (HeapImpl.getHeapImpl().getGCImpl().getCollectionEpoch().equal((UnsignedWord)WordFactory.zero()) && HeapPolicy.getYoungUsedBytes().aboveThan(HeapPolicy.getAllocationBeforePhysicalMemorySize())) {
            PhysicalMemory.tryInitialize();
        }
    }

    static {
        Word.ensureInitialized();
        producedHeapChunkZapInt = WordFactory.unsigned((int)-1163018513);
        producedHeapChunkZapWord = producedHeapChunkZapInt.shiftLeft(32).or(producedHeapChunkZapInt);
        consumedHeapChunkZapInt = WordFactory.unsigned((int)-559038737);
        consumedHeapChunkZapWord = consumedHeapChunkZapInt.shiftLeft(32).or(consumedHeapChunkZapInt);
        edenUsedBytes = new UninterruptibleUtils.AtomicUnsigned();
        youngUsedBytes = new UninterruptibleUtils.AtomicUnsigned();
    }

    public static final class TestingBackDoor {
        private TestingBackDoor() {
        }

        public static long getUnalignedObjectSize() {
            return HeapPolicy.getLargeArrayThreshold().rawValue();
        }
    }
}

