/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core;

import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.util.VMError;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.word.PointerBase;

public interface RegisterDumper {
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static RegisterDumper singleton() {
        if (!ImageSingletons.contains(RegisterDumper.class)) {
            throw VMError.shouldNotReachHere();
        }
        return (RegisterDumper)ImageSingletons.lookup(RegisterDumper.class);
    }

    public static void dumpReg(Log log, String label, long value) {
        log.string(label).zhex(value).newline();
    }

    public void dumpRegisters(Log var1, Context var2);

    public PointerBase getHeapBase(Context var1);

    public PointerBase getThreadPointer(Context var1);

    public PointerBase getSP(Context var1);

    public PointerBase getIP(Context var1);

    public static interface Context
    extends PointerBase {
    }
}

