/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.phases;

import com.oracle.svm.core.graal.nodes.DeadEndNode;
import com.oracle.svm.core.heap.RestrictHeapAccessCallees;
import com.oracle.svm.core.meta.SubstrateObjectConstant;
import com.oracle.svm.core.snippets.FatalAssertions;
import com.oracle.svm.core.snippets.SnippetRuntime;
import java.lang.reflect.Executable;
import java.util.HashMap;
import java.util.Map;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.core.common.spi.ForeignCallDescriptor;
import org.graalvm.compiler.core.common.spi.ForeignCallsProvider;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.extended.ForeignCallNode;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import org.graalvm.compiler.nodes.graphbuilderconf.NodePlugin;
import org.graalvm.nativeimage.ImageSingletons;

final class FatalAssertionsNodePlugin
implements NodePlugin {
    private final MetaAccessProvider metaAccess;
    private final ForeignCallsProvider foreignCalls;
    private final ResolvedJavaType assertionErrorType;
    private final HashMap<ResolvedJavaMethod, SnippetRuntime.SubstrateForeignCallDescriptor> assertionConstructorReplacements;
    private static final AssertionError CACHED_ASSERTION_ERROR = new AssertionError();

    FatalAssertionsNodePlugin(MetaAccessProvider metaAccess, ForeignCallsProvider foreignCalls) {
        this.metaAccess = metaAccess;
        this.foreignCalls = foreignCalls;
        this.assertionErrorType = metaAccess.lookupJavaType(AssertionError.class);
        this.assertionConstructorReplacements = new HashMap();
        for (Map.Entry<Executable, SnippetRuntime.SubstrateForeignCallDescriptor> entry : FatalAssertions.FOREIGN_CALLS.entrySet()) {
            this.assertionConstructorReplacements.put(metaAccess.lookupJavaMethod(entry.getKey()), entry.getValue());
        }
    }

    public boolean handleNewInstance(GraphBuilderContext b, ResolvedJavaType type) {
        if (type.equals(this.assertionErrorType) && !b.parsingIntrinsic() && FatalAssertionsNodePlugin.methodMustNotAllocate(b)) {
            b.push(JavaKind.Object, (ValueNode)ConstantNode.forConstant((JavaConstant)SubstrateObjectConstant.forObject(CACHED_ASSERTION_ERROR), (MetaAccessProvider)this.metaAccess, (StructuredGraph)b.getGraph()));
            return true;
        }
        return false;
    }

    public boolean handleInvoke(GraphBuilderContext b, ResolvedJavaMethod method, ValueNode[] args) {
        SnippetRuntime.SubstrateForeignCallDescriptor descriptor = this.assertionConstructorReplacements.get(method);
        if (descriptor != null && !b.parsingIntrinsic() && FatalAssertionsNodePlugin.methodMustNotAllocate(b)) {
            b.add((ValueNode)new ForeignCallNode(this.foreignCalls, (ForeignCallDescriptor)descriptor, args));
            b.add((ValueNode)new DeadEndNode());
            return true;
        }
        return false;
    }

    private static boolean methodMustNotAllocate(GraphBuilderContext b) {
        return ((RestrictHeapAccessCallees)ImageSingletons.lookup(RestrictHeapAccessCallees.class)).mustNotAllocate(b.getMethod());
    }
}

