/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.image.sources;

import com.oracle.svm.hosted.image.sources.SourceCache;
import com.oracle.svm.hosted.image.sources.SourceCacheType;
import com.oracle.svm.hosted.image.sources.SourceManager;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;

public class GraalVMSourceCache
extends SourceCache {
    protected GraalVMSourceCache() {
        this.initSrcRoots();
    }

    @Override
    protected final SourceCacheType getType() {
        return SourceCacheType.GRAALVM;
    }

    private void initSrcRoots() {
        for (String classPathEntry : classPathEntries) {
            this.tryClassPathRoot(classPathEntry);
        }
        for (String sourcePathEntry : sourcePathEntries) {
            this.trySourceRoot(sourcePathEntry);
        }
    }

    private void tryClassPathRoot(String classPathEntry) {
        this.trySourceRoot(classPathEntry, true);
    }

    private void trySourceRoot(String sourcePathEntry) {
        this.trySourceRoot(sourcePathEntry, false);
    }

    private void trySourceRoot(String sourceRoot, boolean fromClassPath) {
        block12: {
            try {
                Path sourcePath = Paths.get(sourceRoot, new String[0]);
                String fileNameString = sourcePath.getFileName().toString();
                if (fileNameString.endsWith(".jar") || fileNameString.endsWith(".src.zip")) {
                    Path srcPath;
                    if (fromClassPath && fileNameString.endsWith(".jar")) {
                        int length = fileNameString.length();
                        fileNameString = fileNameString.substring(0, length - 3) + "src.zip";
                    }
                    if (!(srcPath = sourcePath.getParent().resolve(fileNameString)).toFile().exists()) break block12;
                    try {
                        FileSystem fileSystem = FileSystems.newFileSystem(srcPath, (ClassLoader)null);
                        for (Path root : fileSystem.getRootDirectories()) {
                            if (!GraalVMSourceCache.filterSrcRoot(root)) continue;
                            this.srcRoots.add(root);
                        }
                        break block12;
                    }
                    catch (IOException | FileSystemNotFoundException exception) {
                        break block12;
                    }
                }
                if (fromClassPath) {
                    Path srcPath = sourcePath.resolve("src");
                    if (GraalVMSourceCache.filterSrcRoot(srcPath)) {
                        this.srcRoots.add(srcPath);
                    }
                    if (GraalVMSourceCache.filterSrcRoot(srcPath = sourcePath.resolve("src_gen"))) {
                        this.srcRoots.add(srcPath);
                    }
                } else if (GraalVMSourceCache.filterSrcRoot(sourcePath)) {
                    this.srcRoots.add(sourcePath);
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }

    private static boolean filterSrcRoot(Path root) {
        String separator = root.getFileSystem().getSeparator();
        for (String prefix : SourceManager.GRAALVM_SRC_PACKAGE_PREFIXES) {
            String subDir = prefix.replaceAll("\\.", separator);
            if (!Files.isDirectory(root.resolve(subDir), new LinkOption[0])) continue;
            return true;
        }
        return false;
    }
}

