/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.image;

import com.oracle.graal.pointsto.constraints.UnsupportedFeatureException;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.annotate.AutomaticFeature;
import com.oracle.svm.core.image.DisallowedImageHeapObjects;
import com.oracle.svm.core.option.SubstrateOptionsParser;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.classinitialization.ClassInitializationFeature;
import com.oracle.svm.hosted.classinitialization.ClassInitializationSupport;
import com.oracle.svm.util.ImageGeneratorThreadMarker;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticFeature
public class DisallowedImageHeapObjectFeature
implements Feature {
    private ClassInitializationSupport classInitialization;
    private String[] disallowedSubstrings;
    private Map<byte[], Charset> disallowedByteSubstrings;

    public void duringSetup(Feature.DuringSetupAccess access) {
        this.classInitialization = ((FeatureImpl.DuringSetupAccessImpl)access).getHostVM().getClassInitializationSupport();
        access.registerObjectReplacer(this::replacer);
        if (SubstrateOptions.DetectUserDirectoriesInImageHeap.getValue().booleanValue()) {
            this.disallowedSubstrings = new String[]{System.getProperty("user.home"), System.getProperty("user.dir"), System.getProperty("java.home")};
            HashSet<Charset> encodings = new HashSet<Charset>(Arrays.asList(StandardCharsets.UTF_8, StandardCharsets.UTF_16, Charset.forName(System.getProperty("sun.jnu.encoding"))));
            this.disallowedByteSubstrings = new IdentityHashMap<byte[], Charset>();
            for (int i = 0; i < this.disallowedSubstrings.length; ++i) {
                String s = this.disallowedSubstrings[i];
                for (Charset encoding : encodings) {
                    this.disallowedByteSubstrings.put(s.getBytes(encoding), encoding);
                }
            }
        }
    }

    private Object replacer(Object original) {
        if (original instanceof Thread && original instanceof ImageGeneratorThreadMarker) {
            return ((ImageGeneratorThreadMarker)original).asTerminated();
        }
        if (original instanceof String && this.disallowedSubstrings != null) {
            String string = (String)original;
            for (String disallowedSubstring : this.disallowedSubstrings) {
                if (!string.contains(disallowedSubstring)) continue;
                throw new UnsupportedFeatureException("Detected a string in the image heap that contains a user directory. This means that file system information from the native image build is persisted and available at image run time, which is most likely an error." + System.lineSeparator() + "String that is problematic: " + string + System.lineSeparator() + "Disallowed substring with user directory: " + (String)disallowedSubstring + System.lineSeparator() + "This check can be disabled using the option " + SubstrateOptionsParser.commandArgument(SubstrateOptions.DetectUserDirectoriesInImageHeap, "-"));
            }
        }
        if (original instanceof byte[] && this.disallowedByteSubstrings != null) {
            byte[] bytes = (byte[])original;
            for (Map.Entry entry : this.disallowedByteSubstrings.entrySet()) {
                byte[] disallowedSubstring = (byte[])entry.getKey();
                if (!DisallowedImageHeapObjectFeature.search(bytes, disallowedSubstring)) continue;
                Charset charset = (Charset)entry.getValue();
                throw new UnsupportedFeatureException("Detected a byte[] in the image heap that contains a user directory. This means that file system information from the native image build is persisted and available at image run time, which is most likely an error." + System.lineSeparator() + "byte[] that is problematic: " + new String(bytes, charset) + System.lineSeparator() + "Disallowed substring with user directory: " + new String(disallowedSubstring, charset) + System.lineSeparator() + "This check can be disabled using the option " + SubstrateOptionsParser.commandArgument(SubstrateOptions.DetectUserDirectoriesInImageHeap, "-"));
            }
        }
        DisallowedImageHeapObjects.check(original, this::error);
        return original;
    }

    private RuntimeException error(String msg, Object obj, String initializerAction) {
        throw new UnsupportedFeatureException(msg + " " + this.classInitialization.objectInstantiationTraceMessage(obj, initializerAction) + " The object was probably created by a class initializer and is reachable from a static field. You can request class initialization at image run time by using the option " + SubstrateOptionsParser.commandArgument(ClassInitializationFeature.Options.ClassInitialization, "<class-name>", "initialize-at-run-time") + ". Or you can write your own initialization methods and call them explicitly from your main entry point.");
    }

    private static boolean search(byte[] haystack, byte[] needle) {
        byte first = needle[0];
        for (int start = 0; start < haystack.length - needle.length; ++start) {
            if (haystack[start] != first) continue;
            boolean same = true;
            for (int i = 1; i < needle.length; ++i) {
                if (haystack[start + i] == needle[i]) continue;
                same = false;
                break;
            }
            if (!same) continue;
            return true;
        }
        return false;
    }
}

