/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.dashboard;

import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.code.CompileQueue;
import com.oracle.svm.hosted.dashboard.DashboardDumpFeature;
import com.oracle.svm.hosted.meta.HostedMethod;
import java.util.ArrayList;
import java.util.Collection;
import org.graalvm.nativeimage.hosted.Feature;

class CodeBreakdownDumper {
    CodeBreakdownDumper() {
    }

    DashboardDumpFeature.Dict dump(Feature.AfterCompilationAccess access) {
        FeatureImpl.AfterCompilationAccessImpl config = (FeatureImpl.AfterCompilationAccessImpl)access;
        Collection<CompileQueue.CompileTask> compilationTasks = config.getCompilationTasks();
        ArrayList<DashboardDumpFeature.Dict> methodInfos = new ArrayList<DashboardDumpFeature.Dict>(compilationTasks.size());
        for (CompileQueue.CompileTask task : compilationTasks) {
            DashboardDumpFeature.Dict methodInfo = new DashboardDumpFeature.Dict();
            HostedMethod method = task.method;
            int targetSize = task.result.getTargetCodeSize();
            methodInfo.insert("name", method.format("%H.%n(%p) %r"));
            methodInfo.insert("size", targetSize);
            methodInfos.add(methodInfo);
        }
        DashboardDumpFeature.Dict breakdown = new DashboardDumpFeature.Dict();
        breakdown.insert("code-size", methodInfos);
        return breakdown;
    }
}

