/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.VM;
import com.oracle.svm.core.annotate.AutomaticFeature;
import com.oracle.svm.core.c.CGlobalDataFactory;
import com.oracle.svm.core.c.libc.LibCBase;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.c.CGlobalDataFeature;
import com.oracle.svm.hosted.c.NativeLibraries;
import com.oracle.svm.hosted.c.codegen.CCompilerInvoker;
import java.lang.reflect.Field;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.stream.Collectors;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticFeature
public class VMFeature
implements Feature {
    private NativeLibraries nativeLibraries;

    public void beforeAnalysis(Feature.BeforeAnalysisAccess a) {
        if (SubstrateOptions.DumpTargetInfo.getValue().booleanValue()) {
            System.out.println("# Building image for target platform: " + ((Platform)ImageSingletons.lookup(Platform.class)).getClass().getName());
            if (ImageSingletons.contains(CCompilerInvoker.class)) {
                System.out.println("# Using native toolchain:");
                ((CCompilerInvoker)ImageSingletons.lookup(CCompilerInvoker.class)).compilerInfo.dump(x -> System.out.println("#   " + x));
            }
            System.out.println("# Using CLibrary: " + ((LibCBase)ImageSingletons.lookup(LibCBase.class)).getClass().getName());
        }
        FeatureImpl.BeforeAnalysisAccessImpl access = (FeatureImpl.BeforeAnalysisAccessImpl)a;
        String fieldName = "VERSION_INFO";
        try {
            Field declaredField = VM.class.getDeclaredField(fieldName);
            access.registerAsRead(access.getMetaAccess().lookupJavaField(declaredField));
        }
        catch (NoSuchFieldException e) {
            VMError.shouldNotReachHere(VM.class.getName() + " should have field " + fieldName);
        }
        this.nativeLibraries = access.getNativeLibraries();
    }

    public void afterAnalysis(Feature.AfterAnalysisAccess access) {
        VMFeature.addCGlobalDataString("Target.Platform", ((Platform)ImageSingletons.lookup(Platform.class)).getClass().getName());
        VMFeature.addCGlobalDataString("Target.LibC", ((LibCBase)ImageSingletons.lookup(LibCBase.class)).getClass().getName());
        VMFeature.addCGlobalDataString("Target.Libraries", String.join((CharSequence)"|", this.nativeLibraries.getLibraries()));
        VMFeature.addCGlobalDataString("Target.StaticLibraries", this.nativeLibraries.getStaticLibraries().stream().map(Path::getFileName).map(Path::toString).collect(Collectors.joining("|")));
        if (ImageSingletons.contains(CCompilerInvoker.class)) {
            VMFeature.addCGlobalDataString("Target.CCompiler", ((CCompilerInvoker)ImageSingletons.lookup(CCompilerInvoker.class)).compilerInfo.toString());
        }
        if (SubstrateOptions.DumpTargetInfo.getValue().booleanValue()) {
            System.out.println("# Static libraries:");
            Path current = Paths.get(".", new String[0]).toAbsolutePath();
            this.nativeLibraries.getStaticLibraries().stream().map(current::relativize).map(Path::toString).forEach(x -> System.out.println("#   " + x));
            System.out.println("# Other libraries: " + String.join((CharSequence)",", this.nativeLibraries.getLibraries()));
        }
    }

    private static void addCGlobalDataString(String infoType, String content) {
        String data = VM.class.getName() + "." + infoType + "=" + content;
        String symbolName = "__svm_vm_" + infoType.toLowerCase().replace(".", "_");
        CGlobalDataFeature.singleton().registerAsAccessedOrGet(CGlobalDataFactory.createCString(data, symbolName));
    }
}

