/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.windows;

import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.os.OSCommittedMemoryProvider;
import com.oracle.svm.core.os.VirtualMemoryProvider;
import com.oracle.svm.core.util.PointerUtils;
import com.oracle.svm.core.windows.headers.MemoryAPI;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.c.struct.SizeOf;
import org.graalvm.word.ComparableWord;
import org.graalvm.word.Pointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordFactory;

public class WindowsOSCommittedMemoryProvider
extends OSCommittedMemoryProvider {
    @Override
    public Pointer allocate(UnsignedWord size, UnsignedWord alignment, boolean executable) {
        if (alignment.belowOrEqual(WindowsOSCommittedMemoryProvider.defaultAlignment())) {
            return this.allocate(size, executable);
        }
        UnsignedWord containerSize = WindowsOSCommittedMemoryProvider.getContainerSize(size, alignment);
        Pointer containerStart = VirtualMemoryProvider.get().reserve(containerSize);
        if (containerStart.isNull()) {
            return (Pointer)WordFactory.nullPointer();
        }
        Pointer start = PointerUtils.roundUp((PointerBase)containerStart, alignment);
        if (VirtualMemoryProvider.get().commit((PointerBase)start, size, WindowsOSCommittedMemoryProvider.defaultProtection(executable)).isNull()) {
            VirtualMemoryProvider.get().free((PointerBase)containerStart, containerSize);
            return (Pointer)WordFactory.nullPointer();
        }
        return start;
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean free(PointerBase start, UnsignedWord size, UnsignedWord alignment, boolean executable) {
        PointerBase containerStart;
        if (alignment.belowOrEqual(WindowsOSCommittedMemoryProvider.defaultAlignment())) {
            containerStart = start;
        } else {
            MemoryAPI.MEMORY_BASIC_INFORMATION memoryInfo = (MemoryAPI.MEMORY_BASIC_INFORMATION)StackValue.get(MemoryAPI.MEMORY_BASIC_INFORMATION.class);
            MemoryAPI.VirtualQuery(start, memoryInfo, SizeOf.unsigned(MemoryAPI.MEMORY_BASIC_INFORMATION.class));
            assert (start.equal((ComparableWord)memoryInfo.BaseAddress())) : "Invalid memory block start";
            containerStart = memoryInfo.AllocationBase();
        }
        return this.free(containerStart, WindowsOSCommittedMemoryProvider.getContainerSize(size, alignment));
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static UnsignedWord getContainerSize(UnsignedWord size, UnsignedWord alignment) {
        return alignment.belowOrEqual(WindowsOSCommittedMemoryProvider.defaultAlignment()) ? size : size.add(alignment);
    }
}

