/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.nodes;

import com.oracle.svm.core.nodes.CFunctionEpilogueMarker;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.nodeinfo.InputType;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.AbstractStateSplit;
import org.graalvm.compiler.nodes.DeoptimizingNode;
import org.graalvm.compiler.nodes.FrameState;
import org.graalvm.compiler.nodes.debug.ControlFlowAnchored;
import org.graalvm.compiler.nodes.memory.SingleMemoryKill;
import org.graalvm.compiler.nodes.spi.Lowerable;
import org.graalvm.compiler.nodes.spi.LoweringTool;
import org.graalvm.word.LocationIdentity;

@NodeInfo(cycles=NodeCycles.CYCLES_8, size=NodeSize.SIZE_8, allowedUsageTypes={InputType.Memory})
public final class CFunctionEpilogueNode
extends AbstractStateSplit
implements Lowerable,
SingleMemoryKill,
ControlFlowAnchored,
DeoptimizingNode.DeoptBefore {
    public static final NodeClass<CFunctionEpilogueNode> TYPE = NodeClass.create(CFunctionEpilogueNode.class);
    private final int oldThreadStatus;
    private CFunctionEpilogueMarker marker;
    @Node.OptionalInput(value=InputType.State)
    protected FrameState stateBefore;

    public CFunctionEpilogueNode(int oldThreadStatus) {
        super(TYPE, StampFactory.forVoid());
        this.oldThreadStatus = oldThreadStatus;
        this.marker = new CFunctionEpilogueMarker();
    }

    protected void afterClone(Node other) {
        super.afterClone(other);
        this.marker = new CFunctionEpilogueMarker();
    }

    public CFunctionEpilogueMarker getMarker() {
        return this.marker;
    }

    public void lower(LoweringTool tool) {
        tool.getLowerer().lower((Node)this, tool);
    }

    public LocationIdentity getKilledLocationIdentity() {
        return LocationIdentity.any();
    }

    public int getOldThreadStatus() {
        return this.oldThreadStatus;
    }

    @Node.NodeIntrinsic
    public static native void cFunctionEpilogue(@Node.ConstantNodeParameter int var0);

    public boolean canDeoptimize() {
        return true;
    }

    public void setStateBefore(FrameState state) {
        this.updateUsages((Node)this.stateBefore, (Node)state);
        this.stateBefore = state;
    }

    public FrameState stateBefore() {
        return this.stateBefore;
    }

    public boolean canUseAsStateDuring() {
        return true;
    }
}

