/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.heap;

import com.oracle.svm.core.annotate.RestrictHeapAccess;
import com.oracle.svm.core.heap.Heap;
import com.oracle.svm.core.jdk.UninterruptibleUtils;
import com.oracle.svm.core.thread.JavaThreads;
import com.oracle.svm.core.thread.VMOperation;
import com.oracle.svm.core.util.UnsignedUtils;
import com.oracle.svm.core.util.VMError;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.word.UnsignedWord;

public class PhysicalMemory {
    private static final UnsignedWord UNSET_SENTINEL = UnsignedUtils.MAX_VALUE;
    static UninterruptibleUtils.AtomicInteger initializing = new UninterruptibleUtils.AtomicInteger(0);
    private static UnsignedWord cachedSize = UNSET_SENTINEL;

    public static UnsignedWord size() {
        if (PhysicalMemory.isInitializationDisallowed()) {
            throw VMError.shouldNotReachHere("Accessing the physical memory size requires allocation and synchronization");
        }
        if (!PhysicalMemory.isInitialized()) {
            initializing.incrementAndGet();
            try {
                PhysicalMemory.doInitialize();
            }
            finally {
                initializing.decrementAndGet();
            }
        }
        return cachedSize;
    }

    public static void tryInitialize() {
        if (PhysicalMemory.isInitialized() || PhysicalMemory.isInitializationDisallowed()) {
            return;
        }
        if (initializing.compareAndSet(0, 1)) {
            try {
                PhysicalMemory.doInitialize();
            }
            finally {
                initializing.decrementAndGet();
            }
        }
    }

    public static boolean isInitialized() {
        return cachedSize != UNSET_SENTINEL;
    }

    public static UnsignedWord getCachedSize() {
        VMError.guarantee(PhysicalMemory.isInitialized(), "Cached physical memory size is not available");
        return cachedSize;
    }

    private static boolean isInitializationDisallowed() {
        return Heap.getHeap().isAllocationDisallowed() || VMOperation.isInProgress() || !JavaThreads.currentJavaThreadInitialized();
    }

    @RestrictHeapAccess(access=RestrictHeapAccess.Access.UNRESTRICTED, overridesCallers=true, reason="Only called if allocation is allowed.")
    private static void doInitialize() {
        cachedSize = ((PhysicalMemorySupport)ImageSingletons.lookup(PhysicalMemorySupport.class)).size();
    }

    protected static interface PhysicalMemorySupport {
        default public boolean hasSize() {
            throw VMError.shouldNotReachHere("Unused, will be removed");
        }

        public UnsignedWord size();
    }
}

