/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.heap;

import com.oracle.svm.core.heap.Heap;
import com.oracle.svm.core.heap.ObjectVisitor;
import com.oracle.svm.core.hub.LayoutEncoding;
import com.oracle.svm.core.log.Log;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;

public class ClassHistogramVisitor
implements ObjectVisitor {
    protected final List<Class<?>> classList = Heap.getHeap().getClassList();
    protected final HistogramEntry[] entryArray = new HistogramEntry[this.classList.size()];

    public static ClassHistogramVisitor factory() {
        return new ClassHistogramVisitor();
    }

    protected ClassHistogramVisitor() {
        this.initializeFromClassList();
    }

    @Override
    public boolean visitObject(Object o) {
        HistogramEntry entry = this.findEntry(o.getClass().getName());
        if (entry == null) {
            return false;
        }
        ++entry.instanceCount;
        entry.instanceSpace += LayoutEncoding.getSizeFromObject(o).rawValue();
        return true;
    }

    public void prologue() {
        this.reset();
    }

    public void epilogue() {
    }

    private HistogramEntry findEntry(String s) {
        for (int index = 0; index < this.entryArray.length; ++index) {
            if (!this.entryArray[index].getClassName().equals(s)) continue;
            return this.entryArray[index];
        }
        return null;
    }

    public void reset() {
        for (int index = 0; index < this.entryArray.length; ++index) {
            this.entryArray[index].reset();
        }
    }

    public void toLogByName(Log log, long minimum) {
        HistogramEntry[] filteredArray = this.filterEntries(minimum);
        Arrays.sort(filteredArray, HistogramEntry.byName);
        this.toLog(log, filteredArray);
    }

    public void toLogByCount(Log log, long minimum) {
        this.toLogByCount(log, minimum, true);
    }

    public void toLogByCount(Log log, long minimum, boolean increasing) {
        HistogramEntry[] filteredArray = this.filterEntries(minimum);
        Arrays.sort(filteredArray, increasing ? HistogramEntry.byIncreasingCount : HistogramEntry.byDecreasingCount);
        this.toLog(log, filteredArray);
    }

    public void toLogBySpace(Log log, long minimum) {
        this.toLogBySpace(log, minimum, true);
    }

    public void toLogBySpace(Log log, long minimum, boolean increasing) {
        HistogramEntry[] filteredArray = this.filterEntries(minimum);
        Arrays.sort(filteredArray, increasing ? HistogramEntry.byIncreasingSpace : HistogramEntry.byDecreasingSpace);
        this.toLog(log, filteredArray);
    }

    protected void toLog(Log log, HistogramEntry[] entry) {
        if (entry.length != 0) {
            log.string("  Count\tSize\tName").newline();
        }
        for (HistogramEntry e : entry) {
            this.toLog(log, e);
        }
    }

    protected void toLog(Log log, HistogramEntry entry) {
        log.string("  ");
        log.signed(entry.getInstanceCount());
        log.character('\t');
        log.signed(entry.getInstanceSpace());
        log.character('\t');
        log.string(entry.getClassName());
        log.newline();
    }

    protected HistogramEntry[] filterEntries(long minimumInstanceCount) {
        int count = 0;
        for (HistogramEntry entry : this.entryArray) {
            if (minimumInstanceCount > entry.getInstanceCount()) continue;
            ++count;
        }
        HistogramEntry[] filteredArray = new HistogramEntry[count];
        int index = 0;
        for (HistogramEntry entry : this.entryArray) {
            if (minimumInstanceCount > entry.getInstanceCount()) continue;
            filteredArray[index] = entry;
            ++index;
        }
        return filteredArray;
    }

    private void initializeFromClassList() {
        int index = 0;
        for (Class<?> c : this.classList) {
            this.entryArray[index] = new HistogramEntry(c.getName());
            ++index;
        }
    }

    protected static class HistogramEntry {
        protected final String className;
        protected long instanceCount;
        protected long instanceSpace;
        protected static Comparator<HistogramEntry> byName = (x, y) -> x.getClassName().compareTo(y.getClassName());
        protected static Comparator<HistogramEntry> byIncreasingCount = (x, y) -> Long.signum(x.getInstanceCount() - y.getInstanceCount());
        protected static Comparator<HistogramEntry> byDecreasingCount = (x, y) -> Long.signum(y.getInstanceCount() - x.getInstanceCount());
        protected static Comparator<HistogramEntry> byIncreasingSpace = (x, y) -> Long.signum(x.getInstanceSpace() - y.getInstanceSpace());
        protected static Comparator<HistogramEntry> byDecreasingSpace = (x, y) -> Long.signum(y.getInstanceSpace() - x.getInstanceSpace());

        public static HistogramEntry factory(String className) {
            return new HistogramEntry(className);
        }

        public String getClassName() {
            return this.className;
        }

        public long getInstanceCount() {
            return this.instanceCount;
        }

        public long getInstanceSpace() {
            return this.instanceSpace;
        }

        public void reset() {
            this.instanceCount = 0L;
            this.instanceSpace = 0L;
        }

        protected HistogramEntry(String className) {
            this.className = className;
            this.reset();
        }
    }
}

