/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.amd64;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.graal.meta.SubstrateRegisterConfig;
import jdk.vm.ci.code.Register;
import org.graalvm.compiler.asm.amd64.AMD64Address;
import org.graalvm.compiler.core.amd64.AMD64AddressNode;
import org.graalvm.compiler.core.amd64.AMD64CompressAddressLowering;
import org.graalvm.compiler.core.common.CompressEncoding;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.CompressionNode;
import org.graalvm.compiler.nodes.ValueNode;

public class SubstrateAMD64AddressLowering
extends AMD64CompressAddressLowering {
    private final long heapBase;
    private final Register heapBaseRegister;

    public SubstrateAMD64AddressLowering(CompressEncoding encoding, SubstrateRegisterConfig registerConfig) {
        this.heapBase = encoding.getBase();
        this.heapBaseRegister = registerConfig.getHeapBaseRegister();
    }

    protected final boolean improveUncompression(AMD64AddressNode addr, CompressionNode compression, ValueNode other) {
        assert (SubstrateOptions.SpawnIsolates.getValue().booleanValue());
        CompressEncoding encoding = compression.getEncoding();
        if (!AMD64Address.Scale.isScaleShiftSupported((int)encoding.getShift())) {
            return false;
        }
        long encodingBase = encoding.getBase();
        ValueNode base = other;
        if (this.heapBaseRegister != null && encodingBase == this.heapBase) {
            if (other != null) {
                return false;
            }
            base = (ValueNode)compression.graph().unique((Node)new AMD64CompressAddressLowering.HeapBaseNode(this.heapBaseRegister));
        } else if (encodingBase != 0L && !SubstrateAMD64AddressLowering.updateDisplacement((AMD64AddressNode)addr, (long)encodingBase, (boolean)false)) {
            return false;
        }
        AMD64Address.Scale scale = AMD64Address.Scale.fromShift((int)encoding.getShift());
        addr.setBase(base);
        addr.setScale(scale);
        addr.setUncompressionScale(scale);
        addr.setIndex(compression.getValue());
        return true;
    }
}

