/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.aarch64;

import com.oracle.svm.core.graal.code.NativeImagePatcher;
import org.graalvm.compiler.asm.aarch64.AArch64Assembler;
import org.graalvm.compiler.code.CompilationResult;

class SingleInstructionNativeImagePatcher
extends CompilationResult.CodeAnnotation
implements NativeImagePatcher {
    private final AArch64Assembler.SingleInstructionAnnotation annotation;

    SingleInstructionNativeImagePatcher(int instructionStartPosition, AArch64Assembler.SingleInstructionAnnotation annotation) {
        super(instructionStartPosition);
        this.annotation = annotation;
    }

    @Override
    public int getOffset() {
        return this.annotation.instructionPosition + this.annotation.offsetBits;
    }

    @Override
    public int getLength() {
        assert (this.annotation.operandSizeBits % 8 == 0) : "operandSize is not a byte size";
        return this.annotation.operandSizeBits / 8;
    }

    @Override
    public void patchCode(int relative, byte[] code) {
        this.annotation.patch(this.annotation.instructionPosition, relative, code);
    }

    public boolean equals(Object obj) {
        return obj == this;
    }
}

