/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge;

import com.oracle.svm.core.c.NonmovableArrays;
import com.oracle.svm.core.heap.InstanceReferenceMapDecoder;
import com.oracle.svm.core.heap.ObjectReferenceVisitor;
import com.oracle.svm.core.thread.VMThreads;
import com.oracle.svm.core.threadlocal.VMThreadLocalMTSupport;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.word.Pointer;

public class ThreadLocalMTWalker {
    public boolean walk(ObjectReferenceVisitor referenceVisitor) {
        VMThreadLocalMTSupport threadLocals = (VMThreadLocalMTSupport)ImageSingletons.lookup(VMThreadLocalMTSupport.class);
        IsolateThread vmThread = VMThreads.firstThread();
        while (vmThread.isNonNull()) {
            if (!InstanceReferenceMapDecoder.walkOffsetsFromPointer((Pointer)vmThread, NonmovableArrays.fromImageHeap((Object)threadLocals.vmThreadReferenceMapEncoding), threadLocals.vmThreadReferenceMapIndex, referenceVisitor, null)) {
                return false;
            }
            vmThread = VMThreads.nextThread(vmThread);
        }
        return true;
    }
}

