/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.annotate.NeverInline;
import com.oracle.svm.core.annotate.RestrictHeapAccess;
import com.oracle.svm.core.code.CodeInfo;
import com.oracle.svm.core.code.CodeInfoTable;
import com.oracle.svm.core.deopt.DeoptimizedFrame;
import com.oracle.svm.core.genscavenge.HeapImpl;
import com.oracle.svm.core.heap.Heap;
import com.oracle.svm.core.heap.ObjectReferenceVisitor;
import com.oracle.svm.core.heap.ObjectVisitor;
import com.oracle.svm.core.heap.ReferenceAccess;
import com.oracle.svm.core.hub.InteriorObjRefWalker;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.log.StringBuilderLog;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import com.oracle.svm.core.stack.JavaStackWalker;
import com.oracle.svm.core.stack.StackFrameVisitor;
import com.oracle.svm.core.thread.JavaVMOperation;
import com.oracle.svm.core.thread.VMOperation;
import com.oracle.svm.core.thread.VMThreads;
import java.util.ArrayList;
import org.graalvm.compiler.word.Word;
import org.graalvm.nativeimage.CurrentIsolate;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.nativeimage.c.function.CodePointer;
import org.graalvm.word.ComparableWord;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;
import org.graalvm.word.WordFactory;

public class PathExhibitor {
    protected final ArrayList<PathElement> path = new ArrayList();
    protected static final FrameSlotVisitor frameSlotVisitor = new FrameSlotVisitor();
    protected static final FrameVisitor stackFrameVisitor = new FrameVisitor();
    protected static final BootImageHeapObjRefVisitor bootImageHeapObjRefVisitor = new BootImageHeapObjRefVisitor();
    protected static final HeapObjRefVisitor heapObjRefVisitor = new HeapObjRefVisitor();
    protected static final HeapObjectVisitor heapObjectVisitor = new HeapObjectVisitor();

    @NeverInline(value="Starting a stack walk in the caller frame")
    public void findPathToRange(Pointer rangeBegin, Pointer rangeEnd) {
        assert (VMOperation.isInProgressAtSafepoint());
        if (rangeBegin.isNull() || rangeBegin.aboveThan((UnsignedWord)rangeEnd)) {
            return;
        }
        PathEdge edge = new PathEdge();
        this.findPathToTarget(new RangeTargetMatcher(rangeBegin, rangeEnd), edge, KnownIntrinsics.readCallerStackPointer());
        if (edge.isFilled()) {
            this.path.add(edge.getTo());
            this.path.add(edge.getFrom());
            Object fromObj = KnownIntrinsics.convertUnknownValue(edge.getFrom().getObject(), Object.class);
            this.findPathToRoot(fromObj, edge, KnownIntrinsics.readCallerStackPointer());
        }
    }

    void findPathToRoot(Object leaf, PathEdge currentEdge, Pointer currentThreadWalkStackPointer) {
        assert (VMOperation.isInProgressAtSafepoint());
        if (leaf == null) {
            return;
        }
        Object currentTargetObj = leaf;
        while (true) {
            currentEdge.reset();
            this.findPathToTarget(new ObjectTargetMatcher(currentTargetObj), currentEdge, currentThreadWalkStackPointer);
            PathElement currentElement = null;
            if (currentEdge.isFilled()) {
                currentElement = currentEdge.getFrom();
                if (this.path.isEmpty()) {
                    this.path.add(currentEdge.getTo());
                }
            }
            if (currentElement == null) break;
            currentTargetObj = KnownIntrinsics.convertUnknownValue(currentElement.getObject(), Object.class);
            if (currentTargetObj == null) {
                this.path.add(currentElement);
                break;
            }
            if (this.checkForCycles(currentTargetObj)) {
                CyclicElement cyclic = new CyclicElement(currentTargetObj);
                this.path.add(cyclic);
                break;
            }
            this.path.add(currentElement);
        }
    }

    public boolean hasPath() {
        return this.path.size() > 1;
    }

    public PathElement[] getPath() {
        return this.path.toArray(new PathElement[0]);
    }

    public void toLog(Log log) {
        for (PathElement element : this.path) {
            log.newline();
            element.toLog(log);
        }
    }

    protected void findPathToTarget(TargetMatcher target, PathEdge edge, Pointer currentThreadWalkStackPointer) {
        assert (target != null && !edge.isFilled());
        this.findPathInHeap(target, edge);
        this.findPathInBootImageHeap(target, edge);
        this.findPathInStack(target, edge, currentThreadWalkStackPointer);
    }

    protected void findPathInStack(TargetMatcher target, PathEdge edge, Pointer currentThreadWalkStackPointer) {
        if (edge.isFilled()) {
            return;
        }
        stackFrameVisitor.initialize(target, edge);
        JavaStackWalker.walkCurrentThread(currentThreadWalkStackPointer, stackFrameVisitor);
        stackFrameVisitor.reset();
        if (SubstrateOptions.MultiThreaded.getValue().booleanValue()) {
            IsolateThread thread = VMThreads.firstThread();
            while (!edge.isFilled() && thread.isNonNull()) {
                if (thread.notEqual((ComparableWord)CurrentIsolate.getCurrentThread())) {
                    stackFrameVisitor.initialize(target, edge);
                    JavaStackWalker.walkThread(thread, stackFrameVisitor);
                    stackFrameVisitor.reset();
                }
                thread = VMThreads.nextThread(thread);
            }
        }
    }

    protected void findPathInBootImageHeap(final TargetMatcher target, final PathEdge result) {
        Heap.getHeap().walkImageHeapObjects(new ObjectVisitor(){

            @Override
            public boolean visitObject(Object obj) {
                if (result.isFilled()) {
                    return false;
                }
                bootImageHeapObjRefVisitor.initialize(obj, target, result);
                return InteriorObjRefWalker.walkObject(obj, bootImageHeapObjRefVisitor);
            }
        });
    }

    protected void findPathInHeap(TargetMatcher target, PathEdge result) {
        if (result.isFilled()) {
            return;
        }
        heapObjectVisitor.initialize(target, result);
        HeapImpl.getHeapImpl().walkObjects(heapObjectVisitor);
    }

    protected boolean checkForCycles(Object currentObject) {
        boolean result = false;
        for (PathElement seen : this.path) {
            Object seenObject = seen.getObject();
            if (currentObject != seenObject) continue;
            result = true;
            break;
        }
        return result;
    }

    public static class PathEdge {
        private PathElement from;
        private PathElement to;

        public boolean isFilled() {
            return this.from != null && this.to != null;
        }

        public PathElement getFrom() {
            return this.from;
        }

        public PathElement getTo() {
            return this.to;
        }

        public void fill(PathElement fromElem, PathElement toElem) {
            this.from = fromElem;
            this.to = toElem;
        }

        public void reset() {
            this.from = null;
            this.to = null;
        }
    }

    private static final class FindPathToObjectOperation
    extends JavaVMOperation {
        private final PathExhibitor exhibitor;
        private final Object object;
        private PathEdge result;

        FindPathToObjectOperation(PathExhibitor exhibitor, Object object, PathEdge result) {
            super("FindPathToObjectOperation", VMOperation.SystemEffect.SAFEPOINT);
            this.exhibitor = exhibitor;
            this.object = object;
            this.result = result;
        }

        @Override
        @NeverInline(value="Starting a stack walk.")
        protected void operate() {
            this.exhibitor.findPathToRoot(this.object, this.result, KnownIntrinsics.readCallerStackPointer());
        }
    }

    public static final class TestingBackDoor {
        private TestingBackDoor() {
        }

        public static void findPathToObject(PathExhibitor exhibitor, Object obj) {
            PathEdge result = new PathEdge();
            FindPathToObjectOperation op = new FindPathToObjectOperation(exhibitor, obj, result);
            op.enqueue();
        }
    }

    public static class CyclicElement
    extends PathElement {
        protected final Object previous;

        @Override
        public Object getObject() {
            return null;
        }

        @Override
        public Log toLog(Log log) {
            log.string("[cyclic:");
            log.string("  previous: ").object(this.previous);
            log.string("]");
            return log;
        }

        protected CyclicElement(Object previous) {
            this.previous = previous;
        }
    }

    public static class BootImageHeapElement
    extends PathElement {
        protected final Object base;
        protected final UnsignedWord offset;

        @Override
        public Object getObject() {
            return null;
        }

        @Override
        public Log toLog(Log log) {
            log.string("[native image heap:");
            log.string("  object: ").object(this.base);
            log.string("  offset: ").unsigned((WordBase)this.offset);
            log.string("]");
            return log;
        }

        protected BootImageHeapElement(Object base, UnsignedWord offset) {
            this.base = base;
            this.offset = offset;
        }
    }

    public static class StackElement
    extends PathElement {
        protected final Pointer stackSlot;
        protected final CodePointer ip;
        protected final CodePointer deoptSourcePC;
        protected final Pointer slotValue;

        @Override
        public Object getObject() {
            return null;
        }

        @Override
        public Log toLog(Log log) {
            log.string("[stack:");
            log.string("  slot: ").hex((WordBase)this.stackSlot);
            log.string("  deoptSourcePC: ").hex((WordBase)this.deoptSourcePC);
            log.string("  ip: ").hex((WordBase)this.ip);
            log.string("  value: ").hex((WordBase)this.slotValue);
            log.string("]");
            return log;
        }

        protected StackElement(Pointer stackSlot, CodePointer ip, DeoptimizedFrame deoptFrame) {
            this.stackSlot = stackSlot;
            this.deoptSourcePC = deoptFrame != null ? deoptFrame.getSourcePC() : (CodePointer)WordFactory.nullPointer();
            this.ip = ip;
            this.slotValue = (Pointer)stackSlot.readWord(0);
        }
    }

    public static class HeapElement
    extends PathElement {
        protected final Object base;
        protected final UnsignedWord offset;

        @Override
        public Object getObject() {
            return this.base;
        }

        @Override
        public Log toLog(Log log) {
            log.string("[heap:");
            log.string("  base: ").object(this.base);
            log.string("  offset: ").unsigned((WordBase)this.offset);
            Word objPointer = Word.objectToUntrackedPointer((Object)this.base);
            Pointer fieldObjRef = objPointer.add(this.offset);
            Pointer fieldPointer = (Pointer)fieldObjRef.readWord(0);
            log.string("  field: ").hex((WordBase)fieldPointer);
            log.string("]");
            return log;
        }

        protected HeapElement(Object base, UnsignedWord offset) {
            this.base = base;
            this.offset = offset;
        }
    }

    public static class LeafElement
    extends PathElement {
        protected final Object leaf;

        @Override
        public Object getObject() {
            return this.leaf;
        }

        @Override
        public Log toLog(Log log) {
            log.string("[leaf:");
            log.string("  ").object(this.leaf);
            log.string("]");
            return log;
        }

        protected LeafElement(Object leaf) {
            this.leaf = leaf;
        }
    }

    private static class HeapObjRefVisitor
    extends AbstractVisitor
    implements ObjectReferenceVisitor {
        Pointer containerPointer;

        HeapObjRefVisitor() {
        }

        public void initialize(Pointer container, TargetMatcher targetMatcher, PathEdge edge) {
            super.initialize(targetMatcher, edge);
            this.containerPointer = container;
        }

        @Override
        public boolean visitObjectReference(Pointer objRef, boolean compressed) {
            Word referentPointer;
            if (objRef.isNull()) {
                return true;
            }
            Object containerObject = this.containerPointer.toObject();
            if (!HeapObjRefVisitor.isInterfering(containerObject) && this.target.matches((referentPointer = ReferenceAccess.singleton().readObjectAsUntrackedPointer(objRef, compressed)).toObject())) {
                Pointer offset = objRef.subtract((UnsignedWord)this.containerPointer);
                this.result.fill(new HeapElement(containerObject, (UnsignedWord)offset), new LeafElement(referentPointer.toObject()));
                return false;
            }
            return true;
        }

        @NeverInline(value="Starting a stack walk in the caller frame")
        static boolean isInterfering(Object currentObject) {
            return currentObject instanceof PathElement || currentObject instanceof FindPathToObjectOperation || currentObject instanceof TargetMatcher;
        }
    }

    private static class HeapObjectVisitor
    extends AbstractVisitor
    implements ObjectVisitor {
        HeapObjectVisitor() {
        }

        @Override
        public boolean visitObject(Object containerObject) {
            Word containerPointer = Word.objectToUntrackedPointer((Object)containerObject);
            heapObjRefVisitor.initialize((Pointer)containerPointer, this.target, this.result);
            return InteriorObjRefWalker.walkObject(containerObject, heapObjRefVisitor);
        }
    }

    private static class BootImageHeapObjRefVisitor
    extends AbstractVisitor
    implements ObjectReferenceVisitor {
        Object container;

        BootImageHeapObjRefVisitor() {
        }

        void initialize(Object containerObj, TargetMatcher targetMatcher, PathEdge resultPath) {
            super.initialize(targetMatcher, resultPath);
            this.container = containerObj;
        }

        @Override
        public boolean visitObjectReference(Pointer objRef, boolean compressed) {
            if (objRef.isNull()) {
                return true;
            }
            Object referent = ReferenceAccess.singleton().readObjectAt(objRef, compressed);
            if (this.target.matches(referent)) {
                Pointer offset = objRef.subtract((UnsignedWord)Word.objectToUntrackedPointer((Object)this.container));
                this.result.fill(new BootImageHeapElement(this.container, (UnsignedWord)offset), new LeafElement(referent));
                return false;
            }
            return true;
        }
    }

    private static class FrameSlotVisitor
    extends AbstractVisitor
    implements ObjectReferenceVisitor {
        CodePointer ip;
        DeoptimizedFrame deoptFrame;

        FrameSlotVisitor() {
        }

        void initialize(CodePointer ipArg, DeoptimizedFrame deoptFrameArg, TargetMatcher targetMatcher, PathEdge edge) {
            super.initialize(targetMatcher, edge);
            this.ip = ipArg;
            this.deoptFrame = deoptFrameArg;
        }

        @Override
        public boolean visitObjectReference(Pointer stackSlot, boolean compressed) {
            Log trace = Log.noopLog();
            if (stackSlot.isNull()) {
                return true;
            }
            Word referentPointer = ReferenceAccess.singleton().readObjectAsUntrackedPointer(stackSlot, compressed);
            trace.string("  referentPointer: ").hex((WordBase)referentPointer);
            if (this.target.matches(referentPointer.toObject())) {
                this.result.fill(new StackElement(stackSlot, this.ip, this.deoptFrame), new LeafElement(referentPointer.toObject()));
                return false;
            }
            return true;
        }
    }

    public static class FrameVisitor
    extends AbstractVisitor
    implements StackFrameVisitor {
        FrameVisitor() {
        }

        @Override
        @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate while visiting stack frames.")
        public boolean visitFrame(Pointer sp, CodePointer ip, CodeInfo codeInfo, DeoptimizedFrame deoptimizedFrame) {
            frameSlotVisitor.initialize(ip, deoptimizedFrame, this.target, this.result);
            return CodeInfoTable.visitObjectReferences(sp, ip, codeInfo, deoptimizedFrame, frameSlotVisitor);
        }
    }

    static class AbstractVisitor {
        TargetMatcher target;
        PathEdge result;

        AbstractVisitor() {
        }

        void initialize(TargetMatcher targetMatcher, PathEdge resultPath) {
            this.target = targetMatcher;
            this.result = resultPath;
        }

        void reset() {
            this.initialize(null, null);
        }
    }

    static class RangeTargetMatcher
    implements TargetMatcher {
        final Pointer targetBegin;
        final Pointer targetEnd;

        RangeTargetMatcher(Pointer rangeBegin, Pointer rangeEndExclusive) {
            this.targetBegin = rangeBegin;
            this.targetEnd = rangeEndExclusive;
        }

        @Override
        public boolean matches(Object obj) {
            Word objAddr = Word.objectToUntrackedPointer((Object)obj);
            return objAddr.aboveOrEqual((UnsignedWord)this.targetBegin) && objAddr.belowThan((UnsignedWord)this.targetEnd);
        }
    }

    static class ObjectTargetMatcher
    implements TargetMatcher {
        final Object target;

        ObjectTargetMatcher(Object target) {
            this.target = target;
        }

        @Override
        public boolean matches(Object obj) {
            return obj == this.target;
        }
    }

    static interface TargetMatcher {
        public boolean matches(Object var1);
    }

    public static abstract class PathElement {
        public abstract Log toLog(Log var1);

        public abstract Object getObject();

        public String toString() {
            StringBuilderLog log = new StringBuilderLog();
            this.toLog(log);
            return log.getResult();
        }
    }
}

