/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge;

import com.oracle.svm.core.MemoryWalker;
import com.oracle.svm.core.genscavenge.ImageHeapInfo;
import com.oracle.svm.core.hub.LayoutEncoding;
import org.graalvm.compiler.word.Word;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;

abstract class MemoryWalkerAccessBase
implements MemoryWalker.NativeImageHeapRegionAccess<ImageHeapInfo> {
    private final String regionName;
    private final boolean containsReferences;
    private final boolean isWritable;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    protected MemoryWalkerAccessBase(String regionName, boolean containsReferences, boolean isWritable) {
        this.regionName = regionName;
        this.containsReferences = containsReferences;
        this.isWritable = isWritable;
    }

    @Override
    public UnsignedWord getStart(ImageHeapInfo info) {
        return Word.objectToUntrackedPointer((Object)this.getFirstObject(info));
    }

    @Override
    public UnsignedWord getSize(ImageHeapInfo info) {
        Word firstStart = Word.objectToUntrackedPointer((Object)this.getFirstObject(info));
        Pointer lastEnd = LayoutEncoding.getObjectEnd(this.getLastObject(info));
        return lastEnd.subtract((UnsignedWord)firstStart);
    }

    @Override
    public String getRegionName(ImageHeapInfo region) {
        return this.regionName;
    }

    @Override
    public boolean containsReferences(ImageHeapInfo region) {
        return this.containsReferences;
    }

    @Override
    public boolean isWritable(ImageHeapInfo region) {
        return this.isWritable;
    }

    protected abstract Object getFirstObject(ImageHeapInfo var1);

    protected abstract Object getLastObject(ImageHeapInfo var1);
}

