/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge;

import com.oracle.svm.core.MemoryWalker;
import com.oracle.svm.core.genscavenge.ImageHeapInfo;
import com.oracle.svm.core.genscavenge.ReadOnlyPrimitiveMemoryWalkerAccess;
import com.oracle.svm.core.genscavenge.ReadOnlyReferenceMemoryWalkerAccess;
import com.oracle.svm.core.genscavenge.WritablePrimitiveMemoryWalkerAccess;
import com.oracle.svm.core.genscavenge.WritableReferenceMemoryWalkerAccess;
import com.oracle.svm.core.heap.ObjectVisitor;
import com.oracle.svm.core.hub.LayoutEncoding;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import org.graalvm.compiler.word.Word;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;

public final class ImageHeapWalker {
    private static final MemoryWalker.NativeImageHeapRegionAccess<ImageHeapInfo> READ_ONLY_PRIMITIVE_WALKER = new ReadOnlyPrimitiveMemoryWalkerAccess();
    private static final MemoryWalker.NativeImageHeapRegionAccess<ImageHeapInfo> READ_ONLY_REFERENCE_WALKER = new ReadOnlyReferenceMemoryWalkerAccess();
    private static final MemoryWalker.NativeImageHeapRegionAccess<ImageHeapInfo> WRITABLE_PRIMITIVE_WALKER = new WritablePrimitiveMemoryWalkerAccess();
    private static final MemoryWalker.NativeImageHeapRegionAccess<ImageHeapInfo> WRITABLE_REFERENCE_WALKER = new WritableReferenceMemoryWalkerAccess();

    private ImageHeapWalker() {
    }

    public static boolean walkRegions(ImageHeapInfo heapInfo, MemoryWalker.Visitor visitor) {
        return visitor.visitNativeImageHeapRegion(heapInfo, READ_ONLY_PRIMITIVE_WALKER) && visitor.visitNativeImageHeapRegion(heapInfo, READ_ONLY_REFERENCE_WALKER) && visitor.visitNativeImageHeapRegion(heapInfo, WRITABLE_PRIMITIVE_WALKER) && visitor.visitNativeImageHeapRegion(heapInfo, WRITABLE_REFERENCE_WALKER);
    }

    public static boolean walkImageHeapObjects(ImageHeapInfo heapInfo, ObjectVisitor visitor) {
        return ImageHeapWalker.walkPartition(heapInfo.firstReadOnlyPrimitiveObject, heapInfo.lastReadOnlyPrimitiveObject, visitor) && ImageHeapWalker.walkPartition(heapInfo.firstReadOnlyReferenceObject, heapInfo.lastReadOnlyReferenceObject, visitor) && ImageHeapWalker.walkPartition(heapInfo.firstWritablePrimitiveObject, heapInfo.lastWritablePrimitiveObject, visitor) && ImageHeapWalker.walkPartition(heapInfo.firstWritableReferenceObject, heapInfo.lastWritableReferenceObject, visitor);
    }

    private static boolean walkPartition(Object firstObject, Object lastObject, ObjectVisitor visitor) {
        if (firstObject == null || lastObject == null) {
            assert (firstObject == null && lastObject == null);
            return true;
        }
        Word firstPointer = Word.objectToUntrackedPointer((Object)firstObject);
        Word lastPointer = Word.objectToUntrackedPointer((Object)lastObject);
        Word current = firstPointer;
        while (current.belowOrEqual((UnsignedWord)lastPointer)) {
            Object currentObject = KnownIntrinsics.convertUnknownValue(current.toObject(), Object.class);
            if (!visitor.visitObject(currentObject)) {
                return false;
            }
            current = LayoutEncoding.getObjectEnd(currentObject);
        }
        return true;
    }

    static void logPartitionBoundaries(Log log, ImageHeapInfo imageHeapInfo) {
        log.string("ReadOnly Primitives: ").hex((WordBase)Word.objectToUntrackedPointer((Object)imageHeapInfo.firstReadOnlyPrimitiveObject)).string(" .. ").hex((WordBase)Word.objectToUntrackedPointer((Object)imageHeapInfo.lastReadOnlyPrimitiveObject)).newline();
        log.string("ReadOnly References: ").hex((WordBase)Word.objectToUntrackedPointer((Object)imageHeapInfo.firstReadOnlyReferenceObject)).string(" .. ").hex((WordBase)Word.objectToUntrackedPointer((Object)imageHeapInfo.lastReadOnlyReferenceObject)).newline();
        log.string("Writable Primitives: ").hex((WordBase)Word.objectToUntrackedPointer((Object)imageHeapInfo.firstWritablePrimitiveObject)).string(" .. ").hex((WordBase)Word.objectToUntrackedPointer((Object)imageHeapInfo.lastWritablePrimitiveObject)).newline();
        log.string("Writable References: ").hex((WordBase)Word.objectToUntrackedPointer((Object)imageHeapInfo.firstWritableReferenceObject)).string(" .. ").hex((WordBase)Word.objectToUntrackedPointer((Object)imageHeapInfo.lastWritableReferenceObject));
    }
}

