/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge;

import com.oracle.svm.core.MemoryWalker;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.annotate.AlwaysInline;
import com.oracle.svm.core.annotate.NeverInline;
import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.genscavenge.AlignedHeapChunk;
import com.oracle.svm.core.genscavenge.AuxiliaryImageHeap;
import com.oracle.svm.core.genscavenge.GCImpl;
import com.oracle.svm.core.genscavenge.HeapChunkProvider;
import com.oracle.svm.core.genscavenge.HeapImplMemoryMXBean;
import com.oracle.svm.core.genscavenge.HeapOptions;
import com.oracle.svm.core.genscavenge.HeapPolicy;
import com.oracle.svm.core.genscavenge.HeapPolicyOptions;
import com.oracle.svm.core.genscavenge.HeapVerifier;
import com.oracle.svm.core.genscavenge.HeapVerifierImpl;
import com.oracle.svm.core.genscavenge.ImageHeapInfo;
import com.oracle.svm.core.genscavenge.ImageHeapWalker;
import com.oracle.svm.core.genscavenge.ObjectHeaderImpl;
import com.oracle.svm.core.genscavenge.OldGeneration;
import com.oracle.svm.core.genscavenge.PinnedObjectImpl;
import com.oracle.svm.core.genscavenge.Space;
import com.oracle.svm.core.genscavenge.StackVerifier;
import com.oracle.svm.core.genscavenge.ThreadLocalAllocation;
import com.oracle.svm.core.genscavenge.UnalignedHeapChunk;
import com.oracle.svm.core.genscavenge.YoungGeneration;
import com.oracle.svm.core.heap.GC;
import com.oracle.svm.core.heap.Heap;
import com.oracle.svm.core.heap.NoAllocationVerifier;
import com.oracle.svm.core.heap.ObjectHeader;
import com.oracle.svm.core.heap.ObjectVisitor;
import com.oracle.svm.core.heap.PhysicalMemory;
import com.oracle.svm.core.heap.ReferenceInternals;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.hub.LayoutEncoding;
import com.oracle.svm.core.jdk.UninterruptibleUtils;
import com.oracle.svm.core.locks.VMCondition;
import com.oracle.svm.core.locks.VMMutex;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.nodes.CFunctionEpilogueNode;
import com.oracle.svm.core.nodes.CFunctionPrologueNode;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import com.oracle.svm.core.thread.JavaThreads;
import com.oracle.svm.core.thread.VMOperation;
import java.lang.management.MemoryMXBean;
import java.lang.ref.Reference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.compiler.nodes.gc.CardTableBarrierSet;
import org.graalvm.compiler.word.Word;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;

public class HeapImpl
extends Heap {
    private static final VMMutex REF_MUTEX = new VMMutex();
    private static final VMCondition REF_CONDITION = new VMCondition(REF_MUTEX);
    private final YoungGeneration youngGeneration = new YoungGeneration("YoungGeneration");
    private final OldGeneration oldGeneration = new OldGeneration("OldGeneration");
    final HeapChunkProvider chunkProvider;
    private final ObjectHeaderImpl objectHeaderImpl = new ObjectHeaderImpl();
    private final GCImpl gcImpl;
    private final HeapPolicy heapPolicy;
    private final MemoryMXBean memoryMXBean;
    private final ImageHeapInfo imageHeapInfo;
    private HeapVerifierImpl heapVerifier;
    private final StackVerifier stackVerifier;
    private Reference<?> refPendingList;
    private long refListOfferCounter;
    private long refListWaiterWakeUpCounter;
    private List<Class<?>> classList;
    private UninterruptibleUtils.AtomicReference<PinnedObjectImpl> pinHead;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public HeapImpl(Feature.FeatureAccess access) {
        this.gcImpl = new GCImpl(access);
        this.heapPolicy = new HeapPolicy(access);
        this.pinHead = new UninterruptibleUtils.AtomicReference();
        if (HeapImpl.getVerifyHeapBeforeGC() || HeapImpl.getVerifyHeapAfterGC() || HeapImpl.getVerifyStackBeforeGC() || HeapImpl.getVerifyStackAfterGC() || HeapImpl.getVerifyDirtyCardBeforeGC() || HeapImpl.getVerifyDirtyCardAfterGC()) {
            this.heapVerifier = HeapVerifierImpl.factory();
            this.stackVerifier = new StackVerifier();
        } else {
            this.heapVerifier = null;
            this.stackVerifier = null;
        }
        this.chunkProvider = new HeapChunkProvider();
        this.memoryMXBean = new HeapImplMemoryMXBean();
        this.imageHeapInfo = new ImageHeapInfo();
        this.classList = null;
        SubstrateUtil.DiagnosticThunkRegister.getSingleton().register(log -> {
            this.logImageHeapPartitionBoundaries(log).newline();
            this.zapValuesToLog(log).newline();
            this.report(log, true).newline();
            log.newline();
        });
    }

    @Fold
    public static HeapImpl getHeapImpl() {
        Heap heap = Heap.getHeap();
        assert (heap instanceof HeapImpl) : "VMConfiguration heap is not a HeapImpl.";
        return (HeapImpl)heap;
    }

    @Fold
    public static ImageHeapInfo getImageHeapInfo() {
        return HeapImpl.getHeapImpl().imageHeapInfo;
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean isInImageHeap(Object obj) {
        return this.isInImageHeap((Pointer)Word.objectToUntrackedPointer((Object)obj));
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean isInImageHeap(Pointer pointer) {
        return this.imageHeapInfo.isInImageHeap(pointer) || AuxiliaryImageHeap.isPresent() && AuxiliaryImageHeap.singleton().containsObject(pointer);
    }

    public boolean isInImageHeapSlow(Object obj) {
        return this.isInImageHeapSlow((Pointer)Word.objectToUntrackedPointer((Object)obj));
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean isInImageHeapSlow(Pointer p) {
        return this.imageHeapInfo.isInImageHeapSlow(p) || AuxiliaryImageHeap.isPresent() && AuxiliaryImageHeap.singleton().containsObjectSlow(p);
    }

    @Override
    public void suspendAllocation() {
        ThreadLocalAllocation.suspendThreadLocalAllocation();
    }

    @Override
    public void resumeAllocation() {
        ThreadLocalAllocation.resumeThreadLocalAllocation();
    }

    @Override
    public boolean walkObjects(ObjectVisitor visitor) {
        VMOperation.guaranteeInProgressAtSafepoint("must only be executed at a safepoint");
        return this.walkImageHeapObjects(visitor) && this.walkCollectedHeapObjects(visitor);
    }

    public boolean walkMemory(MemoryWalker.Visitor visitor) {
        VMOperation.guaranteeInProgressAtSafepoint("must only be executed at a safepoint");
        return this.walkNativeImageHeapRegions(visitor) && this.getYoungGeneration().walkHeapChunks(visitor) && this.getOldGeneration().walkHeapChunks(visitor) && HeapChunkProvider.get().walkHeapChunks(visitor);
    }

    @Override
    @Uninterruptible(reason="Tear-down in progress.")
    public final boolean tearDown() {
        this.youngGeneration.tearDown();
        this.oldGeneration.tearDown();
        HeapChunkProvider.get().tearDown();
        return true;
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public ObjectHeader getObjectHeader() {
        return this.objectHeaderImpl;
    }

    public ObjectHeaderImpl getObjectHeaderImpl() {
        return this.objectHeaderImpl;
    }

    @Override
    public GC getGC() {
        return this.getGCImpl();
    }

    public GCImpl getGCImpl() {
        return this.gcImpl;
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean isAllocationDisallowed() {
        return NoAllocationVerifier.isActive() || this.gcImpl.collectionInProgress.getState();
    }

    static void exitIfAllocationDisallowed(String callSite, String typeName) {
        if (HeapImpl.getHeapImpl().isAllocationDisallowed()) {
            NoAllocationVerifier.exit(callSite, typeName);
        }
    }

    final Space getAllocationSpace() {
        return this.getYoungGeneration().getEden();
    }

    @AlwaysInline(value="GC performance")
    public Object promoteObject(Object original, UnsignedWord header) {
        Log trace = Log.noopLog().string("[HeapImpl.promoteObject:").string("  original: ").object(original);
        Object result = HeapPolicy.getMaxSurvivorSpaces() > 0 && !this.getGCImpl().isCompleteCollection() ? this.getYoungGeneration().promoteObject(original, header) : this.getOldGeneration().promoteObject(original, header);
        trace.string("  result: ").object(result).string("]").newline();
        return result;
    }

    @AlwaysInline(value="GC performance")
    void dirtyCardIfNecessary(Object holderObject, Object object) {
        if (HeapPolicy.getMaxSurvivorSpaces() == 0 || holderObject == null || GCImpl.getGCImpl().isCompleteCollection() || !this.youngGeneration.contains(object)) {
            return;
        }
        UnsignedWord objectHeader = ObjectHeaderImpl.readHeaderFromObject(holderObject);
        if (ObjectHeaderImpl.hasRememberedSet(objectHeader)) {
            if (ObjectHeaderImpl.isAlignedObject(holderObject)) {
                AlignedHeapChunk.dirtyCardForObjectOfAlignedHeapChunk(holderObject, false);
            } else {
                assert (ObjectHeaderImpl.isUnalignedObject(holderObject)) : "sanity";
                UnalignedHeapChunk.dirtyCardForObjectOfUnalignedHeapChunk(holderObject, false);
            }
        }
    }

    public HeapPolicy getHeapPolicy() {
        return HeapImpl.getHeapImpl().heapPolicy;
    }

    public YoungGeneration getYoungGeneration() {
        return this.youngGeneration;
    }

    public OldGeneration getOldGeneration() {
        return this.oldGeneration;
    }

    public boolean isOldGeneration(Space space) {
        return space.isOldSpace();
    }

    public UninterruptibleUtils.AtomicReference<PinnedObjectImpl> getPinHead() {
        return this.pinHead;
    }

    public boolean isPinned(Object instance) {
        if (this.isInImageHeap(instance)) {
            return true;
        }
        for (PinnedObjectImpl pinnedObject = this.getPinHead().get(); pinnedObject != null; pinnedObject = pinnedObject.getNext()) {
            if (instance != pinnedObject.getObject()) continue;
            return true;
        }
        return false;
    }

    UnsignedWord getUsedChunkBytes() {
        UnsignedWord youngBytes = this.getYoungUsedChunkBytes();
        UnsignedWord oldBytes = this.getOldUsedChunkBytes();
        return youngBytes.add(oldBytes);
    }

    UnsignedWord getYoungUsedChunkBytes() {
        return this.getYoungGeneration().getChunkUsedBytes();
    }

    UnsignedWord getOldUsedChunkBytes() {
        Log trace = Log.noopLog().string("[HeapImpl.getOldUsedChunkBytes:");
        Space.Accounting from = this.getOldGeneration().getFromSpace().getAccounting();
        UnsignedWord fromBytes = from.getAlignedChunkBytes().add(from.getUnalignedChunkBytes());
        Space.Accounting to = this.getOldGeneration().getToSpace().getAccounting();
        UnsignedWord toBytes = to.getAlignedChunkBytes().add(to.getUnalignedChunkBytes());
        UnsignedWord result = fromBytes.add(toBytes);
        if (trace.isEnabled()) {
            trace.string("  fromAligned: ").unsigned((WordBase)from.getAlignedChunkBytes()).string("  fromUnaligned: ").signed((WordBase)from.getUnalignedChunkBytes()).string("  toAligned: ").unsigned((WordBase)to.getAlignedChunkBytes()).string("  toUnaligned: ").signed((WordBase)to.getUnalignedChunkBytes()).string("  returns: ").unsigned((WordBase)result).string(" ]").newline();
        }
        return result;
    }

    protected void report(Log log) {
        this.report(log, HeapPolicyOptions.TraceHeapChunks.getValue());
    }

    public Log report(Log log, boolean traceHeapChunks) {
        HeapImpl heap = HeapImpl.getHeapImpl();
        log.newline().string("[Heap:").indent(true);
        heap.getYoungGeneration().report(log, traceHeapChunks).newline();
        heap.getOldGeneration().report(log, traceHeapChunks).newline();
        HeapChunkProvider.get().report(log, traceHeapChunks);
        log.redent(false).string("]");
        return log;
    }

    Log logImageHeapPartitionBoundaries(Log log) {
        log.string("[Native image heap boundaries: ").indent(true);
        ImageHeapWalker.logPartitionBoundaries(log, this.imageHeapInfo);
        log.redent(false).string("]");
        return log;
    }

    Log zapValuesToLog(Log log) {
        if (HeapPolicy.getZapProducedHeapChunks() || HeapPolicy.getZapConsumedHeapChunks()) {
            log.string("[Heap Chunk zap values: ").indent(true);
            if (HeapPolicy.getZapProducedHeapChunks()) {
                log.string("  producedHeapChunkZapInt: ").string("  hex: ").spaces(8).hex(HeapPolicy.getProducedHeapChunkZapInt()).string("  signed: ").spaces(9).signed(HeapPolicy.getProducedHeapChunkZapInt()).string("  unsigned: ").spaces(10).unsigned(HeapPolicy.getProducedHeapChunkZapInt()).newline();
                log.string("  producedHeapChunkZapWord:").string("  hex: ").hex((WordBase)HeapPolicy.getProducedHeapChunkZapWord()).string("  signed: ").signed((WordBase)HeapPolicy.getProducedHeapChunkZapWord()).string("  unsigned: ").unsigned((WordBase)HeapPolicy.getProducedHeapChunkZapWord());
                if (HeapPolicy.getZapConsumedHeapChunks()) {
                    log.newline();
                }
            }
            if (HeapPolicy.getZapConsumedHeapChunks()) {
                log.string("  consumedHeapChunkZapInt: ").string("  hex: ").spaces(8).hex(HeapPolicy.getConsumedHeapChunkZapInt()).string("  signed: ").spaces(10).signed(HeapPolicy.getConsumedHeapChunkZapInt()).string("  unsigned: ").spaces(10).unsigned(HeapPolicy.getConsumedHeapChunkZapInt()).newline();
                log.string("  consumedHeapChunkZapWord:").string("  hex: ").hex((WordBase)HeapPolicy.getConsumedHeapChunkZapWord()).string("  signed: ").signed((WordBase)HeapPolicy.getConsumedHeapChunkZapWord()).string("  unsigned: ").unsigned((WordBase)HeapPolicy.getConsumedHeapChunkZapWord());
            }
            log.redent(false).string("]");
        }
        return log;
    }

    @Override
    public MemoryMXBean getMemoryMXBean() {
        return this.memoryMXBean;
    }

    @Override
    public List<Class<?>> getClassList() {
        if (this.classList == null) {
            ArrayList<Class> list = new ArrayList<Class>(1024);
            Object firstObject = this.imageHeapInfo.firstReadOnlyReferenceObject;
            Object lastObject = this.imageHeapInfo.lastReadOnlyReferenceObject;
            Word firstPointer = Word.objectToUntrackedPointer((Object)firstObject);
            Word lastPointer = Word.objectToUntrackedPointer((Object)lastObject);
            Word currentPointer = firstPointer;
            while (currentPointer.belowOrEqual((UnsignedWord)lastPointer)) {
                Object currentObject = KnownIntrinsics.convertUnknownValue(currentPointer.toObject(), Object.class);
                if (currentObject instanceof Class) {
                    Class asClass = (Class)currentObject;
                    list.add(asClass);
                }
                currentPointer = LayoutEncoding.getObjectEnd(currentObject);
            }
            this.classList = Collections.unmodifiableList(list);
        }
        return this.classList;
    }

    HeapVerifier getHeapVerifier() {
        return this.getHeapVerifierImpl();
    }

    public HeapVerifierImpl getHeapVerifierImpl() {
        return this.heapVerifier;
    }

    void setHeapVerifierImpl(HeapVerifierImpl value) {
        this.heapVerifier = value;
    }

    @Fold
    static boolean getVerifyHeapBeforeGC() {
        return SubstrateOptions.VerifyHeap.getValue() != false || HeapOptions.VerifyHeapBeforeCollection.getValue() != false;
    }

    @Fold
    static boolean getVerifyHeapAfterGC() {
        return SubstrateOptions.VerifyHeap.getValue() != false || HeapOptions.VerifyHeapAfterCollection.getValue() != false;
    }

    @Fold
    static boolean getVerifyStackBeforeGC() {
        return SubstrateOptions.VerifyHeap.getValue() != false || HeapOptions.VerifyStackBeforeCollection.getValue() != false;
    }

    @Fold
    static boolean getVerifyStackAfterGC() {
        return SubstrateOptions.VerifyHeap.getValue() != false || HeapOptions.VerifyStackAfterCollection.getValue() != false;
    }

    @Fold
    static boolean getVerifyDirtyCardBeforeGC() {
        return SubstrateOptions.VerifyHeap.getValue() != false || HeapOptions.VerifyDirtyCardsBeforeCollection.getValue() != false;
    }

    @Fold
    static boolean getVerifyDirtyCardAfterGC() {
        return SubstrateOptions.VerifyHeap.getValue() != false || HeapOptions.VerifyDirtyCardsAfterCollection.getValue() != false;
    }

    @NeverInline(value="Starting a stack walk in the caller frame")
    void verifyBeforeGC(String cause, UnsignedWord epoch) {
        Log trace = Log.noopLog().string("[HeapImpl.verifyBeforeGC:");
        trace.string("  getVerifyHeapBeforeGC(): ").bool(HeapImpl.getVerifyHeapBeforeGC()).string("  heapVerifier: ").object(this.heapVerifier);
        trace.string("  getVerifyStackBeforeGC(): ").bool(HeapImpl.getVerifyStackBeforeGC()).string("  stackVerifier: ").object(this.stackVerifier);
        if (HeapImpl.getVerifyHeapBeforeGC()) {
            assert (this.heapVerifier != null) : "No heap verifier!";
            if (!this.heapVerifier.verifyOperation("before collection", HeapVerifier.Occasion.BEFORE_COLLECTION)) {
                Log.log().string("[HeapImpl.verifyBeforeGC:").string("  cause: ").string(cause).string("  heap fails to verify before epoch: ").unsigned((WordBase)epoch).string("]").newline();
                assert (false);
            }
        }
        if (HeapImpl.getVerifyStackBeforeGC()) {
            assert (this.stackVerifier != null) : "No stack verifier!";
            if (!this.stackVerifier.verifyInAllThreads(KnownIntrinsics.readCallerStackPointer(), "before collection")) {
                Log.log().string("[HeapImpl.verifyBeforeGC:").string("  cause: ").string(cause).string("  stack fails to verify epoch: ").unsigned((WordBase)epoch).string("]").newline();
                assert (false);
            }
        }
        if (HeapImpl.getVerifyDirtyCardBeforeGC()) {
            assert (this.heapVerifier != null) : "No heap verifier!";
            Log.log().string("[Verify dirtyCard before GC: ");
            this.heapVerifier.verifyDirtyCard(false);
        }
        trace.string("]").newline();
    }

    @NeverInline(value="Starting a stack walk in the caller frame")
    void verifyAfterGC(String cause, UnsignedWord epoch) {
        if (HeapImpl.getVerifyHeapAfterGC()) {
            assert (this.heapVerifier != null) : "No heap verifier!";
            if (!this.heapVerifier.verifyOperation("after collection", HeapVerifier.Occasion.AFTER_COLLECTION)) {
                Log.log().string("[HeapImpl.verifyAfterGC:").string("  cause: ").string(cause).string("  heap fails to verify after epoch: ").unsigned((WordBase)epoch).string("]").newline();
                assert (false);
            }
        }
        if (HeapImpl.getVerifyStackAfterGC()) {
            assert (this.stackVerifier != null) : "No stack verifier!";
            if (!this.stackVerifier.verifyInAllThreads(KnownIntrinsics.readCallerStackPointer(), "after collection")) {
                Log.log().string("[HeapImpl.verifyAfterGC:").string("  cause: ").string(cause).string("  stack fails to verify after epoch: ").unsigned((WordBase)epoch).string("]").newline();
                assert (false);
            }
        }
        if (HeapImpl.getVerifyDirtyCardAfterGC()) {
            assert (this.heapVerifier != null) : "No heap verifier!";
            Log.log().string("[Verify dirtyCard after GC: ");
            this.heapVerifier.verifyDirtyCard(true);
        }
    }

    public boolean assertHub(DynamicHub hub) {
        return this.imageHeapInfo.isObjectInReadOnlyReferencePartition(hub);
    }

    public boolean assertHubOfObject(Object obj) {
        DynamicHub hub = ObjectHeader.readDynamicHubFromObject(obj);
        return this.assertHub(hub);
    }

    public UnsignedWord freeMemory() {
        return this.maxMemory().subtract(HeapPolicy.getYoungUsedBytes()).subtract(this.getOldUsedChunkBytes());
    }

    public UnsignedWord totalMemory() {
        return this.maxMemory();
    }

    public UnsignedWord maxMemory() {
        PhysicalMemory.size();
        return HeapPolicy.getMaximumHeapSize();
    }

    @Override
    public void prepareForSafepoint() {
    }

    @Override
    public void endSafepoint() {
    }

    @Override
    @Uninterruptible(reason="Called during startup.")
    public void attachThread(IsolateThread isolateThread) {
    }

    @Override
    public void detachThread(IsolateThread isolateThread) {
        ThreadLocalAllocation.disableThreadLocalAllocation(isolateThread);
    }

    @Override
    @Fold
    public int getImageHeapOffsetInAddressSpace() {
        return 0;
    }

    @Override
    public boolean walkImageHeapObjects(ObjectVisitor visitor) {
        VMOperation.guaranteeInProgressAtSafepoint("Must only be called at a safepoint");
        if (visitor != null) {
            return ImageHeapWalker.walkImageHeapObjects(this.imageHeapInfo, visitor) && (!AuxiliaryImageHeap.isPresent() || AuxiliaryImageHeap.singleton().walkObjects(visitor));
        }
        return true;
    }

    @Override
    public boolean walkCollectedHeapObjects(ObjectVisitor visitor) {
        VMOperation.guaranteeInProgressAtSafepoint("Must only be called at a safepoint");
        return this.getYoungGeneration().walkObjects(visitor) && this.getOldGeneration().walkObjects(visitor);
    }

    boolean walkNativeImageHeapRegions(MemoryWalker.Visitor visitor) {
        return ImageHeapWalker.walkRegions(this.imageHeapInfo, visitor) && (!AuxiliaryImageHeap.isPresent() || AuxiliaryImageHeap.singleton().walkRegions(visitor));
    }

    public CardTableBarrierSet createBarrierSet(MetaAccessProvider metaAccess) {
        ResolvedJavaType objectArrayType = metaAccess.lookupJavaType(Object[].class);
        return new CardTableBarrierSet(objectArrayType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addToReferencePendingList(Reference<?> list) {
        VMOperation.guaranteeGCInProgress("Must only be called during a GC.");
        if (list == null) {
            return;
        }
        REF_MUTEX.lock();
        try {
            if (this.refPendingList != null) {
                Reference<?> current = this.refPendingList;
                Reference<?> next = ReferenceInternals.getNextDiscovered(current);
                while (next != null) {
                    current = next;
                    next = ReferenceInternals.getNextDiscovered(current);
                }
                ReferenceInternals.setNextDiscovered(current, list);
            } else {
                this.refPendingList = list;
                ++this.refListOfferCounter;
                REF_CONDITION.broadcast();
            }
        }
        finally {
            REF_MUTEX.unlock();
        }
    }

    @Override
    @Uninterruptible(reason="Safepoint while holding the lock could lead to a deadlock in GC.")
    public boolean hasReferencePendingList() {
        REF_MUTEX.lockNoTransition();
        try {
            boolean bl = this.refPendingList != null;
            return bl;
        }
        finally {
            REF_MUTEX.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Uninterruptible(reason="Safepoint while holding the lock could lead to a deadlock in GC.")
    public void waitForReferencePendingList() throws InterruptedException {
        long initialWakeUps;
        long initialOffers;
        REF_MUTEX.lockNoTransition();
        try {
            if (this.refPendingList != null) {
                return;
            }
            initialOffers = this.refListOfferCounter;
            initialWakeUps = this.refListWaiterWakeUpCounter;
        }
        finally {
            REF_MUTEX.unlock();
        }
        HeapImpl.transitionToParkedInNativeThenAwaitPendingRefs(initialOffers, initialWakeUps);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", calleeMustBe=false)
    private static void transitionToParkedInNativeThenAwaitPendingRefs(long initialOffers, long initialWakeUps) throws InterruptedException {
        HeapImpl.doTransitionToParkedInNativeThenAwaitPendingRefs(initialOffers, initialWakeUps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doTransitionToParkedInNativeThenAwaitPendingRefs(long initialOffers, long initialWakeUps) throws InterruptedException {
        Thread currentThread = Thread.currentThread();
        int oldThreadStatus = JavaThreads.getThreadStatus(currentThread);
        JavaThreads.setThreadStatus(currentThread, 657);
        try {
            boolean offered;
            do {
                if (!Thread.interrupted()) continue;
                throw new InterruptedException();
            } while (!(offered = HeapImpl.transitionToNativeThenAwaitPendingRefs(initialOffers, initialWakeUps)));
        }
        finally {
            JavaThreads.setThreadStatus(currentThread, oldThreadStatus);
        }
    }

    @NeverInline(value="Must not be inlined in a caller that has an exception handler: We only support InvokeNode and not InvokeWithExceptionNode between a CFunctionPrologueNode and CFunctionEpilogueNode")
    private static boolean transitionToNativeThenAwaitPendingRefs(long initialOffers, long initialWakeUps) {
        CFunctionPrologueNode.cFunctionPrologue(3);
        boolean offered = HeapImpl.awaitPendingRefsInNative(initialOffers, initialWakeUps);
        CFunctionEpilogueNode.cFunctionEpilogue(3);
        return offered;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="In native.")
    @NeverInline(value="Provide a return address for the Java frame anchor.")
    private static boolean awaitPendingRefsInNative(long initialOffers, long initialWakeUps) {
        REF_MUTEX.lockNoTransition();
        try {
            while (HeapImpl.getHeapImpl().refListOfferCounter == initialOffers) {
                REF_CONDITION.blockNoTransition();
                if (HeapImpl.getHeapImpl().refListWaiterWakeUpCounter == initialWakeUps) continue;
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            REF_MUTEX.unlock();
        }
    }

    @Override
    @Uninterruptible(reason="Safepoint while holding the lock could lead to a deadlock in GC.")
    public void wakeUpReferencePendingListWaiters() {
        REF_MUTEX.lockNoTransition();
        try {
            ++this.refListWaiterWakeUpCounter;
            REF_CONDITION.broadcast();
        }
        finally {
            REF_MUTEX.unlock();
        }
    }

    @Override
    @Uninterruptible(reason="Safepoint while holding the lock could lead to a deadlock in GC.")
    public Reference<?> getAndClearReferencePendingList() {
        REF_MUTEX.lockNoTransition();
        try {
            Reference<?> list = this.refPendingList;
            this.refPendingList = null;
            Reference<?> reference = list;
            return reference;
        }
        finally {
            REF_MUTEX.unlock();
        }
    }
}

