/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core;

import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.c.CGlobalData;
import com.oracle.svm.core.c.CGlobalDataFactory;
import com.oracle.svm.core.util.Utf8;
import com.oracle.svm.core.util.VMError;
import java.io.CharConversionException;
import org.graalvm.compiler.serviceprovider.JavaVersionUtil;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.nativeimage.c.type.CTypeConversion;
import org.graalvm.word.PointerBase;

public final class VM {
    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static final String valueSeparator = "=";
    @Platforms(value={Platform.HOSTED_ONLY.class})
    private static final String versionValue = VM.getVersionValue();
    private static final String VERSION_INFO_SYMBOL_NAME = "__svm_version_info";
    private static final CGlobalData<CCharPointer> VERSION_INFO = CGlobalDataFactory.createCString(versionValue, "__svm_version_info");
    private static final int versionValueHash = versionValue.hashCode();

    @Platforms(value={Platform.HOSTED_ONLY.class})
    private static String getVersionValue() {
        String version = System.getProperty("org.graalvm.version");
        VMError.guarantee(version != null);
        version = VM.class.getName() + valueSeparator + "GraalVM " + version;
        version = version + " Java " + JavaVersionUtil.JAVA_SPEC;
        String config = System.getProperty("org.graalvm.config", "");
        if (!config.isEmpty()) {
            version = version + " " + config;
        }
        return version;
    }

    public static String getVersion() {
        try {
            CCharPointer versionInfoBytes = VERSION_INFO.get();
            String version = Utf8.utf8ToString(true, CTypeConversion.asByteBuffer((PointerBase)versionInfoBytes, (int)Math.toIntExact(SubstrateUtil.strlen(versionInfoBytes).rawValue())));
            VMError.guarantee(version.hashCode() == versionValueHash, "HashCode mismatch for __svm_version_info: actual " + version.hashCode() + " (expected " + versionValueHash + ")");
            return SubstrateUtil.split(version, valueSeparator)[1];
        }
        catch (CharConversionException ignore) {
            throw VMError.shouldNotReachHere("Invalid version info in __svm_version_info");
        }
    }
}

