/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 2011 - 2012 Oracle and/or its affiliates. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License.  You can
 * obtain a copy of the License at
 * http://glassfish.java.net/public/CDDL+GPL_1_1.html
 * or packager/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 *
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at packager/legal/LICENSE.txt.
 *
 * GPL Classpath Exception:
 * Oracle designates this particular file as subject to the "Classpath"
 * exception as provided by Oracle in the GPL Version 2 section of the License
 * file that accompanied this code.
 *
 * Modifications:
 * If applicable, add the following below the License Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyright [year] [name of copyright owner]"
 *
 * Contributor(s):
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */

package org.glassfish.websocket.platform.processors;

import org.glassfish.websocket.api.annotations.WebSocketMessage;
import org.glassfish.websocket.api.annotations.WebSocketClose;
import org.glassfish.websocket.api.annotations.WebSocketOpen;
import org.glassfish.websocket.api.annotations.WebSocketContext;
import org.glassfish.websocket.platform.WebSocketWrapper;
import java.io.IOException;
import java.io.PrintWriter;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import java.util.*;
/**
 *
 * @author dannycoward
 */
public class ClassWriter {

    private static Element findContextInstanceVariableElement(TypeElement clazz) {
        for (Element e : clazz.getEnclosedElements()) {
            WebSocketContext wsc = e.getAnnotation(WebSocketContext.class);
            if (wsc != null ) return e;
        }
        return null;
    }

    public static void writeClass(String packageNameToWrite,
                                    String clazzNameToWrite,
                                    TypeElement clazz,
                                    Set<Element> methods,
                                    RemoteProcessor rp,
                                    PrintWriter pw) throws IOException {
        pw.println("package " + packageNameToWrite + ";");
        pw.println();
        ClassWriter.writeImports(pw, clazz);
        pw.println("public class "
                + clazzNameToWrite + " extends WebSocketEndpoint implements Initable {");

        pw.println("\tprivate " + clazz.getSimpleName() + " bean;");


        pw.println();
        pw.println("\tpublic " + clazzNameToWrite + "() {");
        //pw.println("\t\tsuper();");
        pw.println("\t}");
        pw.println();

        Element contextIVElement = findContextInstanceVariableElement(clazz);

        pw.println("\tpublic void doInit(String path, Set decoders, Set encoders, Object bean, Set methods) {");
        pw.println("\t\tsuper.path = path;");
        pw.println("\t\tthis.bean = (" + clazz.getSimpleName() + ") bean;");
        pw.println("\t\tsuper.encoders = encoders;");
        pw.println("\t\tsuper.decoders = decoders;");
        if (contextIVElement != null) {
            pw.println("\t\tthis.bean." + contextIVElement + " = super.endpointContext;");
        }
        //deal with subprotocols supported by this class
        org.glassfish.websocket.api.annotations.WebSocket wsa = clazz.getAnnotation(org.glassfish.websocket.api.annotations.WebSocket.class);
        String[] subprotocols = wsa.subprotocols();
        if (subprotocols != null) {
            for (int i = 0; i < subprotocols.length; i++) {
                pw.println("\t\tsuper.addSupportedSubprotocol(\""+subprotocols[i]+"\");");
            }
        }

        // set the custom remote implementation class, if necessary
        String wsaRemote = MethodWriter.getRemoteClassFromWebSocket(wsa);
        if (!wsaRemote.equals("java.lang.Object")) {
            String riclz = rp.getImplementationFor(wsaRemote);
            pw.println("\t\tsuper.remoteImplClassname = \"" + riclz + "\";");
        }



        pw.println("\t}");
        pw.println();


        pw.println("\tvoid handleException(org.glassfish.grizzly.websockets.WebSocket socket, Exception e) {");
        pw.println("\t\tSystem.out.println(\"Error replying to client \" + e.getMessage());");
        pw.println("\t\te.printStackTrace();");
        MethodWriter.writeExceptionHandlerMethodBody(clazz, methods, pw);

        pw.println("\t}");
        pw.println();

        // may be multiple methods asking for onMessage calls, all with the same path.
        List<Element> onMessageMethods = getOnMessageMethods(methods);
        MethodWriter.writeOnMessageMethod(clazz, onMessageMethods, rp, pw);

        // write open and close methods
        for (Element nextMethod : methods) {
            if (nextMethod.getAnnotation(WebSocketOpen.class) != null) {
                MethodWriter.writeOnOpenMethod(clazz, nextMethod, rp, pw);
            } else if (nextMethod.getAnnotation(WebSocketClose.class) != null) {
                MethodWriter.writeOnCloseMethod(clazz, nextMethod, rp, pw);
            }
            pw.println();
        }
        pw.println("}");

    }

    private static List<Element> getOnMessageMethods(Set<Element> methods) {
        List<Element> onMessageMethods = new ArrayList<Element>();
        for (Element nextMethod : methods) {
            if (nextMethod.getAnnotation(WebSocketMessage.class) != null) {
                onMessageMethods.add(nextMethod);
            }
        }
        return onMessageMethods;
    }

    public static void writeImports(PrintWriter pw, TypeElement eachClazz) {
        pw.println("import org.glassfish.grizzly.websockets.*;");
        pw.println("import org.glassfish.websocket.platform.*;");
        pw.println("import org.glassfish.websocket.api.*;");
        pw.println("import java.util.*;");
        pw.println("import " + eachClazz.getQualifiedName() + ";");
        pw.println();

    }
}
