/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 2011 - 2012 Oracle and/or its affiliates. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License.  You can
 * obtain a copy of the License at
 * http://glassfish.java.net/public/CDDL+GPL_1_1.html
 * or packager/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 *
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at packager/legal/LICENSE.txt.
 *
 * GPL Classpath Exception:
 * Oracle designates this particular file as subject to the "Classpath"
 * exception as provided by Oracle in the GPL Version 2 section of the License
 * file that accompanied this code.
 *
 * Modifications:
 * If applicable, add the following below the License Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyright [year] [name of copyright owner]"
 *
 * Contributor(s):
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */

package org.glassfish.websocket.platform;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpSession;
import org.glassfish.grizzly.http.HttpRequestPacket;
import org.glassfish.grizzly.websockets.WebSocket;
import org.glassfish.grizzly.websockets.WebSocketApplication;
import org.glassfish.websocket.api.ConversionException;
import org.glassfish.websocket.api.TextDecoder;
import org.glassfish.websocket.api.TextEncoder;
/**
 *
 * @author dannycoward
 */
public abstract class WebSocketEndpoint extends WebSocketApplication {
    protected String path; // this is relative to the servlet context path
    protected String remoteImplClassname = WebSocketWrapper.class.getCanonicalName();
    protected Set decoders;
    protected Set encoders;
    protected List allDecoders;
    protected List allEncoders;
    protected EndpointContextImpl endpointContext;
    //uck, but there isn't a better integration point yet with Grizzy
    protected HttpSession httpSessionForNextOnConnect = null;
    private String originAddressForNextOnConnect = null;
    protected String fullPathForNextOnConnect = "";
    protected List supportedSubprotocols = new ArrayList();

    public WebSocketEndpoint() {
        this.endpointContext = new EndpointContextImpl(BeanServer.getContainerContext(), this);
    }
     // rudimentary path matching algorithm
    protected boolean doesPathMatch(String dynamicPath) {
        if (dynamicPath.equals("*")) {
            return true;
        } else if ((path + dynamicPath).equals(fullPathForNextOnConnect)) {
            return true;
        }
        return false;
    }

    protected String getPathSegment() {
        return fullPathForNextOnConnect.substring(path.length(), fullPathForNextOnConnect.length());
    }

    private void initAllEncoders() {
        if (allEncoders == null) {
            allEncoders = new ArrayList();
            allEncoders.addAll(this.encoders);
            allEncoders.add(org.glassfish.websocket.platform.encoders.StringEncoderNoOp.class);
            allEncoders.add(org.glassfish.websocket.platform.encoders.BooleanEncoder.class);
            allEncoders.add(org.glassfish.websocket.platform.encoders.ByteEncoder.class);
            allEncoders.add(org.glassfish.websocket.platform.encoders.CharEncoder.class);
            allEncoders.add(org.glassfish.websocket.platform.encoders.DoubleEncoder.class);
            allEncoders.add(org.glassfish.websocket.platform.encoders.FloatEncoder.class);
            allEncoders.add(org.glassfish.websocket.platform.encoders.IntEncoder.class);
            allEncoders.add(org.glassfish.websocket.platform.encoders.LongEncoder.class);
            allEncoders.add(org.glassfish.websocket.platform.encoders.ShortEncoder.class);
        }
    }

    private void initAllDecoders() {
        if (allDecoders == null) {
            allDecoders = new ArrayList();
            allDecoders.addAll(this.decoders);
            allDecoders.add(org.glassfish.websocket.platform.decoders.StringDecoderNoOp.class);
            allDecoders.add(org.glassfish.websocket.platform.decoders.BooleanDecoder.class);
            allDecoders.add(org.glassfish.websocket.platform.decoders.IntegerDecoder.class);
            allDecoders.add(org.glassfish.websocket.platform.decoders.LongDecoder.class);
            allDecoders.add(org.glassfish.websocket.platform.decoders.ShortDecoder.class);
            allDecoders.add(org.glassfish.websocket.platform.decoders.FloatDecoder.class);
            allDecoders.add(org.glassfish.websocket.platform.decoders.DoubleDecoder.class);
            allDecoders.add(org.glassfish.websocket.platform.decoders.CharDecoder.class);
        }
    }

    public static String getClassTypeForTypeThatMightBePrimitive(String possiblyPrimitiveType) {
        String type = possiblyPrimitiveType;
        if (possiblyPrimitiveType.equals("boolean")) {
            type = "java.lang.Boolean";
        }  else if (possiblyPrimitiveType.equals("char")) {
            type = "java.lang.Character";
        } else if (possiblyPrimitiveType.equals("double")) {
            type = "java.lang.Double";
        } else if (possiblyPrimitiveType.equals("float")) {
            type = "java.lang.Float";
        } else if (possiblyPrimitiveType.equals("int")) {
            type = "java.lang.Integer";
        } else if (possiblyPrimitiveType.equals("long")) {
            type = "java.lang.Long";
        } else if (possiblyPrimitiveType.equals("short")) {
            type = "java.lang.Short";
        }
        return type;
    }

    public Constructor getStringConstructor(Class c) throws Exception {
        Constructor[] constructors = c.getConstructors();
        for (Constructor nextConstructor : c.getConstructors()) {
            if (nextConstructor.getParameterTypes().length == 1) {
                if (nextConstructor.getParameterTypes()[0].equals(java.lang.String.class)) {
                    return nextConstructor;
                }
            }
        }
        return null;

    }

    public Method getFactoryMethodWithStringParameter(Class c) throws Exception {

        for (Method m : c.getMethods()) {

            if (Modifier.isStatic(m.getModifiers()) &&  m.getReturnType().equals(c)) {
                if (m.getParameterTypes().length == 1 && m.getParameterTypes()[0].equals(java.lang.String.class)) {
                    return m;
                }
            }
        }
        return null;

    }

    public Object doDecode(String message, String possiblyPrimitiveType) throws ConversionException {
        this.initAllDecoders();
        String type = getClassTypeForTypeThatMightBePrimitive(possiblyPrimitiveType);
        //System.out.println("Decode: " + message + " into a " + type);

        for (Object next : this.allDecoders) {
            Class nextClass = (Class) next;
            //System.out.println("Checking... " + nextClass);
            List interfaces = Arrays.asList(nextClass.getInterfaces());
            if (interfaces.contains(org.glassfish.websocket.api.TextDecoder.class)) {
                //System.out.println("Might work...");
                try {
                    Method m = nextClass.getDeclaredMethod("decode", String.class);
                    //System.out.println("found decode method !");
                    Class returnC = m.getReturnType();
                    //System.out.println("Return decoder " + returnC);
                    Class proposedType = ((EndpointContextImpl) endpointContext).getBeanClassloader().loadClass(type);

                    //System.out.println("Return needed " + proposedType);
                    if (proposedType.equals(returnC)) {
                        // we are in luck.

                        TextDecoder decoder = (TextDecoder) nextClass.newInstance();

                        boolean willItDecode = decoder.willDecode(message);
                        //System.out.println("but does it want to ?: " + willItDecode);
                        if (willItDecode) {
                            //System.out.println("Found a decoder (" + decoder+")to decode: " + message + " (string) into a " + type);
                            return decoder.decode(message);
                        }

                    }


                } catch (ConversionException ce) {
                    throw ce;
                } catch (Exception e) {
                    throw new RuntimeException(e);
                }
            } else {
                //System.out.println("Definitely not");
            }

        }
        //System.out.println("Cound NOT decode: " + message + " into a " + type);
        return null;
    }

    public String doEncode(Object o) throws ConversionException {
        this.initAllEncoders();
        //System.out.println("Find encoder for " + o + " of class " + o.getClass());
        for (Object next : this.allEncoders) { // look for encoders that can handle this
            Class type = o.getClass();
            Class nextClass = (Class) next;
            List interfaces = Arrays.asList(nextClass.getInterfaces());
            if (interfaces.contains(org.glassfish.websocket.api.TextEncoder.class)) {
                //System.out.println("This might be it: " + nextClass);
                try {
                    Method m = nextClass.getMethod("encode", o.getClass());
                    if (m != null) {
                        //System.out.println("got it : " + nextClass);
                        TextEncoder te = (TextEncoder) nextClass.newInstance();
                        String returnString = te.encode(o);
                        return returnString;
                    }
                } catch (java.lang.NoSuchMethodException nsme) {
                    // just continue looping
                } catch (ConversionException ce) {
                    throw ce;
                } catch (Exception e) {

                    throw new RuntimeException(e);
                }
            }
        }

        throw new RuntimeException("Unable to encode " + o);
    }



    String getPath() {
        return this.path;
    }

    EndpointContextImpl getEndpointContext() {
        return this.endpointContext;
    }

    String getRemoteImplClassname() {
        return this.remoteImplClassname;
    }

    @Override
    public boolean isApplicationRequest(HttpRequestPacket o) {
        //System.out.println("Checking WSApp path=" + path + " matches ? " + o.getRequestURI());

        //boolean match = o.getRequestURI().equals(path);
        boolean match = o.getRequestURI().startsWith(path);
        //System.out.println("? " + match);
        httpSessionForNextOnConnect = this.getHttpSession(o);
        this.originAddressForNextOnConnect = o.getHeader("Origin");
        if (match) {
            fullPathForNextOnConnect = o.getRequestURI();
        } else  {
            fullPathForNextOnConnect = "";
        }
        return match;
    }

    // I don't really know what Grizzly does with this for sure, but
    // I'm going to guess that it wants a sublist of all the supplied
    // subprotocol names that this application will support...
    public List<String> getSupportedProtocols(List<String> subProtocol) {
        List<String> supported = new ArrayList<String>();
        for (String nextRequestedProtocolName : subProtocol) {
            if (this.supportedSubprotocols.contains(nextRequestedProtocolName)) {
                supported.add(nextRequestedProtocolName);
            }
        }
        //System.out.println("Requested protocols = " + subProtocol);
        //System.out.println("Supported protocols = " + supported);
        return supported;
    }

    // called by the wrapper based on the subprotocols listed in the class annotation
    protected void addSupportedSubprotocol(String subprotocol) {
        supportedSubprotocols.add(subprotocol);
    }

    public void onConnect(WebSocket socket) {
        WebSocketWrapper wsw = WebSocketWrapper.getWebSocketWrapper(socket, this);
        if (wsw == null) {
            throw new RuntimeException("XCouldn't find web socket wrapper for this socket for "+ this.remoteImplClassname);
        }
        wsw.setAddress(this.originAddressForNextOnConnect);
        if (ContainerContextImpl.WEB_MODE) {
            if (httpSessionForNextOnConnect != null) {
                ((WebSocketConversationImpl) wsw.getConversation()).setHttpSession(httpSessionForNextOnConnect);
                httpSessionForNextOnConnect = null;
            } else {
                //throw new RuntimeException("Failed to connect the http session with this web socket session");
            }

        } else {

        }
    }

    public void onClose(WebSocket socket) {
        throw new RuntimeException("I got closed...");
    }

    public HttpSession getHttpSession(HttpRequestPacket o) {
        //System.out.println(o.getHeaders());

        /** TO DO FIX THIS
        Cookies cookies = o.getCookies();
        int count = cookies.getCookieCount();
        //System.out.println("There are : " + count + " cookies on the ws request.");
        for (int i = 0; i < count; i++) {
            ServerCookie sc = cookies.getCookie(i);
            //System.out.println("---" + sc.getValue());
            String potentialSessionID = sc.getValue().toString();
            HttpSession session = HttpSessionManager.getInstance().findSessionByID(potentialSessionID);
            if (session != null) {
                //System.out.println("got " + session);
                return session;
            }
        }
        */
        return null;

    }

    /*
    public void dump(Request o, PrintStream os) {
        os.println("decoded URI: " + o.decodedURI());
        os.println("request URI: " + o.requestURI());
        os.println("auth type: " + o.getAuthType());
        os.println("auth type: " + o.getAuthType());
        os.println("cookies: " + o.getCookies());
        os.println("request processor: " + o.getRequestProcessor());
        os.println("origin processor: " + o.getHeader("Origin"));
        os.println("client address: " + o.getLocalAddress());

    }*/

    public void remove() {

    }


}
