/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.transport.tcp.io;

import com.sun.xml.ws.transport.tcp.io.DataInOutUtils;
import com.sun.xml.ws.transport.tcp.pool.LifeCycle;
import com.sun.xml.ws.transport.tcp.resources.MessagesMessages;
import com.sun.xml.ws.transport.tcp.util.FrameType;
import com.sun.xml.ws.transport.tcp.util.SelectorFactory;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FramedMessageInputStream
extends InputStream
implements LifeCycle {
    private static final Logger logger = Logger.getLogger("com.sun.metro.transport.tcp.streams");
    private ByteBuffer byteBuffer;
    private SocketChannel socketChannel;
    private static final int READ_TIMEOUT = 30000;
    static final int READ_TRY = 10;
    private final int[] headerTmpArray = new int[2];
    private boolean isDirectMode;
    private int frameSize;
    private int frameBytesRead;
    private boolean isLastFrame;
    private int currentFrameDataSize;
    private int channelId;
    private int contentId;
    private int messageId;
    private final Map<Integer, String> contentProps = new HashMap<Integer, String>(8);
    private boolean isReadingHeader;
    private long receivedMessageLength;

    public FramedMessageInputStream() {
        this(4096);
    }

    public FramedMessageInputStream(int frameSize) {
        this.setFrameSize(frameSize);
    }

    public void setSocketChannel(SocketChannel socketChannel) {
        this.socketChannel = socketChannel;
    }

    public int getChannelId() {
        return this.channelId;
    }

    public int getMessageId() {
        return this.messageId;
    }

    public int getContentId() {
        return this.contentId;
    }

    public Map<Integer, String> getContentProperties() {
        return this.contentProps;
    }

    public boolean isDirectMode() {
        return this.isDirectMode;
    }

    public void setDirectMode(boolean isDirectMode) {
        this.reset();
        this.isDirectMode = isDirectMode;
    }

    public void setFrameSize(int frameSize) {
        this.frameSize = frameSize;
    }

    public void setByteBuffer(ByteBuffer byteBuffer) {
        this.byteBuffer = byteBuffer;
    }

    @Override
    public int available() {
        return this.remaining();
    }

    @Override
    public void close() {
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public int read() {
        int eof;
        if (!this.isDirectMode) {
            if (this.isLastFrame && this.frameBytesRead >= this.currentFrameDataSize) {
                return -1;
            }
            int eof2 = 0;
            if (!this.byteBuffer.hasRemaining()) {
                eof2 = this.readFromChannel();
            }
            if (eof2 == -1 || this.readFrameHeaderIfRequired() == -1) {
                return -1;
            }
            if (this.byteBuffer.hasRemaining()) {
                ++this.frameBytesRead;
                ++this.receivedMessageLength;
                return this.byteBuffer.get() & 0xFF;
            }
            return this.read();
        }
        if (!this.byteBuffer.hasRemaining() && (eof = this.readFromChannel()) == -1) {
            return -1;
        }
        return this.byteBuffer.get() & 0xFF;
    }

    @Override
    public int read(byte[] b) {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int offset, int length) {
        int eof;
        if (!this.isDirectMode) {
            if (this.isLastFrame && this.frameBytesRead >= this.currentFrameDataSize) {
                return -1;
            }
            int eof2 = 0;
            if (!this.byteBuffer.hasRemaining()) {
                eof2 = this.readFromChannel();
            }
            if (eof2 == -1 || this.readFrameHeaderIfRequired() == -1) {
                return -1;
            }
            int remaining = this.remaining();
            if (remaining == 0) {
                return this.read(b, offset, length);
            }
            if (length > remaining) {
                length = remaining;
            }
            this.byteBuffer.get(b, offset, length);
            this.frameBytesRead += length;
            this.receivedMessageLength += (long)length;
            return length;
        }
        if (!this.byteBuffer.hasRemaining() && (eof = this.readFromChannel()) == -1) {
            return -1;
        }
        int remaining = this.remaining();
        if (length > remaining) {
            length = remaining;
        }
        this.byteBuffer.get(b, offset, length);
        return length;
    }

    public void forceHeaderRead() throws IOException {
        this.readHeader();
    }

    private int readFrameHeaderIfRequired() {
        if (!(this.isDirectMode || this.isLastFrame || this.isReadingHeader || this.frameBytesRead != 0 && this.frameBytesRead != this.currentFrameDataSize)) {
            try {
                this.readHeader();
            }
            catch (IOException ex) {
                return -1;
            }
        }
        return 0;
    }

    private void readHeader() throws IOException {
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, MessagesMessages.WSTCP_1060_FRAMED_MESSAGE_IS_READ_HEADER_ENTER());
        }
        this.frameBytesRead = 0;
        this.isReadingHeader = true;
        int lowNeebleValue = DataInOutUtils.readInts4(this, this.headerTmpArray, 2, 0);
        this.channelId = this.headerTmpArray[0];
        this.messageId = this.headerTmpArray[1];
        if (FrameType.isFrameContainsParams(this.messageId)) {
            lowNeebleValue = DataInOutUtils.readInts4(this, this.headerTmpArray, 2, lowNeebleValue);
            this.contentId = this.headerTmpArray[0];
            int paramNumber = this.headerTmpArray[1];
            for (int i = 0; i < paramNumber; ++i) {
                DataInOutUtils.readInts4(this, this.headerTmpArray, 2, lowNeebleValue);
                int paramId = this.headerTmpArray[0];
                int paramValueLen = this.headerTmpArray[1];
                byte[] paramValueBytes = new byte[paramValueLen];
                DataInOutUtils.readFully(this, paramValueBytes);
                String paramValue = new String(paramValueBytes, "UTF-8");
                this.contentProps.put(paramId, paramValue);
                lowNeebleValue = 0;
            }
        }
        this.currentFrameDataSize = DataInOutUtils.readInt8(this);
        this.isLastFrame = FrameType.isLastFrame(this.messageId);
        this.currentFrameDataSize += this.frameBytesRead;
        this.isReadingHeader = false;
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, MessagesMessages.WSTCP_1061_FRAMED_MESSAGE_IS_READ_HEADER_DONE(this.channelId, this.messageId, this.contentId, this.contentProps, this.currentFrameDataSize, this.isLastFrame));
        }
    }

    private int readFromChannel() {
        int eof = 0;
        for (int i = 0; i < 10 && (eof = this.doRead()) == 0; ++i) {
        }
        return eof;
    }

    public void skipToEndOfMessage() throws EOFException {
        do {
            this.readFrameHeaderIfRequired();
            this.skipToEndOfFrame();
            this.frameBytesRead = 0;
        } while (!this.isLastFrame);
    }

    private void skipToEndOfFrame() throws EOFException {
        if (this.currentFrameDataSize > 0) {
            if (this.byteBuffer.hasRemaining()) {
                int remainFrameBytes = this.currentFrameDataSize - this.frameBytesRead;
                if (remainFrameBytes <= this.byteBuffer.remaining()) {
                    this.byteBuffer.position(this.byteBuffer.position() + remainFrameBytes);
                    return;
                }
                this.frameBytesRead += this.byteBuffer.remaining();
                this.byteBuffer.position(this.byteBuffer.limit());
            }
            while (this.frameBytesRead < this.currentFrameDataSize) {
                int eof = this.readFromChannel();
                if (eof == -1) {
                    String errorMessage = MessagesMessages.WSTCP_1062_FRAMED_MESSAGE_IS_READ_UNEXPECTED_EOF(this.isLastFrame, this.frameBytesRead, this.frameSize, this.currentFrameDataSize);
                    logger.log(Level.SEVERE, errorMessage);
                    throw new EOFException(errorMessage);
                }
                this.frameBytesRead += eof;
                this.byteBuffer.position(this.byteBuffer.position() + eof);
            }
            this.byteBuffer.position(this.byteBuffer.position() - (this.frameBytesRead - this.currentFrameDataSize));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int doRead() {
        if (this.socketChannel == null) {
            return -1;
        }
        if (this.isEOF()) {
            return -1;
        }
        this.byteBuffer.clear();
        int byteRead = 0;
        Selector readSelector = null;
        SelectionKey tmpKey = null;
        try {
            int count;
            do {
                count = this.socketChannel.read(this.byteBuffer);
                byteRead += count;
            } while (count > 0);
            if (count == -1 && byteRead >= 0) {
                ++byteRead;
            }
            if (byteRead == 0) {
                readSelector = SelectorFactory.getSelector();
                if (readSelector == null) {
                    int n = 0;
                    return n;
                }
                tmpKey = this.socketChannel.register(readSelector, 1);
                tmpKey.interestOps(tmpKey.interestOps() | 1);
                int code = readSelector.select(30000L);
                tmpKey.interestOps(tmpKey.interestOps() & 0xFFFFFFFE);
                if (code == 0) {
                    int n = 0;
                    return n;
                }
                do {
                    count = this.socketChannel.read(this.byteBuffer);
                    byteRead += count;
                } while (count > 0);
                if (count == -1 && byteRead >= 0) {
                    ++byteRead;
                }
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, MessagesMessages.WSTCP_0018_ERROR_READING_FROM_SOCKET(), e);
            int n = -1;
            return n;
        }
        finally {
            if (tmpKey != null) {
                tmpKey.cancel();
            }
            if (readSelector != null) {
                try {
                    readSelector.selectNow();
                }
                catch (IOException ex) {}
                SelectorFactory.returnSelector(readSelector);
            }
            this.byteBuffer.flip();
        }
        return byteRead;
    }

    public boolean isMessageInProcess() {
        return this.currentFrameDataSize != 0 && !this.isEOF();
    }

    private boolean isEOF() {
        return this.isLastFrame && this.frameBytesRead >= this.currentFrameDataSize;
    }

    private int remaining() {
        if (this.isReadingHeader || this.isDirectMode) {
            return this.byteBuffer.remaining();
        }
        return Math.min(this.currentFrameDataSize - this.frameBytesRead, this.byteBuffer.remaining());
    }

    @Override
    public void reset() {
        this.frameBytesRead = 0;
        this.currentFrameDataSize = 0;
        this.isLastFrame = false;
        this.isReadingHeader = false;
        this.contentId = -1;
        this.messageId = -1;
        this.contentProps.clear();
        this.receivedMessageLength = 0L;
    }

    @Override
    public void activate() {
    }

    @Override
    public void passivate() {
        this.reset();
        this.setSocketChannel(null);
        this.setByteBuffer(null);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(100);
        buffer.append("ByteBuffer: ");
        buffer.append(this.byteBuffer);
        buffer.append(" FrameBytesRead: ");
        buffer.append(this.frameBytesRead);
        buffer.append(" CurrentFrameDataSize: ");
        buffer.append(this.currentFrameDataSize);
        buffer.append(" isLastFrame: ");
        buffer.append(this.isLastFrame);
        buffer.append(" isDirectMode: ");
        buffer.append(this.isDirectMode);
        buffer.append(" isReadingHeader: ");
        buffer.append(this.isReadingHeader);
        return buffer.toString();
    }
}

