/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.transport.tcp.grizzly;

import com.sun.enterprise.web.connector.grizzly.SelectorThread;
import com.sun.istack.NotNull;
import com.sun.xml.ws.transport.tcp.grizzly.WSTCPProtocolHandler;
import com.sun.xml.ws.transport.tcp.grizzly.WSTCPStreamAlgorithm;
import com.sun.xml.ws.transport.tcp.server.IncomeMessageProcessor;
import com.sun.xml.ws.transport.tcp.server.TCPMessageListener;
import com.sun.xml.ws.transport.tcp.server.WSTCPConnector;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Properties;

public class GrizzlyTCPConnector
implements WSTCPConnector {
    private SelectorThread selectorThread;
    private String host;
    private int port;
    private TCPMessageListener listener;
    private final Properties properties;
    private final boolean isPortUnificationMode;

    public GrizzlyTCPConnector(@NotNull String host, int port, @NotNull TCPMessageListener listener) {
        this.host = host;
        this.port = port;
        this.listener = listener;
        this.isPortUnificationMode = false;
        this.properties = new Properties();
    }

    public GrizzlyTCPConnector(@NotNull TCPMessageListener listener, @NotNull Properties properties) {
        this.listener = listener;
        this.isPortUnificationMode = true;
        this.properties = properties;
        this.port = -1;
    }

    public void listen() throws IOException {
        if (this.isPortUnificationMode) {
            this.listenOnUnifiedPort();
        } else {
            this.listenOnNewPort();
        }
    }

    public void listenOnNewPort() throws IOException {
        try {
            IncomeMessageProcessor.registerListener(this.port, this.listener, this.properties);
            this.selectorThread = new SelectorThread();
            this.selectorThread.setClassLoader(WSTCPStreamAlgorithm.class.getClassLoader());
            this.selectorThread.setAlgorithmClassName(WSTCPStreamAlgorithm.class.getName());
            this.selectorThread.setAddress(InetAddress.getByName(this.host));
            this.selectorThread.setPort(this.port);
            this.selectorThread.setBufferSize(4096);
            this.selectorThread.setMaxKeepAliveRequests(-1);
            this.selectorThread.initEndpoint();
            this.selectorThread.start();
        }
        catch (IOException e) {
            this.close();
            throw e;
        }
        catch (InstantiationException e) {
            this.close();
            throw new IOException(e.getClass().getName() + ": " + e.getMessage());
        }
    }

    public void listenOnUnifiedPort() {
        WSTCPProtocolHandler.setIncomingMessageProcessor(IncomeMessageProcessor.registerListener(0, this.listener, this.properties));
    }

    public void close() {
        if (this.selectorThread != null) {
            this.selectorThread.stopEndpoint();
            IncomeMessageProcessor.releaseListener(this.selectorThread.getPort());
            this.selectorThread = null;
        }
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public TCPMessageListener getListener() {
        return this.listener;
    }

    public void setListener(TCPMessageListener listener) {
        this.listener = listener;
    }

    public void setFrameSize(int frameSize) {
        this.selectorThread.setBufferSize(frameSize);
    }

    public int getFrameSize() {
        return this.selectorThread.getBufferSize();
    }
}

