/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security.keys.keyresolver;

import com.sun.org.apache.xml.internal.security.keys.keyresolver.KeyResolverException;
import com.sun.org.apache.xml.internal.security.keys.storage.StorageResolver;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.SecretKey;
import org.w3c.dom.Element;

public abstract class KeyResolverSpi {
    protected Map _properties = null;
    protected boolean globalResolver = false;

    public boolean engineCanResolve(Element element, String string2, StorageResolver storageResolver) {
        throw new UnsupportedOperationException();
    }

    public PublicKey engineResolvePublicKey(Element element, String string2, StorageResolver storageResolver) throws KeyResolverException {
        throw new UnsupportedOperationException();
    }

    public PublicKey engineLookupAndResolvePublicKey(Element element, String string2, StorageResolver storageResolver) throws KeyResolverException {
        KeyResolverSpi keyResolverSpi = this.cloneIfNeeded();
        if (!keyResolverSpi.engineCanResolve(element, string2, storageResolver)) {
            return null;
        }
        return keyResolverSpi.engineResolvePublicKey(element, string2, storageResolver);
    }

    private KeyResolverSpi cloneIfNeeded() throws KeyResolverException {
        KeyResolverSpi keyResolverSpi = this;
        if (this.globalResolver) {
            try {
                keyResolverSpi = (KeyResolverSpi)this.getClass().newInstance();
            }
            catch (InstantiationException instantiationException) {
                throw new KeyResolverException("", instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new KeyResolverException("", illegalAccessException);
            }
        }
        return keyResolverSpi;
    }

    public X509Certificate engineResolveX509Certificate(Element element, String string2, StorageResolver storageResolver) throws KeyResolverException {
        throw new UnsupportedOperationException();
    }

    public X509Certificate engineLookupResolveX509Certificate(Element element, String string2, StorageResolver storageResolver) throws KeyResolverException {
        KeyResolverSpi keyResolverSpi = this.cloneIfNeeded();
        if (!keyResolverSpi.engineCanResolve(element, string2, storageResolver)) {
            return null;
        }
        return keyResolverSpi.engineResolveX509Certificate(element, string2, storageResolver);
    }

    public SecretKey engineResolveSecretKey(Element element, String string2, StorageResolver storageResolver) throws KeyResolverException {
        throw new UnsupportedOperationException();
    }

    public SecretKey engineLookupAndResolveSecretKey(Element element, String string2, StorageResolver storageResolver) throws KeyResolverException {
        KeyResolverSpi keyResolverSpi = this.cloneIfNeeded();
        if (!keyResolverSpi.engineCanResolve(element, string2, storageResolver)) {
            return null;
        }
        return keyResolverSpi.engineResolveSecretKey(element, string2, storageResolver);
    }

    public void engineSetProperty(String string2, String string3) {
        if (this._properties == null) {
            this._properties = new HashMap();
        }
        this._properties.put(string2, string3);
    }

    public String engineGetProperty(String string2) {
        if (this._properties == null) {
            return null;
        }
        return (String)this._properties.get(string2);
    }

    public boolean understandsProperty(String string2) {
        if (this._properties == null) {
            return false;
        }
        return this._properties.get(string2) != null;
    }

    public void setGlobalResolver(boolean bl) {
        this.globalResolver = bl;
    }
}

