/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.xml.v1_0_0;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Polygon;
import org.geotools.gml2.FeatureTypeCache;
import org.geotools.xml.BindingWalkerFactory;
import org.geotools.xml.ElementInstance;
import org.geotools.xml.Node;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.vfny.geoserver.global.Data;
import org.vfny.geoserver.global.FeatureTypeInfo;

public final class GMLAbstractFeatureTypeBinding
extends org.geotools.gml2.bindings.GMLAbstractFeatureTypeBinding {
    GeometryFactory geometryFactory;
    Data catalog;

    public GMLAbstractFeatureTypeBinding(FeatureTypeCache featureTypeCache, BindingWalkerFactory bwFactory, GeometryFactory geometryFactory, Data catalog) {
        super(featureTypeCache, bwFactory);
        this.geometryFactory = geometryFactory;
        this.catalog = catalog;
    }

    public Object parse(ElementInstance instance, Node node, Object value) throws Exception {
        FeatureTypeInfo meta = this.catalog.getFeatureTypeInfo(instance.getName(), instance.getNamespace());
        if (meta != null) {
            SimpleFeatureType featureType = meta.getFeatureType();
            for (int i = 0; i < featureType.getAttributeCount(); ++i) {
                Node boundedByNode;
                AttributeDescriptor attributeType = featureType.getDescriptor(i);
                String name = attributeType.getLocalName();
                Class type = attributeType.getType().getBinding();
                if (!"boundedBy".equals(name) || !((boundedByNode = node.getChild("boundedBy")).getValue() instanceof Envelope)) continue;
                Envelope bounds = (Envelope)boundedByNode.getValue();
                if (type.isAssignableFrom(Polygon.class)) {
                    Polygon polygon = this.polygon(bounds);
                    boundedByNode.setValue((Object)polygon);
                    continue;
                }
                if (!type.isAssignableFrom(MultiPolygon.class)) continue;
                MultiPolygon multiPolygon = this.geometryFactory.createMultiPolygon(new Polygon[]{this.polygon(bounds)});
                boundedByNode.setValue((Object)multiPolygon);
            }
        }
        return super.parse(instance, node, value);
    }

    Polygon polygon(Envelope bounds) {
        return this.geometryFactory.createPolygon(this.geometryFactory.createLinearRing(new Coordinate[]{new Coordinate(bounds.getMinX(), bounds.getMinY()), new Coordinate(bounds.getMinX(), bounds.getMaxY()), new Coordinate(bounds.getMaxX(), bounds.getMaxY()), new Coordinate(bounds.getMaxX(), bounds.getMinY()), new Coordinate(bounds.getMinX(), bounds.getMinY())}), null);
    }
}

