/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs;

import java.io.IOException;
import net.opengis.wfs.GetGmlObjectType;
import org.geoserver.wfs.GetFeature;
import org.geoserver.wfs.WFS;
import org.geoserver.wfs.WFSException;
import org.geotools.data.DataStore;
import org.geotools.data.GmlObjectStore;
import org.geotools.factory.Hints;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.identity.GmlObjectId;
import org.vfny.geoserver.global.Data;
import org.vfny.geoserver.global.DataStoreInfo;

public class GetGmlObject {
    WFS wfs;
    Data catalog;
    FilterFactory filterFactory;

    public GetGmlObject(WFS wfs, Data catalog) {
        this.wfs = wfs;
        this.catalog = catalog;
    }

    public void setFilterFactory(FilterFactory filterFactory) {
        this.filterFactory = filterFactory;
    }

    public Object run(GetGmlObjectType request) throws WFSException {
        GmlObjectId id = request.getGmlObjectId();
        Hints hints = new Hints();
        if (request.getTraverseXlinkDepth() != null) {
            Integer depth = GetFeature.traverseXlinkDepth(request.getTraverseXlinkDepth());
            hints.put((Object)Hints.ASSOCIATION_TRAVERSAL_DEPTH, (Object)depth);
        }
        for (DataStoreInfo dsInfo : this.catalog.getDataStores()) {
            DataStore ds = dsInfo.getDataStore();
            if (!(ds instanceof GmlObjectStore)) continue;
            try {
                Object obj = ((GmlObjectStore)ds).getGmlObject(id, hints);
                if (obj == null) continue;
                return obj;
            }
            catch (IOException e) {
                throw new WFSException(e);
            }
        }
        throw new WFSException("No such object: " + id);
    }
}

