/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs;

import java.util.ArrayList;
import java.util.List;
import net.opengis.wfs.GetCapabilitiesType;
import org.eclipse.emf.common.util.EList;
import org.geoserver.ows.util.RequestUtils;
import org.geoserver.wfs.CapabilitiesTransformer;
import org.geoserver.wfs.WFS;
import org.geoserver.wfs.WFSException;
import org.geotools.util.Version;
import org.vfny.geoserver.global.Data;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetCapabilities {
    WFS wfs;
    Data catalog;
    List<Version> versions;

    public GetCapabilities(WFS wfs, Data catalog, List<Version> versions) {
        this.wfs = wfs;
        this.catalog = catalog;
        this.versions = versions;
    }

    public CapabilitiesTransformer run(GetCapabilitiesType request) throws WFSException {
        CapabilitiesTransformer capsTransformer;
        String version;
        if (this.wfs.getCiteConformanceHacks() && request.getUpdateSequence() != null) {
            throw new WFSException("Invalid update sequence", "InvalidUpdateSequence");
        }
        if (this.wfs.getCiteConformanceHacks() && !request.isSetService()) {
            throw new WFSException("Service not set", "MissingParameterValue", "service");
        }
        ArrayList<String> provided = new ArrayList<String>();
        for (Version v : this.versions) {
            provided.add(v.toString());
        }
        EList accepted = null;
        if (request.getAcceptVersions() != null) {
            accepted = request.getAcceptVersions().getVersion();
        }
        if ("1.0.0".equals(version = RequestUtils.getVersionPreOws(provided, accepted))) {
            capsTransformer = new CapabilitiesTransformer.WFS1_0(this.wfs, this.catalog);
        } else if ("1.1.0".equals(version)) {
            capsTransformer = new CapabilitiesTransformer.WFS1_1(this.wfs, this.catalog);
        } else {
            throw new WFSException("Could not understand version:" + version);
        }
        capsTransformer.setEncoding(this.wfs.getCharSet());
        return capsTransformer;
    }
}

