/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs;

import java.util.ArrayList;
import java.util.Collection;
import javax.xml.namespace.QName;
import net.opengis.wfs.DescribeFeatureTypeType;
import org.geoserver.wfs.WFS;
import org.geoserver.wfs.WFSException;
import org.vfny.geoserver.global.Data;
import org.vfny.geoserver.global.FeatureTypeInfo;
import org.vfny.geoserver.global.NameSpaceInfo;

public class DescribeFeatureType {
    private Data catalog;
    private WFS wfs;

    public DescribeFeatureType(WFS wfs, Data catalog) {
        this.catalog = catalog;
        this.wfs = wfs;
    }

    public WFS getWFS() {
        return this.wfs;
    }

    public void setWFS(WFS wfs) {
        this.wfs = wfs;
    }

    public Data getCatalog() {
        return this.catalog;
    }

    public void setCatalog(Data catalog) {
        this.catalog = catalog;
    }

    public FeatureTypeInfo[] run(DescribeFeatureTypeType request) throws WFSException {
        ArrayList names = new ArrayList(request.getTypeName());
        boolean citeConformance = this.getWFS().getCiteConformanceHacks();
        if (!citeConformance) {
            ArrayList<QName> hackedNames = new ArrayList<QName>(names.size());
            Data catalog = this.getWFS().getData();
            NameSpaceInfo defaultNameSpace = catalog.getDefaultNameSpace();
            if (defaultNameSpace == null) {
                throw new IllegalStateException("No default namespace configured in GeoServer");
            }
            String defaultNsUri = defaultNameSpace.getURI();
            for (QName name : names) {
                String nsUri = name.getNamespaceURI();
                if ("http://www.opengis.net/wfs".equals(nsUri)) {
                    name = new QName(defaultNsUri, name.getLocalPart());
                }
                hackedNames.add(name);
            }
            names = hackedNames;
        }
        Collection infos = this.catalog.getFeatureTypeInfos().values();
        ArrayList<Object> requested = new ArrayList<Object>();
        if (!names.isEmpty()) {
            block1: for (QName name : names) {
                for (FeatureTypeInfo meta : infos) {
                    String namespace = meta.getNameSpace().getURI();
                    String local = meta.getTypeName();
                    if (!namespace.equals(name.getNamespaceURI()) || !local.equals(name.getLocalPart())) continue;
                    requested.add(meta);
                    continue block1;
                }
                String msg = "Could not find type: " + name;
                if (citeConformance) {
                    msg = msg + ". \nStrict WFS protocol conformance is being applied.\nMake sure the type name is correctly qualified";
                }
                throw new WFSException(msg);
            }
        } else {
            requested.addAll(infos);
        }
        return requested.toArray(new FeatureTypeInfo[requested.size()]);
    }
}

