/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wcs;

import java.util.logging.Logger;
import org.geoserver.platform.ServiceException;
import org.geotools.util.logging.Logging;
import org.vfny.geoserver.global.GeoServer;

public class WcsException
extends ServiceException {
    private static Logger LOGGER = Logging.getLogger((String)"org.vfny.geoserver.wcs");
    private static final String SE_XML = "application/vnd.ogc.se_xml";

    public WcsException(String message) {
        super(message);
    }

    public WcsException(Throwable e) {
        super(e);
    }

    public WcsException(String message, String locator) {
        super(message, locator);
    }

    public WcsException(String message, WcsExceptionCode code, String locator) {
        super(message, code.name(), locator);
    }

    public WcsException(String message, Throwable cause) {
        super(message, cause);
    }

    public WcsException(Throwable e, String preMessage, String locator) {
        super(e, preMessage, locator);
    }

    public String getMimeType(GeoServer geoserver) {
        return "application/vnd.ogc.se_xml; charset=" + geoserver.getCharSet().name();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum WcsExceptionCode {
        MissingParameterValue,
        InvalidParameterValue,
        NoApplicableCode,
        UnsupportedCombination,
        NotEnoughStorage,
        InvalidUpdateSequence,
        CurrentUpdateSequence;

    }
}

