/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.global.xml;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.geoserver.catalog.Catalog;
import org.geoserver.data.util.CoverageStoreUtils;
import org.geoserver.ows.util.XmlCharsetDetector;
import org.geoserver.util.ReaderUtils;
import org.geotools.coverage.grid.GeneralGridRange;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.filter.FilterDOMParser;
import org.geotools.geometry.GeneralDirectPosition;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.referencing.operation.DefaultMathTransformFactory;
import org.geotools.referencing.operation.matrix.GeneralMatrix;
import org.geotools.util.NameFactory;
import org.geotools.util.NumberRange;
import org.geotools.util.logging.Logging;
import org.opengis.coverage.grid.GridEnvelope;
import org.opengis.coverage.grid.GridGeometry;
import org.opengis.filter.Filter;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.InternationalString;
import org.vfny.geoserver.global.ConfigurationException;
import org.vfny.geoserver.global.CoverageDimension;
import org.vfny.geoserver.global.FeatureTypeInfo;
import org.vfny.geoserver.global.GeoserverDataDirectory;
import org.vfny.geoserver.global.MetaDataLink;
import org.vfny.geoserver.global.dto.AttributeTypeInfoDTO;
import org.vfny.geoserver.global.dto.ContactDTO;
import org.vfny.geoserver.global.dto.CoverageInfoDTO;
import org.vfny.geoserver.global.dto.CoverageStoreInfoDTO;
import org.vfny.geoserver.global.dto.DataDTO;
import org.vfny.geoserver.global.dto.DataStoreInfoDTO;
import org.vfny.geoserver.global.dto.FeatureTypeInfoDTO;
import org.vfny.geoserver.global.dto.GeoServerDTO;
import org.vfny.geoserver.global.dto.LegendURLDTO;
import org.vfny.geoserver.global.dto.NameSpaceInfoDTO;
import org.vfny.geoserver.global.dto.ServiceDTO;
import org.vfny.geoserver.global.dto.StyleDTO;
import org.vfny.geoserver.global.dto.WCSDTO;
import org.vfny.geoserver.global.dto.WFSDTO;
import org.vfny.geoserver.global.dto.WMSDTO;
import org.vfny.geoserver.global.xml.NameSpaceElement;
import org.vfny.geoserver.global.xml.NameSpaceTranslator;
import org.vfny.geoserver.global.xml.NameSpaceTranslatorFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLConfigReader {
    private static final Logger LOGGER = Logging.getLogger((String)"org.vfny.geoserver.global");
    private File root;
    private boolean initialized = false;
    private WMSDTO wms;
    private WFSDTO wfs;
    private WCSDTO wcs;
    private GeoServerDTO geoServer;
    private DataDTO data;
    ServletContext context;
    Catalog catalog;

    protected XMLConfigReader(ServletContext context) {
        this.context = context;
        this.wms = new WMSDTO();
        this.wfs = new WFSDTO();
        this.wcs = new WCSDTO();
        this.geoServer = new GeoServerDTO();
        this.data = new DataDTO();
        this.root = new File(".");
    }

    public XMLConfigReader(File root, ServletContext context, Catalog catalog) throws ConfigurationException {
        this.root = root;
        this.context = context;
        this.catalog = catalog;
        this.wms = new WMSDTO();
        this.wfs = new WFSDTO();
        this.wcs = new WCSDTO();
        this.geoServer = new GeoServerDTO();
        this.data = new DataDTO();
        this.load();
        this.initialized = true;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    protected void load() throws ConfigurationException {
        try {
            this.root = ReaderUtils.checkFile((File)this.root, (boolean)true);
        }
        catch (FileNotFoundException e) {
            throw new ConfigurationException("Can't access " + this.root.getAbsolutePath(), e);
        }
        File servicesFile = GeoserverDataDirectory.findConfigFile("services.xml");
        File catalogFile = GeoserverDataDirectory.findConfigFile("catalog.xml");
        if (servicesFile == null) {
            throw new ConfigurationException("Invalid data dir, it does not contain a valid services.xml");
        }
        if (catalogFile == null) {
            throw new ConfigurationException("Invalid data dir, it does not contain a valid catalog.xml");
        }
        this.loadServices(servicesFile);
        File featureTypeDir = GeoserverDataDirectory.findCreateConfigDir("featureTypes");
        File styleDir = GeoserverDataDirectory.findCreateConfigDir("styles");
        File coverageDir = GeoserverDataDirectory.findCreateConfigDir("coverages");
        this.loadCatalog(catalogFile, featureTypeDir, styleDir, coverageDir);
    }

    protected void loadServices(File configFile) throws ConfigurationException {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.config(new StringBuffer("Loading configuration file: ").append(configFile).toString());
        }
        Element configElem = null;
        try {
            Reader reader = XmlCharsetDetector.getCharsetAwareReader((InputStream)new FileInputStream(configFile));
            configElem = ReaderUtils.parse((Reader)reader);
            reader.close();
        }
        catch (FileNotFoundException e) {
            throw new ConfigurationException(configFile + " was not found", e);
        }
        catch (Exception e) {
            throw new ConfigurationException(configFile + " contents do not seem to be valid", e);
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("parsing configuration documents");
        }
        Element elem = (Element)configElem.getElementsByTagName("global").item(0);
        this.loadGlobal(elem);
        NodeList configuredServices = configElem.getElementsByTagName("service");
        boolean foundWCS = false;
        int nServices = configuredServices.getLength();
        for (int i = 0; i < nServices; ++i) {
            elem = (Element)configuredServices.item(i);
            String serviceType = elem.getAttribute("type");
            if ("WCS".equalsIgnoreCase(serviceType)) {
                foundWCS = true;
                this.loadWCS(elem);
                continue;
            }
            if ("WFS".equalsIgnoreCase(serviceType)) {
                this.loadWFS(elem);
                continue;
            }
            if ("WMS".equalsIgnoreCase(serviceType)) {
                this.loadWMS(elem);
                continue;
            }
            LOGGER.warning("Ignoring unknown service type: " + serviceType);
        }
        if (!foundWCS) {
            this.wcs = this.defaultWcsDto();
        }
    }

    private WCSDTO defaultWcsDto() {
        ServiceDTO service;
        WCSDTO dto;
        block2: {
            dto = new WCSDTO();
            service = new ServiceDTO();
            service.setName("My GeoServer WCS");
            service.setTitle("My GeoServer WCS");
            service.setEnabled(true);
            ArrayList<String> keyWords = new ArrayList<String>();
            keyWords.add("WCS");
            keyWords.add("WMS");
            keyWords.add("GEOSERVER");
            service.setKeywords(keyWords);
            MetaDataLink mdl = new MetaDataLink(this.catalog.getFactory().createMetadataLink());
            mdl.setAbout("http://geoserver.org");
            mdl.setType("undef");
            mdl.setMetadataType("other");
            mdl.setContent("NONE");
            service.setMetadataLink(mdl);
            service.setFees("NONE");
            service.setAccessConstraints("NONE");
            service.setMaintainer("http://jira.codehaus.org/secure/BrowseProject.jspa?id=10311");
            try {
                service.setOnlineResource(new URL("http://geoserver.org"));
            }
            catch (MalformedURLException e) {
                if (!LOGGER.isLoggable(Level.FINE)) break block2;
                LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
            }
        }
        dto.setService(service);
        return dto;
    }

    protected void loadCatalog(File catalogFile, File featureTypeDir, File styleDir, File coverageDir) throws ConfigurationException {
        Element catalogElem = null;
        try {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.config(new StringBuffer("Loading configuration file: ").append(catalogFile).toString());
            }
            Reader fr = XmlCharsetDetector.getCharsetAwareReader((InputStream)new FileInputStream(catalogFile));
            catalogElem = ReaderUtils.parse((Reader)fr);
            fr.close();
        }
        catch (FileNotFoundException e) {
            throw new ConfigurationException(catalogFile + " was not found", e);
        }
        catch (Exception e) {
            throw new ConfigurationException(catalogFile + " contents to not seem to be valid", e);
        }
        try {
            this.data.setNameSpaces(this.loadNameSpaces(ReaderUtils.getChildElement((Element)catalogElem, (String)"namespaces", (boolean)true)));
            this.setDefaultNS();
            try {
                Element formatElement = ReaderUtils.getChildElement((Element)catalogElem, (String)"formats", (boolean)true);
                this.data.setFormats(this.loadFormats(formatElement));
            }
            catch (Exception e) {
                LOGGER.warning("Your catalog.xml file is not up to date and is probably from an older version of GeoServer. This problem is now being fixed automatically.");
            }
            this.data.setDataStores(this.loadDataStores(ReaderUtils.getChildElement((Element)catalogElem, (String)"datastores", (boolean)true)));
            this.data.setStyles(this.loadStyles(ReaderUtils.getChildElement((Element)catalogElem, (String)"styles", (boolean)false), styleDir));
            this.data.setFeaturesTypes(this.loadFeatureTypes(featureTypeDir));
            this.data.setCoverages(this.loadCoverages(coverageDir));
        }
        catch (Exception e) {
            throw new ConfigurationException(e);
        }
    }

    protected void setDefaultNS() {
        for (NameSpaceInfoDTO ns : this.data.getNameSpaces().values()) {
            if (!ns.isDefault()) continue;
            this.data.setDefaultNameSpacePrefix(ns.getPrefix());
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer(new StringBuffer("set default namespace pre to ").append(ns.getPrefix()).toString());
            }
            return;
        }
    }

    protected Level getLoggingLevel(Element globalConfigElem) throws ConfigurationException {
        Level level = Logger.getLogger("org.vfny.geoserver").getLevel();
        Element levelElem = ReaderUtils.getChildElement((Element)globalConfigElem, (String)"loggingLevel");
        if (levelElem != null) {
            String levelName = levelElem.getFirstChild().getNodeValue();
            try {
                level = Level.parse(levelName);
            }
            catch (IllegalArgumentException ex) {
                if (LOGGER.isLoggable(Level.WARNING)) {
                    LOGGER.warning(new StringBuffer("illegal loggingLevel name: ").append(levelName).toString());
                }
            }
        } else if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.config("No loggingLevel found, using default logging.properties setting");
        }
        return level;
    }

    protected void loadGlobal(Element globalElem) throws ConfigurationException {
        try {
            String tileCache;
            String adminPassword;
            String schemaBaseUrl;
            Element elem;
            block38: {
                String logLocation;
                this.geoServer = new GeoServerDTO();
                if (LOGGER.isLoggable(Level.FINER)) {
                    LOGGER.finer("parsing global configuration parameters");
                }
                String log4jConfigFile = ReaderUtils.getChildText((Element)globalElem, (String)"log4jConfigFile", (boolean)false);
                this.geoServer.setLog4jConfigFile(log4jConfigFile);
                boolean suppressStdOutLogging = false;
                elem = null;
                elem = ReaderUtils.getChildElement((Element)globalElem, (String)"suppressStdOutLogging", (boolean)false);
                if (elem != null) {
                    suppressStdOutLogging = ReaderUtils.getBooleanAttribute((Element)elem, (String)"value", (boolean)false, (boolean)false);
                }
                if ((logLocation = ReaderUtils.getChildText((Element)globalElem, (String)"logLocation")) != null && "".equals(logLocation.trim())) {
                    logLocation = null;
                }
                this.geoServer.setSuppressStdOutLogging(suppressStdOutLogging);
                this.geoServer.setLogLocation(logLocation);
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine(new StringBuffer("logging config is ").append(log4jConfigFile).toString());
                }
                if (logLocation != null && LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine(new StringBuffer("logging to ").append(logLocation).toString());
                }
                double jaiMemoryCapacity = 0.0;
                elem = ReaderUtils.getChildElement((Element)globalElem, (String)"JaiMemoryCapacity", (boolean)false);
                if (elem != null) {
                    jaiMemoryCapacity = ReaderUtils.getDoubleAttribute((Element)elem, (String)"value", (boolean)false);
                }
                double jaiMemoryThreshold = 0.0;
                elem = ReaderUtils.getChildElement((Element)globalElem, (String)"JaiMemoryThreshold", (boolean)false);
                if (elem != null) {
                    jaiMemoryThreshold = ReaderUtils.getDoubleAttribute((Element)elem, (String)"value", (boolean)false);
                }
                int jaiTileThreads = 7;
                elem = ReaderUtils.getChildElement((Element)globalElem, (String)"JaiTileThreads", (boolean)false);
                if (elem != null) {
                    jaiTileThreads = ReaderUtils.getIntAttribute((Element)elem, (String)"value", (boolean)false, (int)7);
                }
                int jaiTilePriority = 5;
                elem = ReaderUtils.getChildElement((Element)globalElem, (String)"JaiTilePriority", (boolean)false);
                if (elem != null) {
                    jaiTilePriority = ReaderUtils.getIntAttribute((Element)elem, (String)"value", (boolean)false, (int)5);
                }
                Boolean jaiRecycling = Boolean.FALSE;
                elem = ReaderUtils.getChildElement((Element)globalElem, (String)"JaiRecycling", (boolean)false);
                if (elem != null) {
                    jaiRecycling = ReaderUtils.getBooleanAttribute((Element)elem, (String)"value", (boolean)false, (boolean)false);
                }
                Boolean imageIOCache = Boolean.FALSE;
                elem = ReaderUtils.getChildElement((Element)globalElem, (String)"ImageIOCache", (boolean)false);
                if (elem != null) {
                    imageIOCache = ReaderUtils.getBooleanAttribute((Element)elem, (String)"value", (boolean)false, (boolean)false);
                }
                Boolean jaiJPEGNative = Boolean.TRUE;
                elem = ReaderUtils.getChildElement((Element)globalElem, (String)"JaiJPEGNative", (boolean)false);
                if (elem != null) {
                    jaiJPEGNative = ReaderUtils.getBooleanAttribute((Element)elem, (String)"value", (boolean)false, (boolean)false);
                }
                Boolean jaiPNGNative = Boolean.TRUE;
                elem = ReaderUtils.getChildElement((Element)globalElem, (String)"JaiPNGNative", (boolean)false);
                if (elem != null) {
                    jaiPNGNative = ReaderUtils.getBooleanAttribute((Element)elem, (String)"value", (boolean)false, (boolean)false);
                }
                this.geoServer.setJaiMemoryCapacity(jaiMemoryCapacity);
                this.geoServer.setJaiMemoryThreshold(jaiMemoryThreshold);
                this.geoServer.setJaiTileThreads(jaiTileThreads);
                this.geoServer.setJaiTilePriority(jaiTilePriority);
                this.geoServer.setJaiRecycling(jaiRecycling);
                this.geoServer.setImageIOCache(imageIOCache);
                this.geoServer.setJaiJPEGNative(jaiJPEGNative);
                this.geoServer.setJaiPNGNative(jaiPNGNative);
                elem = ReaderUtils.getChildElement((Element)globalElem, (String)"ContactInformation");
                this.geoServer.setContact(this.loadContact(elem));
                elem = ReaderUtils.getChildElement((Element)globalElem, (String)"verbose", (boolean)false);
                if (elem != null) {
                    this.geoServer.setVerbose(ReaderUtils.getBooleanAttribute((Element)elem, (String)"value", (boolean)false, (boolean)true));
                }
                if ((elem = ReaderUtils.getChildElement((Element)globalElem, (String)"maxFeatures")) != null) {
                    this.geoServer.setMaxFeatures(ReaderUtils.getIntAttribute((Element)elem, (String)"value", (boolean)true, (int)this.geoServer.getMaxFeatures()));
                }
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine(new StringBuffer("maxFeatures is ").append(this.geoServer.getMaxFeatures()).toString());
                }
                if ((elem = ReaderUtils.getChildElement((Element)globalElem, (String)"numDecimals")) != null) {
                    this.geoServer.setNumDecimals(ReaderUtils.getIntAttribute((Element)elem, (String)"value", (boolean)true, (int)this.geoServer.getNumDecimals()));
                }
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine(new StringBuffer("numDecimals returning is ").append(this.geoServer.getNumDecimals()).toString());
                }
                if ((elem = ReaderUtils.getChildElement((Element)globalElem, (String)"charSet")) != null) {
                    String chSet = ReaderUtils.getAttribute((Element)elem, (String)"value", (boolean)true);
                    try {
                        Charset cs = Charset.forName(chSet);
                        this.geoServer.setCharSet(cs);
                        if (LOGGER.isLoggable(Level.FINER)) {
                            LOGGER.finer(new StringBuffer("charSet: ").append(cs.name()).toString());
                        }
                    }
                    catch (Exception ex) {
                        if (!LOGGER.isLoggable(Level.INFO)) break block38;
                        LOGGER.info(ex.getMessage());
                    }
                }
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine(new StringBuffer("charSet is ").append(this.geoServer.getCharSet()).toString());
            }
            if ((schemaBaseUrl = ReaderUtils.getChildText((Element)globalElem, (String)"SchemaBaseUrl")) != null) {
                this.geoServer.setSchemaBaseUrl(schemaBaseUrl);
            } else {
                this.geoServer.setSchemaBaseUrl(this.root.toString() + "/data/capabilities/");
            }
            String proxyBaseUrl = ReaderUtils.getChildText((Element)globalElem, (String)"ProxyBaseUrl");
            if (proxyBaseUrl != null) {
                this.geoServer.setProxyBaseUrl(proxyBaseUrl);
            } else {
                this.geoServer.setSchemaBaseUrl(null);
            }
            String adminUserName = ReaderUtils.getChildText((Element)globalElem, (String)"adminUserName");
            if (adminUserName != null) {
                this.geoServer.setAdminUserName(adminUserName);
            }
            if ((adminPassword = ReaderUtils.getChildText((Element)globalElem, (String)"adminPassword")) != null) {
                this.geoServer.setAdminPassword(adminPassword);
            }
            if ((elem = ReaderUtils.getChildElement((Element)globalElem, (String)"verboseExceptions", (boolean)false)) != null) {
                this.geoServer.setVerboseExceptions(ReaderUtils.getBooleanAttribute((Element)elem, (String)"value", (boolean)false, (boolean)true));
            }
            if ((tileCache = ReaderUtils.getChildText((Element)globalElem, (String)"tileCache", (boolean)false)) != null) {
                this.geoServer.setTileCache(tileCache);
            } else {
                this.geoServer.setTileCache(null);
            }
            String gsUpdateSequence = ReaderUtils.getChildText((Element)globalElem, (String)"updateSequence");
            if (gsUpdateSequence == null) {
                this.geoServer.setUpdateSequence(0);
            } else {
                try {
                    this.geoServer.setUpdateSequence(Integer.parseInt(gsUpdateSequence));
                }
                catch (NumberFormatException nfe) {
                    LOGGER.warning("Couldn't parse update sequence " + gsUpdateSequence + ".  Setting UpdateSequence to zero.");
                    this.geoServer.setUpdateSequence(0);
                }
            }
        }
        catch (Exception e) {
            throw new ConfigurationException(e);
        }
    }

    protected ContactDTO loadContact(Element contactInfoElement) throws ConfigurationException {
        ContactDTO c = new ContactDTO();
        if (contactInfoElement == null) {
            return c;
        }
        Element elem = ReaderUtils.getChildElement((Element)contactInfoElement, (String)"ContactPersonPrimary");
        if (elem != null) {
            c.setContactPerson(ReaderUtils.getChildText((Element)elem, (String)"ContactPerson"));
            c.setContactOrganization(ReaderUtils.getChildText((Element)elem, (String)"ContactOrganization"));
        }
        c.setContactPosition(ReaderUtils.getChildText((Element)contactInfoElement, (String)"ContactPosition"));
        elem = ReaderUtils.getChildElement((Element)contactInfoElement, (String)"ContactAddress");
        if (elem != null) {
            c.setAddressType(ReaderUtils.getChildText((Element)elem, (String)"AddressType"));
            c.setAddress(ReaderUtils.getChildText((Element)elem, (String)"Address"));
            c.setAddressCity(ReaderUtils.getChildText((Element)elem, (String)"City"));
            c.setAddressState(ReaderUtils.getChildText((Element)elem, (String)"StateOrProvince"));
            c.setAddressPostalCode(ReaderUtils.getChildText((Element)elem, (String)"PostCode"));
            c.setAddressCountry(ReaderUtils.getChildText((Element)elem, (String)"Country"));
        }
        c.setContactVoice(ReaderUtils.getChildText((Element)contactInfoElement, (String)"ContactVoiceTelephone"));
        c.setContactFacsimile(ReaderUtils.getChildText((Element)contactInfoElement, (String)"ContactFacsimileTelephone"));
        c.setContactEmail(ReaderUtils.getChildText((Element)contactInfoElement, (String)"ContactElectronicMailAddress"));
        c.setOnlineResource(ReaderUtils.getChildText((Element)contactInfoElement, (String)"ContactOnlineResource"));
        return c;
    }

    protected void loadWCS(Element wcsElement) throws ConfigurationException {
        this.wcs = new WCSDTO();
        this.wcs.setService(this.loadService(wcsElement));
    }

    protected void loadWFS(Element wfsElement) throws ConfigurationException {
        this.wfs = new WFSDTO();
        try {
            this.wfs.setFeatureBounding(ReaderUtils.getBooleanAttribute((Element)ReaderUtils.getChildElement((Element)wfsElement, (String)"featureBounding"), (String)"value", (boolean)false, (boolean)false));
            Element elem = ReaderUtils.getChildElement((Element)wfsElement, (String)"srsXmlStyle", (boolean)false);
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine(new StringBuffer("reading srsXmlStyle: ").append(elem).toString());
            }
            if (elem != null) {
                this.wfs.setSrsXmlStyle(ReaderUtils.getBooleanAttribute((Element)elem, (String)"value", (boolean)false, (boolean)true));
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine(new StringBuffer("set srsXmlStyle to ").append(ReaderUtils.getBooleanAttribute((Element)elem, (String)"value", (boolean)false, (boolean)true)).toString());
                }
            }
            String serviceLevelValue = ReaderUtils.getChildText((Element)wfsElement, (String)"serviceLevel");
            int serviceLevel = 31;
            if (serviceLevelValue != null && !serviceLevelValue.equals("")) {
                if (LOGGER.isLoggable(Level.FINER)) {
                    LOGGER.finer(new StringBuffer("reading serviceLevel: ").append(serviceLevelValue).toString());
                }
                if (serviceLevelValue.equalsIgnoreCase("basic")) {
                    serviceLevel = 1;
                } else if (serviceLevelValue.equalsIgnoreCase("complete")) {
                    serviceLevel = 31;
                } else if (serviceLevelValue.equalsIgnoreCase("transactional")) {
                    serviceLevel = 15;
                } else {
                    try {
                        serviceLevel = Integer.parseInt(serviceLevelValue);
                    }
                    catch (NumberFormatException nfe) {
                        String mesg = "Could not parse serviceLevel.  It should be one of Basic, Complete, or Transactional or else an integer value";
                        throw new ConfigurationException(mesg, nfe);
                    }
                }
            } else {
                serviceLevel = ReaderUtils.getIntAttribute((Element)ReaderUtils.getChildElement((Element)wfsElement, (String)"serviceLevel"), (String)"value", (boolean)false, (int)31);
            }
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer(new StringBuffer("setting service level to ").append(serviceLevel).toString());
            }
            this.wfs.setServiceLevel(serviceLevel);
            Element e = ReaderUtils.getChildElement((Element)wfsElement, (String)"citeConformanceHacks");
            if (e != null) {
                String text = ReaderUtils.getChildText((Element)wfsElement, (String)"citeConformanceHacks");
                boolean citeConformanceHacks = Boolean.valueOf(text);
                this.wfs.setCiteConformanceHacks(citeConformanceHacks);
                if (LOGGER.isLoggable(Level.FINER)) {
                    LOGGER.finer(new StringBuffer("setting citeConformanceHacks to ").append(citeConformanceHacks).toString());
                }
            }
        }
        catch (Exception e) {
            throw new ConfigurationException(e);
        }
        ServiceDTO s = this.loadService(wfsElement);
        this.wfs.setService(s);
    }

    protected void loadWMS(Element wmsElement) throws ConfigurationException {
        this.wms = new WMSDTO();
        this.wms.setService(this.loadService(wmsElement));
        String spaceSeparatedListOfCrsCodes = ReaderUtils.getChildText((Element)wmsElement, (String)"capabilitiesCrsList");
        if (spaceSeparatedListOfCrsCodes != null) {
            String[] codes = spaceSeparatedListOfCrsCodes.split(",");
            HashSet<String> capabilitiesCrsCodes = new HashSet<String>();
            for (int i = 0; i < codes.length; ++i) {
                String code = codes[i].toUpperCase().trim();
                try {
                    CRS.decode((String)code);
                    capabilitiesCrsCodes.add(code);
                    continue;
                }
                catch (Exception e) {
                    LOGGER.warning("Invalid CRS code found in capabilitiesCrsList: '" + code + "' is not a known CRS identifier");
                }
            }
            this.wms.setCapabilitiesCrs(capabilitiesCrsCodes);
        }
        this.wms.setSvgRenderer(ReaderUtils.getChildText((Element)wmsElement, (String)"svgRenderer"));
        this.wms.setSvgAntiAlias(!"false".equals(ReaderUtils.getChildText((Element)wmsElement, (String)"svgAntiAlias")));
        if (ReaderUtils.getChildText((Element)wmsElement, (String)"globalWatermarking") != null) {
            this.wms.setGlobalWatermarking(!"false".equals(ReaderUtils.getChildText((Element)wmsElement, (String)"globalWatermarking")));
        }
        this.wms.setGlobalWatermarkingURL(ReaderUtils.getChildText((Element)wmsElement, (String)"globalWatermarkingURL"));
        if (ReaderUtils.getChildText((Element)wmsElement, (String)"globalWatermarkingTransparency") != null) {
            this.wms.setWatermarkTransparency(Integer.parseInt(ReaderUtils.getChildText((Element)wmsElement, (String)"globalWatermarkingTransparency")));
        }
        if (ReaderUtils.getChildText((Element)wmsElement, (String)"globalWatermarkingPosition") != null) {
            this.wms.setWatermarkPosition(Integer.parseInt(ReaderUtils.getChildText((Element)wmsElement, (String)"globalWatermarkingPosition")));
        } else {
            this.wms.setWatermarkPosition(8);
        }
        try {
            this.wms.setAllowInterpolation(ReaderUtils.getChildText((Element)wmsElement, (String)"allowInterpolation", (boolean)true));
        }
        catch (Exception e) {
            this.wms.setAllowInterpolation("Nearest");
        }
        this.loadBaseMapLayers(wmsElement);
    }

    private void loadBaseMapLayers(Element wmsElement) {
        HashMap<String, String> layerMap = new HashMap<String, String>();
        HashMap<String, String> styleMap = new HashMap<String, String>();
        HashMap<String, GeneralEnvelope> envelopeMap = new HashMap<String, GeneralEnvelope>();
        Element groupBase = ReaderUtils.getChildElement((Element)wmsElement, (String)"BaseMapGroups");
        if (groupBase == null) {
            LOGGER.config("No baseMap groups defined yet");
            return;
        }
        Element[] groups = ReaderUtils.getChildElements((Element)groupBase, (String)"BaseMapGroup");
        for (int i = 0; i < groups.length; ++i) {
            Element group = groups[i];
            try {
                String title = ReaderUtils.getAttribute((Element)group, (String)"baseMapTitle", (boolean)true);
                String layers = ReaderUtils.getChildText((Element)group, (String)"baseMapLayers");
                String styles = ReaderUtils.getChildText((Element)group, (String)"baseMapStyles");
                Element envelope = ReaderUtils.getChildElement((Element)group, (String)"baseMapEnvelope");
                String srsName = ReaderUtils.getAttribute((Element)envelope, (String)"srsName", (boolean)true);
                layerMap.put(title, layers);
                styleMap.put(title, styles);
                envelopeMap.put(title, this.loadEnvelope(envelope, CRS.decode((String)srsName)));
                continue;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        this.wms.setBaseMapLayers(layerMap);
        this.wms.setBaseMapStyles(styleMap);
        this.wms.setBaseMapEnvelopes(envelopeMap);
    }

    protected ServiceDTO loadService(Element serviceRoot) throws ConfigurationException {
        ServiceDTO s = new ServiceDTO();
        try {
            String name = ReaderUtils.getChildText((Element)serviceRoot, (String)"name", (boolean)true);
            s.setName(name);
            s.setTitle(ReaderUtils.getChildText((Element)serviceRoot, (String)"title", (boolean)false));
            s.setAbstract(ReaderUtils.getChildText((Element)serviceRoot, (String)"abstract"));
            s.setKeywords(ReaderUtils.getKeyWords((Element)ReaderUtils.getChildElement((Element)serviceRoot, (String)"keywords")));
            s.setMetadataLink(XMLConfigReader.getMetaDataLink(ReaderUtils.getChildElement((Element)serviceRoot, (String)"metadataLink"), this.catalog));
            s.setFees(ReaderUtils.getChildText((Element)serviceRoot, (String)"fees"));
            s.setAccessConstraints(ReaderUtils.getChildText((Element)serviceRoot, (String)"accessConstraints"));
            s.setMaintainer(ReaderUtils.getChildText((Element)serviceRoot, (String)"maintainer"));
            s.setEnabled(ReaderUtils.getBooleanAttribute((Element)serviceRoot, (String)"enabled", (boolean)false, (boolean)true));
            s.setStrategy(ReaderUtils.getChildText((Element)serviceRoot, (String)"serviceStrategy"));
            s.setPartialBufferSize(ReaderUtils.getIntAttribute((Element)serviceRoot, (String)"partialBufferSize", (boolean)false, (int)0));
            String url = ReaderUtils.getChildText((Element)serviceRoot, (String)"onlineResource", (boolean)true);
            try {
                s.setOnlineResource(new URL(url));
            }
            catch (MalformedURLException e) {
                LOGGER.severe("Invalid online resource URL for service " + name + ": " + url + ". Defaulting to geoserver home.");
                s.setOnlineResource(new URL("http://www.geoserver.org"));
            }
        }
        catch (Exception e) {
            throw new ConfigurationException(e);
        }
        return s;
    }

    protected Map loadNameSpaces(Element nsRoot) throws ConfigurationException {
        NodeList nsList = nsRoot.getElementsByTagName("namespace");
        int nsCount = nsList.getLength();
        HashMap<String, NameSpaceInfoDTO> nameSpaces = new HashMap<String, NameSpaceInfoDTO>(nsCount);
        try {
            for (int i = 0; i < nsCount; ++i) {
                Element elem = (Element)nsList.item(i);
                NameSpaceInfoDTO ns = new NameSpaceInfoDTO();
                ns.setUri(ReaderUtils.getAttribute((Element)elem, (String)"uri", (boolean)true));
                ns.setPrefix(ReaderUtils.getAttribute((Element)elem, (String)"prefix", (boolean)true));
                ns.setDefault(ReaderUtils.getBooleanAttribute((Element)elem, (String)"default", (boolean)false, (boolean)false) || nsCount == 1);
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.config(new StringBuffer("added namespace ").append(ns).toString());
                }
                nameSpaces.put(ns.getPrefix(), ns);
            }
        }
        catch (Exception e) {
            throw new ConfigurationException(e);
        }
        return nameSpaces;
    }

    protected Map loadStyles(Element stylesElem, File baseDir) throws ConfigurationException {
        HashMap<String, StyleDTO> styles = new HashMap<String, StyleDTO>();
        NodeList stylesList = null;
        if (stylesElem != null) {
            stylesList = stylesElem.getElementsByTagName("style");
        }
        if (stylesList == null || stylesList.getLength() == 0) {
            StyleDTO s = new StyleDTO();
            s.setId("normal");
            s.setFilename(new File(baseDir, "normal.sld"));
            s.setDefault(true);
            styles.put("normal", s);
        }
        int styleCount = stylesList.getLength();
        for (int i = 0; i < styleCount; ++i) {
            try {
                Element styleElem = (Element)stylesList.item(i);
                StyleDTO s = new StyleDTO();
                s.setId(ReaderUtils.getAttribute((Element)styleElem, (String)"id", (boolean)true));
                s.setFilename(new File(baseDir, ReaderUtils.getAttribute((Element)styleElem, (String)"filename", (boolean)true)));
                s.setDefault(ReaderUtils.getBooleanAttribute((Element)styleElem, (String)"default", (boolean)false, (boolean)false));
                styles.put(s.getId(), s);
                if (!LOGGER.isLoggable(Level.FINE)) continue;
                LOGGER.config(new StringBuffer("Loaded style ").append(s.getId()).toString());
                continue;
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Ignored misconfigured style", e);
            }
        }
        return styles;
    }

    protected Map loadFormats(Element fmRoot) throws ConfigurationException {
        HashMap<String, CoverageStoreInfoDTO> formats = new HashMap<String, CoverageStoreInfoDTO>();
        if (fmRoot == null) {
            return formats;
        }
        NodeList fmElements = fmRoot.getElementsByTagName("format");
        int fmCnt = fmElements.getLength();
        for (int i = 0; i < fmCnt; ++i) {
            Element fmElem = (Element)fmElements.item(i);
            try {
                CoverageStoreInfoDTO fmConfig = this.loadFormat(fmElem);
                if (formats.containsKey(fmConfig.getId())) {
                    LOGGER.warning("Ignored duplicated format " + this.data.getNameSpaces().get(fmConfig.getNameSpaceId()));
                    continue;
                }
                formats.put(fmConfig.getId(), fmConfig);
                continue;
            }
            catch (ConfigurationException e) {
                LOGGER.log(Level.WARNING, "Ignored a misconfigured coverage.", e);
            }
        }
        return formats;
    }

    protected CoverageStoreInfoDTO loadFormat(Element fmElem) throws ConfigurationException {
        CoverageStoreInfoDTO fm = new CoverageStoreInfoDTO();
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer("creating a new FormatDTO configuration");
        }
        try {
            fm.setId(ReaderUtils.getAttribute((Element)fmElem, (String)"id", (boolean)true));
            String namespacePrefix = ReaderUtils.getAttribute((Element)fmElem, (String)"namespace", (boolean)true);
            if (this.data.getNameSpaces().containsKey(namespacePrefix)) {
                fm.setNameSpaceId(namespacePrefix);
            } else {
                LOGGER.warning("Could not find namespace " + namespacePrefix + " defaulting to " + this.data.getDefaultNameSpacePrefix());
                fm.setNameSpaceId(this.data.getDefaultNameSpacePrefix());
            }
            fm.setType(ReaderUtils.getChildText((Element)fmElem, (String)"type", (boolean)true));
            fm.setUrl(ReaderUtils.getChildText((Element)fmElem, (String)"url", (boolean)false));
            fm.setEnabled(ReaderUtils.getBooleanAttribute((Element)fmElem, (String)"enabled", (boolean)false, (boolean)true));
            fm.setTitle(ReaderUtils.getChildText((Element)fmElem, (String)"title", (boolean)false));
            fm.setAbstract(ReaderUtils.getChildText((Element)fmElem, (String)"description", (boolean)false));
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer(new StringBuffer("loading parameters for FormatDTO ").append(fm.getId()).toString());
            }
        }
        catch (Exception e) {
            throw new ConfigurationException(e);
        }
        return fm;
    }

    protected Map loadDataStores(Element dsRoot) throws ConfigurationException {
        HashMap<String, DataStoreInfoDTO> dataStores = new HashMap<String, DataStoreInfoDTO>();
        NodeList dsElements = dsRoot.getElementsByTagName("datastore");
        int dsCnt = dsElements.getLength();
        DataStoreInfoDTO dsConfig = null;
        for (int i = 0; i < dsCnt; ++i) {
            Element dsElem = (Element)dsElements.item(i);
            try {
                dsConfig = this.loadDataStore(dsElem);
                if (dataStores.containsKey(dsConfig.getId())) {
                    LOGGER.warning("Ignored duplicated datastore with id " + dsConfig.getId());
                    continue;
                }
                dataStores.put(dsConfig.getId(), dsConfig);
                continue;
            }
            catch (ConfigurationException e) {
                LOGGER.log(Level.WARNING, "Ignored a misconfigured datastore.", e);
            }
        }
        return dataStores;
    }

    protected DataStoreInfoDTO loadDataStore(Element dsElem) throws ConfigurationException {
        DataStoreInfoDTO ds = new DataStoreInfoDTO();
        try {
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer("creating a new DataStoreDTO configuration");
            }
            ds.setId(ReaderUtils.getAttribute((Element)dsElem, (String)"id", (boolean)true));
            String namespacePrefix = ReaderUtils.getAttribute((Element)dsElem, (String)"namespace", (boolean)true);
            if (this.data.getNameSpaces().containsKey(namespacePrefix)) {
                ds.setNameSpaceId(namespacePrefix);
            } else {
                LOGGER.warning("Could not find namespace " + namespacePrefix + " defaulting to " + this.data.getDefaultNameSpacePrefix());
                ds.setNameSpaceId(this.data.getDefaultNameSpacePrefix());
            }
            ds.setEnabled(ReaderUtils.getBooleanAttribute((Element)dsElem, (String)"enabled", (boolean)false, (boolean)true));
            ds.setTitle(ReaderUtils.getChildText((Element)dsElem, (String)"title", (boolean)false));
            ds.setAbstract(ReaderUtils.getChildText((Element)dsElem, (String)"description", (boolean)false));
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer(new StringBuffer("loading connection parameters for DataStoreDTO ").append(ds.getNameSpaceId()).toString());
            }
            ds.setConnectionParams(this.loadConnectionParams(ReaderUtils.getChildElement((Element)dsElem, (String)"connectionParams", (boolean)true)));
        }
        catch (Exception e) {
            throw new ConfigurationException(e);
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.config(new StringBuffer("Loaded datastore ").append(ds.getId()).toString());
        }
        return ds;
    }

    protected Map loadConnectionParams(Element connElem) throws ConfigurationException {
        HashMap<String, String> connectionParams = new HashMap<String, String>();
        if (connElem == null) {
            return connectionParams;
        }
        NodeList paramElems = connElem.getElementsByTagName("parameter");
        int pCount = paramElems.getLength();
        try {
            for (int i = 0; i < pCount; ++i) {
                Element param = (Element)paramElems.item(i);
                String paramKey = ReaderUtils.getAttribute((Element)param, (String)"name", (boolean)true);
                String paramValue = ReaderUtils.getAttribute((Element)param, (String)"value", (boolean)false);
                if ("shapefile url".equals(paramKey)) {
                    paramKey = "url";
                }
                connectionParams.put(paramKey, paramValue);
                if (!LOGGER.isLoggable(Level.FINER)) continue;
                LOGGER.finer(new StringBuffer("added parameter ").append(paramKey).append(": '").append(paramValue.replaceAll("'", "\"")).append("'").toString());
            }
        }
        catch (Exception e) {
            throw new ConfigurationException(e);
        }
        return connectionParams;
    }

    protected Map loadFeatureTypes(File featureTypeRoot) throws ConfigurationException {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest(new StringBuffer("examining: ").append(featureTypeRoot.getAbsolutePath()).toString());
            LOGGER.finest(new StringBuffer("is dir: ").append(featureTypeRoot.isDirectory()).toString());
        }
        if (featureTypeRoot == null) {
            return Collections.EMPTY_MAP;
        }
        if (!featureTypeRoot.isDirectory()) {
            throw new IllegalArgumentException("featureTypeRoot must be a directoy");
        }
        File[] directories = featureTypeRoot.listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                return pathname.isDirectory();
            }
        });
        HashMap<String, FeatureTypeInfoDTO> map = new HashMap<String, FeatureTypeInfoDTO>();
        int n = directories.length;
        for (int i = 0; i < n; ++i) {
            File info = new File(directories[i], "info.xml");
            if (!info.exists() || !info.isFile()) continue;
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer(new StringBuffer("Info dir:").append(info).toString());
            }
            try {
                FeatureTypeInfoDTO dto = this.loadFeature(info);
                String ftName = null;
                ftName = URLDecoder.decode(dto.getKey(), "UTF-8");
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.config("Decoding file name: " + ftName);
                }
                map.put(ftName, dto);
                continue;
            }
            catch (UnsupportedEncodingException e) {
                LOGGER.severe("unable to load featuretype from file " + info + ".  Skipping that featuretype.  Error was: " + e);
                continue;
            }
            catch (ConfigurationException ce) {
                LOGGER.severe("unable to load featuretype from file " + info + ".  Skipping that featuretype.  Error was: " + ce);
            }
        }
        return map;
    }

    protected FeatureTypeInfoDTO loadFeature(File infoFile) throws ConfigurationException {
        if (!infoFile.exists()) {
            throw new IllegalArgumentException("Info File not found:" + infoFile);
        }
        if (!infoFile.isFile()) {
            throw new IllegalArgumentException("Info file is the wrong type:" + infoFile);
        }
        if (!XMLConfigReader.isInfoFile(infoFile)) {
            throw new IllegalArgumentException("Info File not valid:" + infoFile);
        }
        Element featureElem = null;
        try {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.config(new StringBuffer("Loading configuration file: ").append(infoFile).toString());
            }
            Reader reader = XmlCharsetDetector.getCharsetAwareReader((InputStream)new FileInputStream(infoFile));
            featureElem = ReaderUtils.parse((Reader)reader);
            reader.close();
        }
        catch (FileNotFoundException fileNotFound) {
            throw new ConfigurationException("Could not read info file:" + infoFile, fileNotFound);
        }
        catch (Exception erk) {
            throw new ConfigurationException("Could not parse info file:" + infoFile, erk);
        }
        FeatureTypeInfoDTO dto = this.loadFeaturePt2(featureElem);
        File parentDir = infoFile.getParentFile();
        dto.setDirName(parentDir.getName());
        File schemaFile = new File(parentDir, "schema.xml");
        if (schemaFile.exists() && schemaFile.isFile()) {
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest(new StringBuffer("process schema file ").append(infoFile).toString());
            }
            try {
                this.loadSchema(schemaFile, dto);
            }
            catch (Exception badDog) {
                badDog.printStackTrace();
                List attributeList = Collections.EMPTY_LIST;
            }
        } else {
            dto.setSchemaAttributes(Collections.EMPTY_LIST);
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.config(new StringBuffer("added featureType ").append(dto.getName()).toString());
        }
        return dto;
    }

    protected FeatureTypeInfoDTO loadFeaturePt2(Element fTypeRoot) throws ConfigurationException {
        FeatureTypeInfoDTO ft = new FeatureTypeInfoDTO();
        try {
            Element legendURL;
            Element regionateInfo;
            Element cacheInfo;
            Element urls;
            ft.setName(ReaderUtils.getChildText((Element)fTypeRoot, (String)"name", (boolean)true));
            ft.setAlias(ReaderUtils.getChildText((Element)fTypeRoot, (String)"alias", (boolean)false));
            ft.setTitle(ReaderUtils.getChildText((Element)fTypeRoot, (String)"title", (boolean)true));
            ft.setAbstract(ReaderUtils.getChildText((Element)fTypeRoot, (String)"abstract"));
            ft.setWmsPath(ReaderUtils.getChildText((Element)fTypeRoot, (String)"wmspath"));
            String keywords = ReaderUtils.getChildText((Element)fTypeRoot, (String)"keywords");
            if (keywords != null) {
                LinkedList<String> l = new LinkedList<String>();
                String[] ss = keywords.split(",");
                for (int i = 0; i < ss.length; ++i) {
                    l.add(ss[i].trim());
                }
                ft.setKeywords(l);
            }
            if ((urls = ReaderUtils.getChildElement((Element)fTypeRoot, (String)"metadataLinks")) != null) {
                Element[] childs = ReaderUtils.getChildElements((Element)urls, (String)"metadataLink");
                LinkedList<MetaDataLink> l = new LinkedList<MetaDataLink>();
                for (int i = 0; i < childs.length; ++i) {
                    l.add(XMLConfigReader.getMetaDataLink(childs[i], this.catalog));
                }
                ft.setMetadataLinks(l);
            }
            ft.setDataStoreId(ReaderUtils.getAttribute((Element)fTypeRoot, (String)"datastore", (boolean)true));
            ft.setSRS(Integer.parseInt(ReaderUtils.getChildText((Element)fTypeRoot, (String)"SRS", (boolean)true)));
            try {
                String srsHandling = ReaderUtils.getChildText((Element)fTypeRoot, (String)"SRSHandling", (boolean)false);
                ft.setSRSHandling(srsHandling != null ? Integer.parseInt(srsHandling) : FeatureTypeInfo.FORCE);
            }
            catch (Exception e) {
                ft.setSRSHandling(FeatureTypeInfo.FORCE);
            }
            Element tmp = ReaderUtils.getChildElement((Element)fTypeRoot, (String)"styles");
            if (tmp != null) {
                ft.setDefaultStyle(ReaderUtils.getAttribute((Element)tmp, (String)"default", (boolean)false));
                NodeList childrens = tmp.getChildNodes();
                int numChildNodes = childrens.getLength();
                for (int n = 0; n < numChildNodes; ++n) {
                    Node child = childrens.item(n);
                    if (child.getNodeType() != 1 || !child.getNodeName().equals("style")) continue;
                    ft.addStyle(ReaderUtils.getElementText((Element)((Element)child)));
                }
            }
            if ((cacheInfo = ReaderUtils.getChildElement((Element)fTypeRoot, (String)"cacheinfo")) != null) {
                ft.setCacheMaxAge(ReaderUtils.getAttribute((Element)cacheInfo, (String)"maxage", (boolean)false));
                ft.setCachingEnabled(new Boolean(ReaderUtils.getAttribute((Element)cacheInfo, (String)"enabled", (boolean)true)));
            }
            Element searchInfo = ReaderUtils.getChildElement((Element)fTypeRoot, (String)"searchable");
            ft.setIndexingEnabled(false);
            if (searchInfo != null) {
                ft.setIndexingEnabled(new Boolean(ReaderUtils.getAttribute((Element)searchInfo, (String)"enabled", (boolean)true)));
            }
            if ((regionateInfo = ReaderUtils.getChildElement((Element)fTypeRoot, (String)"regionateAttribute")) != null) {
                ft.setRegionateAttribute(ReaderUtils.getAttribute((Element)regionateInfo, (String)"value", (boolean)false));
            }
            if ((legendURL = ReaderUtils.getChildElement((Element)fTypeRoot, (String)"LegendURL")) != null) {
                LegendURLDTO legend = new LegendURLDTO();
                legend.setWidth(Integer.parseInt(ReaderUtils.getAttribute((Element)legendURL, (String)"width", (boolean)true)));
                legend.setHeight(Integer.parseInt(ReaderUtils.getAttribute((Element)legendURL, (String)"height", (boolean)true)));
                legend.setFormat(ReaderUtils.getChildText((Element)legendURL, (String)"Format", (boolean)true));
                legend.setOnlineResource(ReaderUtils.getAttribute((Element)ReaderUtils.getChildElement((Element)legendURL, (String)"OnlineResource", (boolean)true), (String)"xlink:href", (boolean)true));
                ft.setLegendURL(legend);
            }
            Envelope latLonBBox = this.loadBBox(ReaderUtils.getChildElement((Element)fTypeRoot, (String)"latLonBoundingBox"));
            ft.setLatLongBBox(latLonBBox);
            Envelope nativeBBox = this.loadBBox(ReaderUtils.getChildElement((Element)fTypeRoot, (String)"nativeBBox"));
            ft.setNativeBBox(nativeBBox);
            Element numDecimalsElem = ReaderUtils.getChildElement((Element)fTypeRoot, (String)"numDecimals", (boolean)false);
            if (numDecimalsElem != null) {
                ft.setNumDecimals(ReaderUtils.getIntAttribute((Element)numDecimalsElem, (String)"value", (boolean)false, (int)8));
            }
            ft.setDefinitionQuery(this.loadDefinitionQuery(fTypeRoot));
            String maxFeaturesText = ReaderUtils.getChildText((Element)fTypeRoot, (String)"maxFeatures", (boolean)false);
            try {
                ft.setMaxFeatures(Integer.parseInt(maxFeaturesText));
            }
            catch (Exception e) {
                ft.setMaxFeatures(0);
            }
        }
        catch (Exception e) {
            throw new ConfigurationException(e);
        }
        return ft;
    }

    protected Map<String, CoverageInfoDTO> loadCoverages(File coverageRoot) throws ConfigurationException {
        if (LOGGER.isLoggable(Level.FINEST) && coverageRoot != null) {
            LOGGER.finest(new StringBuffer("examining: ").append(coverageRoot.getAbsolutePath()).toString());
            LOGGER.finest(new StringBuffer("is dir: ").append(coverageRoot.isDirectory()).toString());
        }
        if (coverageRoot == null) {
            return Collections.emptyMap();
        }
        if (!coverageRoot.isDirectory()) {
            throw new IllegalArgumentException("coverageRoot must be a directoy");
        }
        File[] directories = coverageRoot.listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                return pathname.isDirectory();
            }
        });
        HashMap<String, CoverageInfoDTO> map = new HashMap<String, CoverageInfoDTO>();
        int n = directories.length;
        for (int i = 0; i < n; ++i) {
            File info = new File(directories[i], "info.xml");
            if (!info.exists() || !info.isFile()) continue;
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer(new StringBuffer("Info dir:").append(info).toString());
            }
            try {
                CoverageInfoDTO dto = this.loadCoverage(info);
                if (dto != null) {
                    map.put(dto.getKey(), dto);
                    continue;
                }
                LOGGER.warning("Skipped misconfigured coverage " + info.getPath());
                continue;
            }
            catch (ConfigurationException e) {
                LOGGER.log(Level.WARNING, "Skipped misconfigured coverage " + info.getPath(), e);
            }
        }
        return map;
    }

    protected CoverageInfoDTO loadCoverage(File infoFile) throws ConfigurationException {
        if (!infoFile.exists()) {
            throw new IllegalArgumentException("Info File not found:" + infoFile);
        }
        if (!infoFile.isFile()) {
            throw new IllegalArgumentException("Info file is the wrong type:" + infoFile);
        }
        if (!XMLConfigReader.isInfoFile(infoFile)) {
            throw new IllegalArgumentException("Info File not valid:" + infoFile);
        }
        Element coverageElem = null;
        try {
            Reader reader = XmlCharsetDetector.getCharsetAwareReader((InputStream)new FileInputStream(infoFile));
            coverageElem = ReaderUtils.parse((Reader)reader);
            reader.close();
        }
        catch (FileNotFoundException fileNotFound) {
            throw new ConfigurationException("Could not read info file:" + infoFile, fileNotFound);
        }
        catch (Exception erk) {
            throw new ConfigurationException("Could not parse info file:" + infoFile, erk);
        }
        CoverageInfoDTO dto = this.loadCoverageDTOFromXML(coverageElem);
        File parentDir = infoFile.getParentFile();
        dto.setDirName(parentDir.getName());
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer(new StringBuffer("added coverageType ").append(dto.getName()).toString());
        }
        return dto;
    }

    protected CoverageInfoDTO loadCoverageDTOFromXML(Element coverageRoot) throws ConfigurationException {
        CoverageInfoDTO cv = new CoverageInfoDTO();
        try {
            String responseCRSs;
            CoordinateReferenceSystem crs;
            cv.setFormatId(ReaderUtils.getAttribute((Element)coverageRoot, (String)"format", (boolean)true));
            cv.setName(ReaderUtils.getChildText((Element)coverageRoot, (String)"name", (boolean)true));
            cv.setWmsPath(ReaderUtils.getChildText((Element)coverageRoot, (String)"wmspath"));
            cv.setLabel(ReaderUtils.getChildText((Element)coverageRoot, (String)"label", (boolean)true));
            cv.setDescription(ReaderUtils.getChildText((Element)coverageRoot, (String)"description"));
            String keywords = ReaderUtils.getChildText((Element)coverageRoot, (String)"keywords");
            List list = ReaderUtils.stringToList((String)keywords, (String)",");
            if (list != null && list.size() > 0) {
                cv.setKeywords(list);
            }
            cv.setMetadataLink(this.loadMetaDataLink(ReaderUtils.getChildElement((Element)coverageRoot, (String)"metadataLink")));
            Element tmp = ReaderUtils.getChildElement((Element)coverageRoot, (String)"styles");
            if (tmp != null) {
                cv.setDefaultStyle(ReaderUtils.getAttribute((Element)tmp, (String)"default", (boolean)false));
                NodeList childrens = tmp.getChildNodes();
                int numChildNodes = childrens.getLength();
                for (int n = 0; n < numChildNodes; ++n) {
                    Node child = childrens.item(n);
                    if (child.getNodeType() != 1 || !child.getNodeName().equals("style")) continue;
                    cv.addStyle(ReaderUtils.getElementText((Element)((Element)child)));
                }
            }
            Element envelope = ReaderUtils.getChildElement((Element)coverageRoot, (String)"envelope");
            cv.setUserDefinedCrsIdentifier(ReaderUtils.getAttribute((Element)envelope, (String)"srsName", (boolean)true));
            try {
                crs = CRS.parseWKT((String)ReaderUtils.getAttribute((Element)envelope, (String)"crs", (boolean)false).replaceAll("'", "\""));
            }
            catch (FactoryException e) {
                throw new ConfigurationException(e);
            }
            catch (ConfigurationException e) {
                throw new ConfigurationException(e);
            }
            cv.setNativeCrsWKT(crs.toWKT());
            GeneralEnvelope gcEnvelope = this.loadEnvelope(envelope, crs);
            cv.setEnvelope(gcEnvelope);
            try {
                cv.setLonLatWGS84Envelope(CoverageStoreUtils.getWGS84LonLatEnvelope((GeneralEnvelope)gcEnvelope));
            }
            catch (MismatchedDimensionException e) {
                throw new ConfigurationException(e);
            }
            catch (IndexOutOfBoundsException e) {
                throw new ConfigurationException(e);
            }
            catch (NoSuchAuthorityCodeException e) {
                throw new ConfigurationException(e);
            }
            catch (FactoryException e) {
                throw new ConfigurationException(e);
            }
            catch (TransformException e) {
                throw new ConfigurationException(e);
            }
            Element grid = ReaderUtils.getChildElement((Element)coverageRoot, (String)"grid");
            cv.setGrid(this.loadGrid(grid, gcEnvelope, crs));
            cv.setDimensionNames(this.loadDimensionNames(grid));
            NodeList dims = coverageRoot.getElementsByTagName("CoverageDimension");
            cv.setDimensions(this.loadDimensions(dims));
            Element supportedCRSs = ReaderUtils.getChildElement((Element)coverageRoot, (String)"supportedCRSs");
            String requestCRSs = ReaderUtils.getChildText((Element)supportedCRSs, (String)"requestCRSs");
            list = ReaderUtils.stringToList((String)requestCRSs, (String)",");
            if (list != null && list.size() > 0) {
                cv.setRequestCRSs(list);
            }
            if ((list = ReaderUtils.stringToList((String)(responseCRSs = ReaderUtils.getChildText((Element)supportedCRSs, (String)"responseCRSs")), (String)",")) != null && list.size() > 0) {
                cv.setResponseCRSs(list);
            }
            Element supportedFormats = ReaderUtils.getChildElement((Element)coverageRoot, (String)"supportedFormats");
            cv.setNativeFormat(ReaderUtils.getAttribute((Element)supportedFormats, (String)"nativeFormat", (boolean)true));
            String formats = ReaderUtils.getChildText((Element)supportedFormats, (String)"formats");
            list = ReaderUtils.stringToList((String)formats, (String)",");
            if (list != null && list.size() > 0) {
                cv.setSupportedFormats(list);
            }
            Element supportedInterpolations = ReaderUtils.getChildElement((Element)coverageRoot, (String)"supportedInterpolations");
            cv.setDefaultInterpolationMethod(ReaderUtils.getAttribute((Element)supportedInterpolations, (String)"default", (boolean)true));
            String interpolations = ReaderUtils.getChildText((Element)supportedInterpolations, (String)"interpolationMethods");
            list = ReaderUtils.stringToList((String)interpolations, (String)",");
            if (list != null && list.size() > 0) {
                cv.setInterpolationMethods(list);
            }
            cv.setParameters(this.loadConnectionParams(ReaderUtils.getChildElement((Element)coverageRoot, (String)"parameters", (boolean)false)));
        }
        catch (Exception e) {
            throw new ConfigurationException(e);
        }
        return cv;
    }

    protected GeneralEnvelope loadEnvelope(Element envelopeElem, CoordinateReferenceSystem crs) throws ConfigurationException {
        if (envelopeElem == null) {
            return new GeneralEnvelope(crs);
        }
        NodeList positions = envelopeElem.getElementsByTagName("pos");
        int numCoordinates = positions.getLength();
        Coordinate[] coords = new Coordinate[numCoordinates];
        for (int i = 0; i < numCoordinates; ++i) {
            String values = ReaderUtils.getElementText((Element)((Element)positions.item(i)));
            if (values == null) continue;
            String[] ss = values.split(" ");
            int length = ss.length;
            double[] dd = new double[length];
            for (int j = 0; j < length; ++j) {
                dd[j] = Double.parseDouble(ss[j].trim());
            }
            coords[i] = new Coordinate(dd[0], dd[1]);
        }
        GeneralEnvelope envelope = new GeneralEnvelope(new double[]{coords[0].x, coords[0].y}, new double[]{coords[1].x, coords[1].y});
        envelope.setCoordinateReferenceSystem(crs);
        return envelope;
    }

    protected GridGeometry loadGrid(Element gridElem, GeneralEnvelope envelope, CoordinateReferenceSystem crs) throws ConfigurationException, FactoryException {
        int j;
        String[] ss;
        String values;
        int i;
        GeneralEnvelope gcEnvelope = new GeneralEnvelope(new GeneralDirectPosition(envelope.getLowerCorner().getOrdinate(0), envelope.getLowerCorner().getOrdinate(1)), new GeneralDirectPosition(envelope.getUpperCorner().getOrdinate(0), envelope.getUpperCorner().getOrdinate(1)));
        gcEnvelope.setCoordinateReferenceSystem(crs);
        if (gridElem == null) {
            GeneralGridRange newGridrange = new GeneralGridRange(new int[]{0, 0}, new int[]{1, 1});
            GridGeometry2D newGridGeometry = new GridGeometry2D((GridEnvelope)newGridrange, (org.opengis.geometry.Envelope)gcEnvelope);
            return newGridGeometry;
        }
        NodeList low = gridElem.getElementsByTagName("low");
        NodeList high = gridElem.getElementsByTagName("high");
        int[] lowers = null;
        int[] upers = null;
        for (i = 0; i < low.getLength(); ++i) {
            values = ReaderUtils.getElementText((Element)((Element)low.item(i)));
            if (values == null) continue;
            ss = values.split(" ");
            lowers = new int[ss.length];
            for (j = 0; j < ss.length; ++j) {
                lowers[j] = Integer.parseInt(ss[j].trim());
            }
        }
        for (i = 0; i < high.getLength(); ++i) {
            values = ReaderUtils.getElementText((Element)((Element)high.item(i)));
            if (values == null) continue;
            ss = values.split(" ");
            upers = new int[ss.length];
            for (j = 0; j < ss.length; ++j) {
                upers[j] = Integer.parseInt(ss[j].trim());
            }
        }
        GeneralGridRange newGridrange = new GeneralGridRange(lowers, upers);
        Element geoTransform = ReaderUtils.getChildElement((Element)gridElem, (String)"geoTransform");
        if (geoTransform != null) {
            double[] flatMatrix = new double[9];
            Element scaleX = ReaderUtils.getChildElement((Element)geoTransform, (String)"scaleX");
            Element scaleY = ReaderUtils.getChildElement((Element)geoTransform, (String)"scaleY");
            Element shearX = ReaderUtils.getChildElement((Element)geoTransform, (String)"shearX");
            Element shearY = ReaderUtils.getChildElement((Element)geoTransform, (String)"shearY");
            Element translateX = ReaderUtils.getChildElement((Element)geoTransform, (String)"translateX");
            Element translateY = ReaderUtils.getChildElement((Element)geoTransform, (String)"translateY");
            if (scaleX != null) {
                flatMatrix[0] = Double.parseDouble(ReaderUtils.getElementText((Element)scaleX));
            }
            if (shearX != null) {
                flatMatrix[1] = Double.parseDouble(ReaderUtils.getElementText((Element)shearX));
            }
            if (translateX != null) {
                flatMatrix[2] = Double.parseDouble(ReaderUtils.getElementText((Element)translateX));
            }
            if (shearY != null) {
                flatMatrix[3] = Double.parseDouble(ReaderUtils.getElementText((Element)shearY));
            }
            if (scaleY != null) {
                flatMatrix[4] = Double.parseDouble(ReaderUtils.getElementText((Element)scaleY));
            }
            if (translateY != null) {
                flatMatrix[5] = Double.parseDouble(ReaderUtils.getElementText((Element)translateY));
            }
            flatMatrix[8] = 1.0;
            GeneralMatrix matrix = new GeneralMatrix(3, 3, flatMatrix);
            DefaultMathTransformFactory factory = new DefaultMathTransformFactory();
            MathTransform gridToCRS = factory.createAffineTransform((Matrix)matrix);
            return new GridGeometry2D((GridEnvelope)newGridrange, gridToCRS, gcEnvelope.getCoordinateReferenceSystem());
        }
        return new GridGeometry2D((GridEnvelope)newGridrange, (org.opengis.geometry.Envelope)gcEnvelope);
    }

    protected InternationalString[] loadDimensionNames(Element gridElem) throws ConfigurationException {
        if (gridElem == null) {
            return null;
        }
        NodeList axisNames = gridElem.getElementsByTagName("axisName");
        InternationalString[] dimNames = new InternationalString[axisNames.getLength()];
        for (int i = 0; i < axisNames.getLength(); ++i) {
            String values = ReaderUtils.getElementText((Element)((Element)axisNames.item(i)));
            if (values == null) continue;
            dimNames[i] = NameFactory.create((String)values).toInternationalString();
        }
        return dimNames;
    }

    protected CoverageDimension[] loadDimensions(NodeList dimElems) throws ConfigurationException {
        CoverageDimension[] dimensions = null;
        if (dimElems != null && dimElems.getLength() > 0) {
            dimensions = new CoverageDimension[dimElems.getLength()];
            int length = dimElems.getLength();
            for (int dim = 0; dim < length; ++dim) {
                NodeList values;
                dimensions[dim] = new CoverageDimension(this.catalog.getFactory().createCoverageDimension());
                dimensions[dim].setName(ReaderUtils.getElementText((Element)((Element)((Element)dimElems.item(dim)).getElementsByTagName("name").item(0))));
                dimensions[dim].setDescription(ReaderUtils.getElementText((Element)((Element)((Element)dimElems.item(dim)).getElementsByTagName("description").item(0))));
                NodeList interval = ((Element)dimElems.item(dim)).getElementsByTagName("interval");
                double min = Double.parseDouble(ReaderUtils.getElementText((Element)((Element)((Element)interval.item(0)).getElementsByTagName("min").item(0))));
                double max = Double.parseDouble(ReaderUtils.getElementText((Element)((Element)((Element)interval.item(0)).getElementsByTagName("max").item(0))));
                dimensions[dim].setRange(new NumberRange(min, max));
                NodeList nullValues = ((Element)dimElems.item(dim)).getElementsByTagName("nullValues");
                if (nullValues == null || nullValues.getLength() <= 0 || (values = ((Element)nullValues.item(0)).getElementsByTagName("value")) == null) continue;
                Vector<Double> nulls = new Vector<Double>();
                for (int nl = 0; nl < values.getLength(); ++nl) {
                    nulls.add(new Double(ReaderUtils.getElementText((Element)((Element)values.item(nl)))));
                }
                dimensions[dim].setNullValues(nulls.toArray(new Double[nulls.size()]));
            }
        }
        return dimensions;
    }

    protected MetaDataLink loadMetaDataLink(Element metalinkRoot) {
        MetaDataLink ml = new MetaDataLink(this.catalog.getFactory().createMetadataLink());
        try {
            ml.setAbout(ReaderUtils.getAttribute((Element)metalinkRoot, (String)"about", (boolean)false));
            ml.setType(ReaderUtils.getAttribute((Element)metalinkRoot, (String)"type", (boolean)false));
            ml.setMetadataType(ReaderUtils.getAttribute((Element)metalinkRoot, (String)"metadataType", (boolean)false));
            ml.setContent(ReaderUtils.getElementText((Element)metalinkRoot));
        }
        catch (Exception e) {
            ml = null;
        }
        return ml;
    }

    protected List getKeyWords(Element keywordsElem) {
        NodeList klist = keywordsElem.getElementsByTagName("keyword");
        int kCount = klist.getLength();
        LinkedList<String> keywords = new LinkedList<String>();
        for (int i = 0; i < kCount; ++i) {
            Element kelem = (Element)klist.item(i);
            String kword = ReaderUtils.getElementText((Element)kelem);
            if (kword == null) continue;
            keywords.add(kword);
        }
        return keywords;
    }

    protected Envelope loadBBox(Element bboxElem) throws ConfigurationException {
        if (bboxElem == null) {
            return new Envelope();
        }
        try {
            boolean dynamic = ReaderUtils.getBooleanAttribute((Element)bboxElem, (String)"dynamic", (boolean)false, (boolean)true);
            if (!dynamic) {
                double minx = ReaderUtils.getDoubleAttribute((Element)bboxElem, (String)"minx", (boolean)true);
                double miny = ReaderUtils.getDoubleAttribute((Element)bboxElem, (String)"miny", (boolean)true);
                double maxx = ReaderUtils.getDoubleAttribute((Element)bboxElem, (String)"maxx", (boolean)true);
                double maxy = ReaderUtils.getDoubleAttribute((Element)bboxElem, (String)"maxy", (boolean)true);
                return new Envelope(minx, maxx, miny, maxy);
            }
        }
        catch (Exception e) {
            throw new ConfigurationException(e);
        }
        return new Envelope();
    }

    protected Filter loadDefinitionQuery(Element typeRoot) throws ConfigurationException {
        try {
            Element defQNode = ReaderUtils.getChildElement((Element)typeRoot, (String)"definitionQuery", (boolean)false);
            Filter filter = null;
            if (defQNode != null) {
                LOGGER.finer("definitionQuery element found, looking for Filter");
                Element filterNode = ReaderUtils.getChildElement((Element)defQNode, (String)"Filter", (boolean)false);
                if (filterNode != null && (filterNode = ReaderUtils.getFirstChildElement((Element)filterNode)) != null) {
                    filter = FilterDOMParser.parseFilter((Node)filterNode);
                    return filter;
                }
                LOGGER.finer("No Filter definition query found");
            }
            return filter;
        }
        catch (Exception e) {
            throw new ConfigurationException(e);
        }
    }

    protected static boolean isInfoFile(File testFile) {
        String testName = testFile.getAbsolutePath();
        int start = testName.length() - "info.xml".length();
        int end = testName.length();
        return testName.substring(start, end).equals("info.xml");
    }

    protected void loadSchema(File schemaFile, FeatureTypeInfoDTO dto) throws ConfigurationException {
        try {
            schemaFile = ReaderUtils.checkFile((File)schemaFile, (boolean)false);
        }
        catch (FileNotFoundException e) {
            throw new ConfigurationException("Can't access " + schemaFile.getAbsolutePath(), e);
        }
        Element elem = null;
        dto.setSchemaFile(schemaFile);
        if (schemaFile == null || !schemaFile.exists() || !schemaFile.canRead()) {
            System.err.println("File does not exist for schema for " + dto.getName());
            return;
        }
        try {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.config(new StringBuffer("Loading configuration file: ").append(schemaFile).toString());
            }
            Reader reader = XmlCharsetDetector.getCharsetAwareReader((InputStream)new FileInputStream(schemaFile));
            elem = ReaderUtils.parse((Reader)reader);
            reader.close();
        }
        catch (FileNotFoundException e) {
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.log(Level.FINEST, e.getMessage(), e);
            }
            throw new ConfigurationException("Could not open schema file:" + schemaFile, e);
        }
        catch (Exception erk) {
            throw new ConfigurationException("Could not parse schema file:" + schemaFile, erk);
        }
        try {
            XMLConfigReader.processSchema(elem, dto);
        }
        catch (ConfigurationException e) {
            throw new ConfigurationException("Error occured in " + schemaFile + "\n" + e.getMessage(), e);
        }
    }

    public static void processSchema(Element elem, FeatureTypeInfoDTO featureTypeInfoDTO) throws ConfigurationException {
        ArrayList<AttributeTypeInfoDTO> list = new ArrayList<AttributeTypeInfoDTO>();
        try {
            featureTypeInfoDTO.setSchemaName(ReaderUtils.getAttribute((Element)elem, (String)"name", (boolean)true));
            elem = ReaderUtils.getChildElement((Element)elem, (String)"xs:complexContent");
            elem = ReaderUtils.getChildElement((Element)elem, (String)"xs:extension");
            NameSpaceTranslator gml = NameSpaceTranslatorFactory.getInstance().getNameSpaceTranslator("gml");
            NameSpaceElement nse = gml.getElement(ReaderUtils.getAttribute((Element)elem, (String)"base", (boolean)true));
            featureTypeInfoDTO.setSchemaBase(nse.getQualifiedTypeDefName());
            elem = ReaderUtils.getChildElement((Element)elem, (String)"xs:sequence");
            NodeList nl = elem.getElementsByTagName("xs:element");
            for (int i = 0; i < nl.getLength(); ++i) {
                Object tmp;
                elem = (Element)nl.item(i);
                AttributeTypeInfoDTO ati = new AttributeTypeInfoDTO();
                String name = ReaderUtils.getAttribute((Element)elem, (String)"name", (boolean)false);
                String ref = ReaderUtils.getAttribute((Element)elem, (String)"ref", (boolean)false);
                String type = ReaderUtils.getAttribute((Element)elem, (String)"type", (boolean)false);
                NameSpaceTranslator nst1 = NameSpaceTranslatorFactory.getInstance().getNameSpaceTranslator("xs");
                NameSpaceTranslator nst2 = NameSpaceTranslatorFactory.getInstance().getNameSpaceTranslator("gml");
                if (ref != null && ref != "") {
                    ati.setComplex(false);
                    nse = nst1.getElement(ref);
                    if (nse == null) {
                        nse = nst2.getElement(ref);
                    }
                    tmp = nse.getTypeRefName();
                    ati.setType((String)tmp);
                    ati.setName((String)tmp);
                } else {
                    ati.setName(name);
                    if (type != null && type != "") {
                        nse = nst1.getElement(type);
                        if (nse == null) {
                            nse = nst2.getElement(type);
                        }
                        tmp = nse.getTypeRefName();
                        ati.setType((String)tmp);
                        ati.setComplex(false);
                    } else {
                        tmp = ReaderUtils.getFirstChildElement((Element)elem);
                        OutputFormat format = new OutputFormat(tmp.getOwnerDocument());
                        format.setLineSeparator("\r\n");
                        format.setIndenting(true);
                        format.setLineWidth(0);
                        format.setPreserveSpace(true);
                        StringWriter sw = new StringWriter();
                        XMLSerializer serializer = new XMLSerializer((Writer)sw, format);
                        try {
                            serializer.asDOMSerializer();
                            serializer.serialize((Element)tmp);
                        }
                        catch (IOException e) {
                            throw new ConfigurationException(e);
                        }
                        ati.setType(elem.toString());
                        ati.setComplex(true);
                    }
                }
                ati.setNillable(ReaderUtils.getBooleanAttribute((Element)elem, (String)"nillable", (boolean)false, (boolean)true));
                ati.setMaxOccurs(ReaderUtils.getIntAttribute((Element)elem, (String)"maxOccurs", (boolean)false, (int)1));
                ati.setMinOccurs(ReaderUtils.getIntAttribute((Element)elem, (String)"minOccurs", (boolean)false, (int)1));
                list.add(ati);
            }
        }
        catch (Exception e) {
            throw new ConfigurationException(e);
        }
        featureTypeInfoDTO.setSchemaAttributes(list);
    }

    public DataDTO getData() {
        return this.data;
    }

    public GeoServerDTO getGeoServer() {
        return this.geoServer;
    }

    public WCSDTO getWcs() {
        return this.wcs;
    }

    public WFSDTO getWfs() {
        return this.wfs;
    }

    public WMSDTO getWms() {
        return this.wms;
    }

    public static MetaDataLink getMetaDataLink(Element metadataElem, Catalog catalog) throws Exception {
        MetaDataLink mdl = new MetaDataLink(catalog.getFactory().createMetadataLink());
        if (metadataElem != null) {
            String tmp = ReaderUtils.getElementText((Element)metadataElem, (boolean)false);
            if (tmp != null && tmp != "") {
                mdl.setContent(tmp);
            }
            if ((tmp = ReaderUtils.getAttribute((Element)metadataElem, (String)"about", (boolean)false)) != null && tmp != "") {
                mdl.setAbout(tmp);
            }
            if ((tmp = ReaderUtils.getAttribute((Element)metadataElem, (String)"type", (boolean)false)) != null && tmp != "") {
                mdl.setType(tmp);
            }
            if ((tmp = ReaderUtils.getAttribute((Element)metadataElem, (String)"metadataType", (boolean)false)) != null && tmp != "") {
                mdl.setMetadataType(tmp);
            }
        }
        return mdl;
    }
}

