/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.global;

import java.io.IOException;
import java.util.List;
import org.geoserver.feature.RetypingFeatureCollection;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureSource;
import org.geotools.data.FeatureStore;
import org.geotools.data.Transaction;
import org.geotools.feature.FeatureCollection;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.filter.Filter;
import org.opengis.filter.identity.FeatureId;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.vfny.geoserver.global.GeoServerFeatureSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeoServerFeatureStore
extends GeoServerFeatureSource
implements FeatureStore<SimpleFeatureType, SimpleFeature> {
    GeoServerFeatureStore(FeatureStore<SimpleFeatureType, SimpleFeature> store, SimpleFeatureType schema, Filter definitionQuery, CoordinateReferenceSystem declaredCRS, int srsHandling) {
        super((FeatureSource<SimpleFeatureType, SimpleFeature>)store, schema, definitionQuery, declaredCRS, srsHandling);
    }

    FeatureStore<SimpleFeatureType, SimpleFeature> store() {
        return (FeatureStore)this.source;
    }

    public List<FeatureId> addFeatures(FeatureCollection<SimpleFeatureType, SimpleFeature> fc) throws IOException {
        FeatureStore<SimpleFeatureType, SimpleFeature> store = this.store();
        if (!((SimpleFeatureType)store.getSchema()).equals(fc.getSchema())) {
            fc = new RetypingFeatureCollection(fc, (SimpleFeatureType)store.getSchema());
        }
        return this.store().addFeatures(fc);
    }

    public void removeFeatures(Filter filter) throws IOException {
        filter = this.makeDefinitionFilter(filter);
        this.store().removeFeatures(filter);
    }

    public void modifyFeatures(AttributeDescriptor[] type, Object[] value, Filter filter) throws IOException {
        filter = this.makeDefinitionFilter(filter);
        this.store().modifyFeatures(type, value, filter);
    }

    public void modifyFeatures(AttributeDescriptor type, Object value, Filter filter) throws IOException {
        filter = this.makeDefinitionFilter(filter);
        this.store().modifyFeatures(type, value, filter);
    }

    public void setFeatures(FeatureReader<SimpleFeatureType, SimpleFeature> reader) throws IOException {
        FeatureStore<SimpleFeatureType, SimpleFeature> store = this.store();
        if (!((SimpleFeatureType)store.getSchema()).equals(reader.getFeatureType())) {
            reader = new RetypingFeatureCollection.RetypingFeatureReader(reader, (SimpleFeatureType)store.getSchema());
        }
        this.store().setFeatures(reader);
    }

    public void setTransaction(Transaction transaction) {
        this.store().setTransaction(transaction);
    }

    public Transaction getTransaction() {
        return this.store().getTransaction();
    }
}

