/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.global;

import java.io.IOException;
import java.io.Serializable;
import java.util.NoSuchElementException;
import java.util.logging.Logger;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.data.util.CoverageStoreUtils;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.factory.Hints;
import org.geotools.util.logging.Logging;
import org.opengis.coverage.grid.Format;
import org.opengis.coverage.grid.GridCoverageReader;
import org.vfny.geoserver.global.GlobalLayerSupertype;
import org.vfny.geoserver.global.NameSpaceInfo;
import org.vfny.geoserver.global.dto.CoverageStoreInfoDTO;

public final class CoverageStoreInfo
extends GlobalLayerSupertype {
    private static final Logger LOGGER = Logging.getLogger((String)CoverageStoreInfo.class.toString());
    org.geoserver.catalog.CoverageStoreInfo cs;
    Catalog catalog;

    public CoverageStoreInfo(org.geoserver.catalog.CoverageStoreInfo cs, Catalog catalog) {
        this.cs = cs;
        this.catalog = catalog;
    }

    public void load(CoverageStoreInfoDTO dto) {
        this.cs.setEnabled(dto.isEnabled());
        this.cs.setName(dto.getId());
        this.cs.setWorkspace(this.catalog.getWorkspaceByName(dto.getNameSpaceId()));
        this.cs.setType(dto.getType());
        this.cs.setURL(dto.getUrl());
        this.cs.setDescription(dto.getTitle());
    }

    private Format lookupFormat() {
        int length = CoverageStoreUtils.formats.length;
        for (int i = 0; i < length; ++i) {
            if (!CoverageStoreUtils.formats[i].getName().equals(this.getType())) continue;
            return CoverageStoreUtils.formats[i];
        }
        return null;
    }

    Object toDTO() {
        CoverageStoreInfoDTO dto = new CoverageStoreInfoDTO();
        dto.setAbstract(this.getAbstract());
        dto.setEnabled(this.isEnabled());
        dto.setId(this.getId());
        dto.setNameSpaceId(this.getNamesSpacePrefix());
        dto.setType(this.getType());
        dto.setTitle(this.getTitle());
        dto.setUrl(this.getUrl());
        return dto;
    }

    public String getId() {
        return this.cs.getName();
    }

    public Format getFormat() throws IllegalStateException, NoSuchElementException {
        if (!this.isEnabled()) {
            throw new IllegalStateException("this format is not enabled, check your configuration");
        }
        AbstractGridFormat format = this.cs.getFormat();
        if (format == null) {
            LOGGER.warning("failed to establish connection with " + this.toString());
            throw new NoSuchElementException("No format found capable of managing " + this.toString());
        }
        return format;
    }

    public String getTitle() {
        return this.cs.getName();
    }

    public String getAbstract() {
        return this.cs.getDescription();
    }

    public boolean isEnabled() {
        return this.cs.isEnabled();
    }

    public String toString() {
        return new StringBuffer("FormatConfig[type=").append(this.getType()).append(", enabled=").append(this.isEnabled()).append(", abstract=").append(this.getAbstract()).append("]").toString();
    }

    public boolean containsMetaData(String key) {
        return this.cs.getMetadata().get(key) != null;
    }

    public void putMetaData(String key, Object value) {
        this.cs.getMetadata().put(key, (Serializable)value);
    }

    public Object getMetaData(String key) {
        return this.cs.getMetadata().get(key);
    }

    public String getType() {
        return this.cs.getType();
    }

    public String getUrl() {
        return this.cs.getURL();
    }

    public NameSpaceInfo getNameSpace() {
        NamespaceInfo ns = this.catalog.getNamespaceByPrefix(this.cs.getWorkspace().getName());
        return new NameSpaceInfo(ns, this.catalog);
    }

    public String getNamesSpacePrefix() {
        return this.cs.getWorkspace().getName();
    }

    public synchronized GridCoverageReader getReader() {
        try {
            return this.catalog.getResourcePool().getGridCoverageReader(this.cs, null);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public synchronized GridCoverageReader createReader(Hints hints) {
        try {
            return this.catalog.getResourcePool().getGridCoverageReader(this.cs, hints);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void dispose() {
        this.catalog.getResourcePool().clear(this.cs);
    }
}

