/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.config;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import org.geotools.data.DataStore;
import org.geotools.data.DataStoreFactorySpi;
import org.vfny.geoserver.global.dto.DataStoreInfoDTO;
import org.vfny.geoserver.util.DataStoreUtils;

public class DataStoreConfig {
    private String id;
    private String nameSpaceId;
    private boolean enabled = true;
    private String title;
    private String _abstract;
    private Map connectionParams;
    private DataStoreFactorySpi factory;

    public DataStoreConfig(String dataStoreId, String factoryDescription) {
        this(dataStoreId, DataStoreUtils.aquireFactory(factoryDescription));
    }

    public DataStoreConfig(String dataStoreId, DataStoreFactorySpi factory) {
        this.factory = factory;
        this.id = dataStoreId;
        this.nameSpaceId = "";
        this.enabled = true;
        this.title = "";
        this._abstract = "";
        this.connectionParams = DataStoreUtils.defaultParams(factory);
    }

    public DataStoreConfig(DataStoreInfoDTO dto) {
        this.reset(dto);
    }

    public void reset(DataStoreInfoDTO dto) {
        if (dto == null) {
            throw new NullPointerException("Non null DataStoreInfoDTO required");
        }
        this.factory = DataStoreUtils.aquireFactory(dto.getConnectionParams());
        this.id = dto.getId();
        this.nameSpaceId = dto.getNameSpaceId();
        this.enabled = dto.isEnabled();
        this._abstract = dto.getAbstract();
        this.connectionParams = new HashMap(dto.getConnectionParams());
    }

    public void update(DataStoreInfoDTO ds) {
        if (ds == null) {
            throw new NullPointerException("DataStoreInfo Data Transfer Object required");
        }
        this.id = ds.getId();
        this.nameSpaceId = ds.getNameSpaceId();
        this.enabled = ds.isEnabled();
        this._abstract = ds.getAbstract();
        try {
            this.connectionParams = new HashMap(ds.getConnectionParams());
        }
        catch (Exception e) {
            this.connectionParams = new HashMap();
        }
    }

    public DataStoreInfoDTO toDTO() {
        DataStoreInfoDTO ds = new DataStoreInfoDTO();
        ds.setId(this.id);
        ds.setNameSpaceId(this.nameSpaceId);
        ds.setEnabled(this.enabled);
        ds.setAbstract(this._abstract);
        try {
            ds.setConnectionParams(new HashMap(this.connectionParams));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ds;
    }

    public String getAbstract() {
        return this._abstract;
    }

    public Map getConnectionParams() {
        return this.connectionParams;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getId() {
        return this.id;
    }

    public String getNameSpaceId() {
        return this.nameSpaceId;
    }

    public String getTitle() {
        return this.title;
    }

    public void setAbstract(String string) {
        if (string != null) {
            this._abstract = string;
        }
    }

    public void setConnectionParams(Map map) {
        this.connectionParams = map;
    }

    public void setEnabled(boolean b) {
        this.enabled = b;
    }

    public void setNameSpaceId(String support) {
        if (support != null) {
            this.nameSpaceId = support;
        }
    }

    public void setTitle(String string) {
        if (string != null) {
            this.title = string;
        }
    }

    public DataStore findDataStore(ServletContext sc) throws IOException {
        return DataStoreUtils.acquireDataStore(this.connectionParams, sc);
    }

    public DataStoreFactorySpi getFactory() {
        return this.factory;
    }
}

