/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.template;

import com.vividsolutions.jts.geom.Geometry;
import freemarker.ext.beans.BeansWrapper;
import freemarker.template.SimpleHash;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.util.AbstractMap;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.geoserver.template.FeatureCollectionModel;
import org.geoserver.template.SequenceMapModel;
import org.geotools.feature.FeatureCollection;
import org.geotools.util.MapEntry;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;

public class FeatureWrapper
extends BeansWrapper {
    public FeatureWrapper() {
        this.setSimpleMapWrapper(true);
    }

    protected String wrapValue(Object o) {
        return FeatureWrapper.valueToString(o);
    }

    private static String valueToString(Object o) {
        if (o == null) {
            return "";
        }
        if (o instanceof Date) {
            if (o instanceof Timestamp) {
                return DateFormat.getDateTimeInstance().format((Date)o);
            }
            if (o instanceof Time) {
                return DateFormat.getTimeInstance().format((Date)o);
            }
            return DateFormat.getInstance().format((Date)o);
        }
        if (o instanceof Boolean) {
            return (Boolean)o != false ? "true" : "false";
        }
        if (o instanceof Geometry) {
            return String.valueOf(o);
        }
        return String.valueOf(o);
    }

    public TemplateModel wrap(Object object) throws TemplateModelException {
        if (object instanceof FeatureCollection) {
            SimpleHash map = new SimpleHash();
            FeatureCollection featureCollection = (FeatureCollection)object;
            map.put("features", (Object)new FeatureCollectionModel(featureCollection, this));
            map.put("type", (Object)this.wrap(((FeatureCollection)object).getSchema()));
            return map;
        }
        if (object instanceof SimpleFeatureType) {
            SimpleFeatureType ft = (SimpleFeatureType)object;
            LinkedHashMap attributeMap = new LinkedHashMap();
            for (int i = 0; i < ft.getAttributeCount(); ++i) {
                AttributeDescriptor type = ft.getDescriptor(i);
                HashMap<String, Object> attribute = new HashMap<String, Object>();
                attribute.put("name", type.getLocalName());
                attribute.put("type", type.getType().getBinding().getName());
                attribute.put("isGeometry", Geometry.class.isAssignableFrom(type.getType().getBinding()));
                attributeMap.put(type.getLocalName(), attribute);
            }
            SimpleHash map = new SimpleHash();
            map.put("attributes", (Object)new SequenceMapModel(attributeMap, this));
            map.put("name", (Object)ft.getTypeName());
            return map;
        }
        if (object instanceof SimpleFeature) {
            SimpleFeature feature = (SimpleFeature)object;
            SimpleHash map = new SimpleHash();
            map.put("fid", (Object)feature.getID());
            map.put("typeName", (Object)feature.getFeatureType().getTypeName());
            FeatureAttributesMap attributeMap = new FeatureAttributesMap(feature);
            map.putAll((Map)attributeMap);
            map.put("attributes", (Object)new SequenceMapModel(attributeMap, this));
            return map;
        }
        return super.wrap(object);
    }

    private static class AttributeMap
    extends AbstractMap {
        private final String attributeName;
        private final SimpleFeature feature;
        private Set entrySet;

        public AttributeMap(String attributeName, SimpleFeature feature) {
            this.attributeName = attributeName;
            this.feature = feature;
        }

        public int hashCode() {
            return this.attributeName.hashCode();
        }

        public Set entrySet() {
            if (this.entrySet == null) {
                this.entrySet = new LinkedHashSet();
                SimpleFeatureType featureType = this.feature.getFeatureType();
                AttributeDescriptor attributeType = featureType.getDescriptor(this.attributeName);
                Object value = this.feature.getAttribute(this.attributeName);
                this.entrySet.add(new DeferredValueEntry("value", value));
                this.entrySet.add(new MapEntry((Object)"name", (Object)this.attributeName));
                this.entrySet.add(new MapEntry((Object)"type", (Object)attributeType.getType().getBinding().getName()));
                Object rawValue = value == null ? "" : value;
                boolean isGeometry = Geometry.class.isAssignableFrom(attributeType.getType().getBinding());
                this.entrySet.add(new MapEntry((Object)"isGeometry", (Object)isGeometry));
                this.entrySet.add(new MapEntry((Object)"rawValue", rawValue));
            }
            return this.entrySet;
        }

        private static class DeferredValueEntry
        extends MapEntry {
            private static final long serialVersionUID = -3919798947862996744L;

            public DeferredValueEntry(String key, Object attribute) {
                super((Object)key, attribute);
            }

            public Object getValue() {
                Object actualValue = super.getValue();
                String stringValue = FeatureWrapper.valueToString(actualValue);
                return stringValue;
            }
        }
    }

    private static class FeatureAttributesMap
    extends AbstractMap {
        private Set entrySet;
        private SimpleFeature feature;

        public FeatureAttributesMap(SimpleFeature feature) {
            this.feature = feature;
        }

        public Set entrySet() {
            if (this.entrySet == null) {
                this.entrySet = new LinkedHashSet();
                List types = this.feature.getFeatureType().getAttributeDescriptors();
                int attributeCount = types.size();
                for (int i = 0; i < attributeCount; ++i) {
                    String attName = ((AttributeDescriptor)types.get(i)).getLocalName();
                    AttributeMap attributesMap = new AttributeMap(attName, this.feature);
                    this.entrySet.add(new MapEntry((Object)attName, (Object)attributesMap));
                }
            }
            return this.entrySet;
        }
    }
}

