/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.decorators;

import java.io.IOException;
import org.geoserver.security.decorators.DecoratingFeatureSource;
import org.geoserver.security.decorators.ReadOnlyDataAccess;
import org.geoserver.security.decorators.ReadOnlyDataStore;
import org.geoserver.security.decorators.ReadOnlyFeatureCollection;
import org.geotools.data.DataAccess;
import org.geotools.data.DataStore;
import org.geotools.data.FeatureSource;
import org.geotools.data.Query;
import org.geotools.feature.FeatureCollection;
import org.opengis.feature.Feature;
import org.opengis.feature.type.FeatureType;
import org.opengis.filter.Filter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReadOnlyFeatureSource<T extends FeatureType, F extends Feature>
extends DecoratingFeatureSource<T, F> {
    boolean challenge;

    public ReadOnlyFeatureSource(FeatureSource<T, F> delegate, boolean challenge) {
        super(delegate);
        this.challenge = challenge;
    }

    @Override
    public DataAccess<T, F> getDataStore() {
        DataAccess store = ((FeatureSource)this.delegate).getDataStore();
        if (store == null) {
            return null;
        }
        if (store instanceof DataStore) {
            return new ReadOnlyDataStore((DataStore)store, this.challenge);
        }
        return new ReadOnlyDataAccess(store, this.challenge);
    }

    @Override
    public FeatureCollection<T, F> getFeatures() throws IOException {
        FeatureCollection fc = ((FeatureSource)this.delegate).getFeatures();
        if (fc == null) {
            return null;
        }
        return new ReadOnlyFeatureCollection(fc, this.challenge);
    }

    @Override
    public FeatureCollection<T, F> getFeatures(Filter filter) throws IOException {
        FeatureCollection fc = ((FeatureSource)this.delegate).getFeatures(filter);
        if (fc == null) {
            return null;
        }
        return new ReadOnlyFeatureCollection(fc, this.challenge);
    }

    @Override
    public FeatureCollection<T, F> getFeatures(Query query) throws IOException {
        FeatureCollection fc = ((FeatureSource)this.delegate).getFeatures(query);
        if (fc == null) {
            return null;
        }
        return new ReadOnlyFeatureCollection(fc, this.challenge);
    }
}

