/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.decorators;

import java.util.Collection;
import java.util.Iterator;
import org.geoserver.security.SecureCatalogImpl;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.collection.DecoratingFeatureCollection;
import org.opengis.feature.Feature;
import org.opengis.feature.type.FeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.sort.SortBy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReadOnlyFeatureCollection<T extends FeatureType, F extends Feature>
extends DecoratingFeatureCollection<T, F> {
    boolean challenge;

    protected ReadOnlyFeatureCollection(FeatureCollection<T, F> delegate, boolean challenge) {
        super(delegate);
        this.challenge = challenge;
    }

    public Iterator iterator() {
        Iterator it = this.delegate.iterator();
        if (it == null) {
            return null;
        }
        return new ReadOnlyIterator(it, this.challenge);
    }

    public FeatureCollection<T, F> sort(SortBy order) {
        FeatureCollection fc = this.delegate.sort(order);
        if (fc == null) {
            return null;
        }
        return new ReadOnlyFeatureCollection<T, F>(fc, this.challenge);
    }

    public FeatureCollection<T, F> subCollection(Filter filter) {
        FeatureCollection fc = this.delegate.subCollection(filter);
        if (fc == null) {
            return null;
        }
        return new ReadOnlyFeatureCollection<T, F>(fc, this.challenge);
    }

    public boolean add(F o) {
        throw this.unsupportedOperation();
    }

    public boolean addAll(Collection c) {
        throw this.unsupportedOperation();
    }

    public void clear() {
        throw this.unsupportedOperation();
    }

    public boolean remove(Object o) {
        throw this.unsupportedOperation();
    }

    public boolean removeAll(Collection c) {
        throw this.unsupportedOperation();
    }

    public boolean retainAll(Collection c) {
        throw this.unsupportedOperation();
    }

    RuntimeException unsupportedOperation() {
        String typeName = this.getID();
        if (this.challenge) {
            return SecureCatalogImpl.unauthorizedAccess(typeName);
        }
        return new UnsupportedOperationException("Feature type " + typeName + " is read only");
    }

    class ReadOnlyIterator
    implements Iterator {
        Iterator wrapped;
        boolean challenge;

        public ReadOnlyIterator(Iterator wrapped, boolean challenge) {
            this.wrapped = wrapped;
            this.challenge = challenge;
        }

        public boolean hasNext() {
            return this.wrapped.hasNext();
        }

        public Object next() {
            return this.wrapped.next();
        }

        public void remove() {
            throw ReadOnlyFeatureCollection.this.unsupportedOperation();
        }
    }
}

