/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.acegisecurity.userdetails.UserDetails;
import org.acegisecurity.userdetails.UserDetailsService;
import org.acegisecurity.userdetails.UsernameNotFoundException;
import org.acegisecurity.userdetails.memory.UserMap;
import org.acegisecurity.userdetails.memory.UserMapEditor;
import org.geoserver.security.PropertyFileWatcher;
import org.geotools.util.logging.Logging;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataAccessResourceFailureException;
import org.vfny.geoserver.global.GeoServer;
import org.vfny.geoserver.global.GeoserverDataDirectory;

public class GeoserverUserDao
implements UserDetailsService {
    static Logger LOGGER = Logging.getLogger((String)"org.geoserver.security");
    private UserMap userMap;
    private PropertyFileWatcher userDefinitionsFile;
    private GeoServer geoServer;

    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException, DataAccessException {
        this.checkUserMap();
        return this.userMap.getUser(username);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkUserMap() throws DataAccessResourceFailureException {
        InputStream is = null;
        OutputStream os = null;
        if (this.userMap == null || this.userDefinitionsFile != null && this.userDefinitionsFile.isStale()) {
            try {
                if (this.userDefinitionsFile == null) {
                    File securityDir = GeoserverDataDirectory.findCreateConfigDir("security");
                    File propFile = new File(securityDir, "users.properties");
                    if (!propFile.exists()) {
                        Properties p = new Properties();
                        if (this.geoServer != null && this.geoServer.getAdminUserName() != null && !this.geoServer.getAdminUserName().trim().equals("")) {
                            p.put(this.geoServer.getAdminUserName(), this.geoServer.getAdminPassword() + ",ROLE_ADMINISTRATOR");
                        } else {
                            p.put("admin", "geoserver,ROLE_ADMINISTRATOR");
                        }
                        os = new FileOutputStream(propFile);
                        p.store(os, "Format: name=password,ROLE1,...,ROLEN");
                        os.close();
                        File serviceFile = new File(securityDir, "service.properties");
                        os = new FileOutputStream(serviceFile);
                        is = GeoserverUserDao.class.getResourceAsStream("serviceTemplate.properties");
                        byte[] buffer = new byte[1024];
                        int count = 0;
                        while ((count = is.read(buffer)) > 0) {
                            os.write(buffer, 0, count);
                        }
                    }
                    this.userDefinitionsFile = new PropertyFileWatcher(propFile);
                }
                this.userMap = new UserMap();
                UserMapEditor.addUsersFromProperties((UserMap)this.userMap, (Properties)this.userDefinitionsFile.getProperties());
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "An error occurred loading user definitions", e);
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException ei) {}
                }
                if (os != null) {
                    try {
                        os.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    public GeoServer getGeoServer() {
        return this.geoServer;
    }

    public void setGeoServer(GeoServer geoServer) {
        this.geoServer = geoServer;
    }
}

