/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.config.util;

import java.io.File;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.config.ContactInfo;
import org.geoserver.config.GeoServer;
import org.geoserver.config.GeoServerFactory;
import org.geoserver.config.GeoServerInfo;
import org.geoserver.config.ServiceInfo;
import org.geoserver.config.ServiceLoader;
import org.geoserver.config.util.LegacyImporterSupport;
import org.geoserver.config.util.LegacyServiceLoader;
import org.geoserver.config.util.LegacyServicesReader;
import org.geoserver.jai.JAIInfo;
import org.geoserver.platform.GeoServerExtensions;
import org.geotools.util.logging.Logging;

public class LegacyConfigurationImporter
extends LegacyImporterSupport {
    static Logger LOGGER = Logging.getLogger((String)"org.geoserver.confg");
    GeoServer geoServer;

    public LegacyConfigurationImporter(GeoServer geoServer) {
        this.geoServer = geoServer;
    }

    public LegacyConfigurationImporter() {
    }

    public void setConfiguration(GeoServer geoServer) {
        this.geoServer = geoServer;
    }

    public GeoServer getConfiguration() {
        return this.geoServer;
    }

    public void imprt(File dir) throws Exception {
        LegacyServicesReader reader = this.reader(dir);
        GeoServerFactory factory = this.geoServer.getFactory();
        GeoServerInfo info = this.geoServer.getGlobal();
        if (info == null) {
            info = factory.createGlobal();
            this.geoServer.setGlobal(info);
        }
        Map<String, Object> global = reader.global();
        info.setMaxFeatures(this.get(global, "maxFeatures", Integer.class));
        info.setVerbose(this.get(global, "verbose", Boolean.class));
        info.setVerboseExceptions(this.get(global, "verboseExceptions", Boolean.class));
        info.setNumDecimals(this.get(global, "numDecimals", Integer.class));
        info.setCharset((String)global.get("charSet"));
        info.setUpdateSequence(this.get(global, "updateSequence", Integer.class));
        info.setOnlineResource(this.get(global, "onlineResource", String.class));
        info.setProxyBaseUrl(this.get(global, "ProxyBaseUrl", String.class));
        Map<String, Object> contact = reader.contact();
        ContactInfo contactInfo = factory.createContact();
        contactInfo.setContactPerson((String)contact.get("ContactPerson"));
        contactInfo.setContactOrganization((String)contact.get("ContactOrganization"));
        contactInfo.setContactVoice((String)contact.get("ContactVoiceTelephone"));
        contactInfo.setContactFacsimile((String)contact.get("ContactFacsimileTelephone"));
        contactInfo.setContactPosition((String)contact.get("ContactPosition"));
        contactInfo.setContactEmail((String)contact.get("ContactElectronicMailAddress"));
        contactInfo.setAddress((String)contact.get("Address"));
        contactInfo.setAddressType((String)contact.get("AddressType"));
        contactInfo.setAddressCity((String)contact.get("City"));
        contactInfo.setAddressCountry((String)contact.get("Country"));
        contactInfo.setAddressState((String)contact.get("StateOrProvince"));
        contactInfo.setAddressPostalCode((String)contact.get("PostCode"));
        info.setContactInfo(contactInfo);
        JAIInfo jai = new JAIInfo();
        jai.setMemoryCapacity((Double)this.value(global.get("JaiMemoryCapacity"), 0.5));
        jai.setMemoryThreshold((Double)this.value(global.get("JaiMemoryThreshold"), 0.75));
        jai.setTileThreads((Integer)this.value(global.get("JaiTileThreads"), 7));
        jai.setTilePriority((Integer)this.value(global.get("JaiTilePriority"), 5));
        jai.setImageIOCache((Boolean)this.value(global.get("ImageIOCache"), false));
        jai.setJPEGAcceleration((Boolean)this.value(global.get("JaiJPEGNative"), true));
        jai.setPNGAcceleration((Boolean)this.value(global.get("JaiPNGNative"), true));
        jai.setRecycling((Boolean)this.value(global.get("JaiRecycling"), true));
        info.getMetadata().put(JAIInfo.KEY, jai);
        this.geoServer.setGlobal(info);
        for (ServiceLoader sl : GeoServerExtensions.extensions(ServiceLoader.class)) {
            try {
                ServiceInfo service;
                if (sl instanceof LegacyServiceLoader) {
                    ((LegacyServiceLoader)sl).setReader(reader);
                }
                if ((service = sl.load(this.geoServer)) == null) continue;
                LOGGER.info("Loading service '" + service.getId() + "'");
                this.geoServer.add(service);
            }
            catch (Exception e) {
                String msg = "Error occured loading service: " + sl.getServiceId();
                LOGGER.warning(msg);
                LOGGER.log(Level.INFO, "", e);
            }
        }
    }
}

