/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom;

import org.geolatte.geom.Geometry;
import org.geolatte.geom.GeometryType;
import org.geolatte.geom.GeometryVisitor;
import org.geolatte.geom.PackedPositionSequence;
import org.geolatte.geom.Position;
import org.geolatte.geom.PositionSequence;
import org.geolatte.geom.Positions;
import org.geolatte.geom.Simple;
import org.geolatte.geom.crs.CoordinateReferenceSystem;

public class Point<P extends Position>
extends Geometry<P>
implements Simple {
    public Point(CoordinateReferenceSystem<P> crs) {
        super(crs);
    }

    public Point(PositionSequence<P> sequence, CoordinateReferenceSystem<P> crs) {
        super(sequence, crs);
    }

    public Point(P position, CoordinateReferenceSystem<P> crs) {
        this(new PackedPositionSequence<P>(Positions.getFactoryFor(crs.getPositionClass()), ((Position)position).coords), crs);
    }

    public Point(Point<P> point) {
        this((P)point.getPositions(), (CoordinateReferenceSystem<P>)point.getCoordinateReferenceSystem());
    }

    public P getPosition() {
        return this.getPositions().getPositionN(0);
    }

    @Override
    public <Q extends Position> Point<Q> as(Class<Q> castToType) {
        this.checkCast(castToType);
        return this;
    }

    @Override
    public int getDimension() {
        return 0;
    }

    @Override
    public GeometryType getGeometryType() {
        return GeometryType.POINT;
    }

    @Override
    public void accept(GeometryVisitor<P> visitor) {
        visitor.visit(this);
    }
}

