/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom;

import org.geolatte.geom.C2D;
import org.geolatte.geom.Complex;
import org.geolatte.geom.Geometries;
import org.geolatte.geom.Geometry;
import org.geolatte.geom.GeometryCollection;
import org.geolatte.geom.Point;
import org.geolatte.geom.PositionSequence;
import org.geolatte.geom.ProjectedGeometryOperations;
import org.geolatte.geom.Simple;
import org.geolatte.geom.crs.CoordinateReferenceSystem;
import org.geolatte.geom.jts.JTS;
import org.locationtech.jts.algorithm.ConvexHull;
import org.locationtech.jts.operation.BoundaryOp;
import org.locationtech.jts.operation.IsSimpleOp;
import org.locationtech.jts.operation.buffer.BufferOp;
import org.locationtech.jts.operation.distance.DistanceOp;
import org.locationtech.jts.operation.overlay.snap.SnapIfNeededOverlayOp;
import org.locationtech.jts.operation.relate.RelateOp;

public class JTSGeometryOperations
implements ProjectedGeometryOperations {
    private <P extends C2D> boolean envelopeIntersect(Geometry<P> geometry1, Geometry<P> geometry2) {
        return geometry1.getEnvelope().intersects(geometry2.getEnvelope());
    }

    private <P extends C2D> void checkNotGeometryCollection(Geometry<P> geom) {
        if (GeometryCollection.class.equals(geom.getClass())) {
            throw new IllegalArgumentException("GeometryCollection is not allowed");
        }
    }

    private void checkCompatibleCRS(Geometry<?> geometry, Geometry<?> other) {
        if (!geometry.getCoordinateReferenceSystem().equals(other.getCoordinateReferenceSystem())) {
            throw new IllegalArgumentException("Geometries have different CRS's");
        }
    }

    @Override
    public <P extends C2D> boolean isSimple(Geometry<P> geometry) {
        return new IsSimpleOp(JTS.to(geometry)).isSimple();
    }

    @Override
    public <P extends C2D> Geometry<P> boundary(Geometry<P> geometry) {
        BoundaryOp boundaryOp = new BoundaryOp(JTS.to(geometry));
        CoordinateReferenceSystem<P> crs = geometry.getCoordinateReferenceSystem();
        return JTS.from(boundaryOp.getBoundary(), crs);
    }

    @Override
    public <P extends C2D, G extends Geometry<P>> G reverse(G geometry) {
        PositionSequence<P> pos = geometry.getPositions().reverse();
        if (geometry instanceof Simple) {
            return (G)Geometries.mkGeometry(geometry.getClass(), pos, geometry.getCoordinateReferenceSystem());
        }
        Complex complex = (Complex)((Object)geometry);
        Geometry[] geoms = complex.components();
        this.reverseOrder(this.reverseAll(geoms));
        return (G)Geometries.mkGeometry(geometry.getClass(), geoms);
    }

    private <P extends C2D> Geometry<P>[] reverseAll(Geometry<P>[] components) {
        for (int i = 0; i < components.length; ++i) {
            components[i] = this.reverse(components[i]);
        }
        return components;
    }

    private <P extends C2D> Geometry<P>[] reverseOrder(Geometry<P>[] components) {
        for (int i = 0; i < components.length / 2; ++i) {
            Geometry<P> h = components[i];
            components[i] = components[components.length - 1 - i];
            components[components.length - 1 - i] = h;
        }
        return components;
    }

    @Override
    public <P extends C2D> boolean intersects(Geometry<P> geometry, Geometry<P> other) {
        if (geometry.isEmpty() || other.isEmpty()) {
            return Boolean.FALSE;
        }
        this.checkCompatibleCRS(geometry, other);
        if (!this.envelopeIntersect(geometry, other)) {
            return Boolean.FALSE;
        }
        RelateOp relateOp = new RelateOp(JTS.to(geometry), JTS.to(other));
        return relateOp.getIntersectionMatrix().isIntersects();
    }

    @Override
    public <P extends C2D> boolean touches(Geometry<P> geometry, Geometry<P> other) {
        if (geometry.isEmpty() || other.isEmpty()) {
            return Boolean.FALSE;
        }
        this.checkCompatibleCRS(geometry, other);
        if (!this.envelopeIntersect(geometry, other)) {
            return Boolean.FALSE;
        }
        RelateOp relateOp = new RelateOp(JTS.to(geometry), JTS.to(other));
        return relateOp.getIntersectionMatrix().isTouches(geometry.getDimension(), other.getDimension());
    }

    @Override
    public <P extends C2D> boolean crosses(Geometry<P> geometry, Geometry<P> other) {
        if (geometry.isEmpty() || other.isEmpty()) {
            return Boolean.FALSE;
        }
        this.checkCompatibleCRS(geometry, other);
        if (!this.envelopeIntersect(geometry, other)) {
            return Boolean.FALSE;
        }
        RelateOp relateOp = new RelateOp(JTS.to(geometry), JTS.to(other));
        return relateOp.getIntersectionMatrix().isCrosses(geometry.getDimension(), other.getDimension());
    }

    @Override
    public <P extends C2D> boolean contains(Geometry<P> geometry, Geometry<P> other) {
        if (geometry.isEmpty() || other.isEmpty()) {
            return Boolean.FALSE;
        }
        this.checkCompatibleCRS(geometry, other);
        if (!geometry.getEnvelope().contains(other.getEnvelope())) {
            return Boolean.FALSE;
        }
        RelateOp relateOp = new RelateOp(JTS.to(geometry), JTS.to(other));
        return relateOp.getIntersectionMatrix().isContains();
    }

    @Override
    public <P extends C2D> boolean overlaps(Geometry<P> geometry, Geometry<P> other) {
        if (geometry.isEmpty() || other.isEmpty()) {
            return Boolean.FALSE;
        }
        this.checkCompatibleCRS(geometry, other);
        if (!this.envelopeIntersect(geometry, other)) {
            return Boolean.FALSE;
        }
        RelateOp relateOp = new RelateOp(JTS.to(geometry), JTS.to(other));
        return relateOp.getIntersectionMatrix().isOverlaps(geometry.getDimension(), other.getDimension());
    }

    @Override
    public <P extends C2D> boolean relates(Geometry<P> geometry, Geometry<P> other, String matrix) {
        if (geometry.isEmpty() || other.isEmpty()) {
            return Boolean.FALSE;
        }
        this.checkCompatibleCRS(geometry, other);
        RelateOp relateOp = new RelateOp(JTS.to(geometry), JTS.to(other));
        return relateOp.getIntersectionMatrix().matches(matrix);
    }

    @Override
    public <P extends C2D> double distance(Geometry<P> geometry, Geometry<P> other) {
        DistanceOp op = new DistanceOp(JTS.to(geometry), JTS.to(other));
        return op.distance();
    }

    @Override
    public <P extends C2D> Geometry<P> buffer(Geometry<P> geometry, double distance) {
        BufferOp op = new BufferOp(JTS.to(geometry));
        return JTS.from(op.getResultGeometry(distance), geometry.getCoordinateReferenceSystem());
    }

    @Override
    public <P extends C2D> Geometry<P> convexHull(Geometry<P> geometry) {
        ConvexHull convexHull = new ConvexHull(JTS.to(geometry));
        return JTS.from(convexHull.getConvexHull(), geometry.getCoordinateReferenceSystem());
    }

    @Override
    public <P extends C2D> Geometry<P> intersection(Geometry<P> geometry, Geometry<P> other) {
        this.checkCompatibleCRS(geometry, other);
        if (geometry.isEmpty() || other.isEmpty()) {
            return new Point<P>(geometry.getCoordinateReferenceSystem());
        }
        this.checkNotGeometryCollection(geometry);
        this.checkNotGeometryCollection(other);
        org.locationtech.jts.geom.Geometry intersection = SnapIfNeededOverlayOp.overlayOp((org.locationtech.jts.geom.Geometry)JTS.to(geometry), (org.locationtech.jts.geom.Geometry)JTS.to(other), (int)1);
        return JTS.from(intersection, geometry.getCoordinateReferenceSystem());
    }

    @Override
    public <P extends C2D> Geometry<P> union(Geometry<P> geometry, Geometry<P> other) {
        this.checkCompatibleCRS(geometry, other);
        if (geometry.isEmpty()) {
            return other;
        }
        if (other.isEmpty()) {
            return geometry;
        }
        this.checkNotGeometryCollection(geometry);
        this.checkNotGeometryCollection(other);
        org.locationtech.jts.geom.Geometry union = SnapIfNeededOverlayOp.overlayOp((org.locationtech.jts.geom.Geometry)JTS.to(geometry), (org.locationtech.jts.geom.Geometry)JTS.to(other), (int)2);
        return JTS.from(union, geometry.getCoordinateReferenceSystem());
    }

    @Override
    public <P extends C2D> Geometry<P> difference(Geometry<P> geometry, Geometry<P> other) {
        this.checkCompatibleCRS(geometry, other);
        if (geometry.isEmpty()) {
            return new Point<P>(geometry.getCoordinateReferenceSystem());
        }
        if (other.isEmpty()) {
            return geometry;
        }
        this.checkNotGeometryCollection(geometry);
        this.checkNotGeometryCollection(other);
        org.locationtech.jts.geom.Geometry difference = SnapIfNeededOverlayOp.overlayOp((org.locationtech.jts.geom.Geometry)JTS.to(geometry), (org.locationtech.jts.geom.Geometry)JTS.to(other), (int)3);
        return JTS.from(difference, geometry.getCoordinateReferenceSystem());
    }

    @Override
    public <P extends C2D> Geometry<P> symmetricDifference(Geometry<P> geometry, Geometry<P> other) {
        this.checkCompatibleCRS(geometry, other);
        if (geometry.isEmpty()) {
            return other;
        }
        if (other.isEmpty()) {
            return geometry;
        }
        this.checkNotGeometryCollection(geometry);
        this.checkNotGeometryCollection(other);
        org.locationtech.jts.geom.Geometry symDifference = SnapIfNeededOverlayOp.overlayOp((org.locationtech.jts.geom.Geometry)JTS.to(geometry), (org.locationtech.jts.geom.Geometry)JTS.to(other), (int)4);
        return JTS.from(symDifference, geometry.getCoordinateReferenceSystem());
    }

    @Override
    public <P extends C2D, G extends Geometry<P>> double length(G geometry) {
        return JTS.to(geometry).getLength();
    }

    @Override
    public <P extends C2D, G extends Geometry<P>> double area(G geometry) {
        return JTS.to(geometry).getArea();
    }

    @Override
    public <P extends C2D, G extends Geometry<P>> Point<P> centroid(G geometry) {
        return (Point)JTS.from((org.locationtech.jts.geom.Geometry)JTS.to(geometry).getCentroid());
    }
}

