/*
 * Decompiled with CFR 0.152.
 */
package freemarker.template;

import freemarker.core.Configurable;
import freemarker.core.Environment;
import freemarker.core.FMParser;
import freemarker.core.LibraryLoad;
import freemarker.core.Macro;
import freemarker.core.ParseException;
import freemarker.core.TemplateElement;
import freemarker.core.TextBlock;
import freemarker.core.TokenMgrError;
import freemarker.debug.impl.DebuggerService;
import freemarker.template.Configuration;
import freemarker.template.ObjectWrapper;
import freemarker.template.SimpleHash;
import freemarker.template.TemplateException;
import freemarker.template.TemplateHashModel;
import freemarker.template.TemplateNodeModel;
import java.io.BufferedReader;
import java.io.FilterReader;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class Template
extends Configurable {
    public static final String DEFAULT_NAMESPACE_PREFIX = "D";
    public static final String NO_NS_PREFIX = "N";
    private Map macros = new HashMap();
    private List imports = new Vector();
    private TemplateElement rootElement;
    private String encoding;
    private String defaultNS;
    private final String name;
    private final ArrayList lines = new ArrayList();
    private Map prefixToNamespaceURILookup = new HashMap();
    private Map namespaceURIToPrefixLookup = new HashMap();

    private Template(String name, Configuration cfg) {
        super(cfg != null ? cfg : Configuration.getDefaultConfiguration());
        this.name = name;
    }

    public Template(String name, Reader reader, Configuration cfg, String encoding) throws IOException {
        this(name, cfg);
        this.encoding = encoding;
        if (!(reader instanceof BufferedReader)) {
            reader = new BufferedReader(reader, 4096);
        }
        LineTableBuilder ltb = new LineTableBuilder(reader);
        try {
            try {
                FMParser parser = new FMParser(this, ltb, this.getConfiguration().getStrictSyntaxMode(), this.getConfiguration().getWhitespaceStripping(), this.getConfiguration().getTagSyntax(), this.getConfiguration().getParsedIncompatibleEnhancements());
                this.rootElement = parser.Root();
            }
            catch (TokenMgrError exc) {
                throw new ParseException("Token manager error: " + exc, 0, 0);
            }
        }
        catch (ParseException e) {
            e.setTemplateName(name);
            throw e;
        }
        finally {
            ltb.close();
        }
        DebuggerService.registerTemplate(this);
        this.namespaceURIToPrefixLookup = Collections.unmodifiableMap(this.namespaceURIToPrefixLookup);
        this.prefixToNamespaceURILookup = Collections.unmodifiableMap(this.prefixToNamespaceURILookup);
    }

    public Template(String name, Reader reader, Configuration cfg) throws IOException {
        this(name, reader, cfg, null);
    }

    public Template(String name, Reader reader) throws IOException {
        this(name, reader, null);
    }

    Template(String name, TemplateElement root, Configuration config) {
        this(name, config);
        this.rootElement = root;
        DebuggerService.registerTemplate(this);
    }

    public static Template getPlainTextTemplate(String name, String content, Configuration config) {
        Template template = new Template(name, config);
        TextBlock block = new TextBlock(content);
        template.rootElement = block;
        DebuggerService.registerTemplate(template);
        return template;
    }

    public void process(Object rootMap, Writer out) throws TemplateException, IOException {
        this.createProcessingEnvironment(rootMap, out, null).process();
    }

    public void process(Object rootMap, Writer out, ObjectWrapper wrapper, TemplateNodeModel rootNode) throws TemplateException, IOException {
        Environment env = this.createProcessingEnvironment(rootMap, out, wrapper);
        if (rootNode != null) {
            env.setCurrentVisitorNode(rootNode);
        }
        env.process();
    }

    public void process(Object rootMap, Writer out, ObjectWrapper wrapper) throws TemplateException, IOException {
        this.process(rootMap, out, wrapper, null);
    }

    public Environment createProcessingEnvironment(Object rootMap, Writer out, ObjectWrapper wrapper) throws TemplateException, IOException {
        TemplateHashModel root = null;
        if (rootMap instanceof TemplateHashModel) {
            root = (TemplateHashModel)rootMap;
        } else {
            if (wrapper == null) {
                wrapper = this.getObjectWrapper();
            }
            try {
                TemplateHashModel templateHashModel = root = rootMap != null ? (TemplateHashModel)wrapper.wrap(rootMap) : new SimpleHash(wrapper);
                if (root == null) {
                    throw new IllegalArgumentException(wrapper.getClass().getName() + " converted " + rootMap.getClass().getName() + " to null.");
                }
            }
            catch (ClassCastException e) {
                throw new IllegalArgumentException(wrapper.getClass().getName() + " could not convert " + rootMap.getClass().getName() + " to a TemplateHashModel.");
            }
        }
        return new Environment(this, root, out);
    }

    public Environment createProcessingEnvironment(Object rootMap, Writer out) throws TemplateException, IOException {
        return this.createProcessingEnvironment(rootMap, out, null);
    }

    public String toString() {
        StringWriter sw = new StringWriter();
        try {
            this.dump(sw);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe.getMessage());
        }
        return sw.toString();
    }

    public String getName() {
        return this.name;
    }

    public Configuration getConfiguration() {
        return (Configuration)this.getParent();
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void dump(PrintStream ps) {
        ps.print(this.rootElement.getCanonicalForm());
    }

    public void dump(Writer out) throws IOException {
        out.write(this.rootElement.getCanonicalForm());
    }

    public void addMacro(Macro macro) {
        this.macros.put(macro.getName(), macro);
    }

    public void addImport(LibraryLoad ll) {
        this.imports.add(ll);
    }

    public String getSource(int beginColumn, int beginLine, int endColumn, int endLine) {
        --beginColumn;
        --endColumn;
        --endLine;
        StringBuffer buf = new StringBuffer();
        for (int i = --beginLine; i <= endLine; ++i) {
            if (i >= this.lines.size()) continue;
            buf.append(this.lines.get(i));
        }
        int lastLineLength = this.lines.get(endLine).toString().length();
        int trailingCharsToDelete = lastLineLength - endColumn - 1;
        buf.delete(0, beginColumn);
        buf.delete(buf.length() - trailingCharsToDelete, buf.length());
        return buf.toString();
    }

    public TemplateElement getRootTreeNode() {
        return this.rootElement;
    }

    public Map getMacros() {
        return this.macros;
    }

    public List getImports() {
        return this.imports;
    }

    public void addPrefixNSMapping(String prefix, String nsURI) {
        if (nsURI.length() == 0) {
            throw new IllegalArgumentException("Cannot map empty string URI");
        }
        if (prefix.length() == 0) {
            throw new IllegalArgumentException("Cannot map empty string prefix");
        }
        if (prefix.equals(NO_NS_PREFIX)) {
            throw new IllegalArgumentException("The prefix: " + prefix + " cannot be registered, it is reserved for special internal use.");
        }
        if (this.prefixToNamespaceURILookup.containsKey(prefix)) {
            throw new IllegalArgumentException("The prefix: '" + prefix + "' was repeated. This is illegal.");
        }
        if (this.namespaceURIToPrefixLookup.containsKey(nsURI)) {
            throw new IllegalArgumentException("The namespace URI: " + nsURI + " cannot be mapped to 2 different prefixes.");
        }
        if (prefix.equals(DEFAULT_NAMESPACE_PREFIX)) {
            this.defaultNS = nsURI;
        } else {
            this.prefixToNamespaceURILookup.put(prefix, nsURI);
            this.namespaceURIToPrefixLookup.put(nsURI, prefix);
        }
    }

    public String getDefaultNS() {
        return this.defaultNS;
    }

    public String getNamespaceForPrefix(String prefix) {
        if (prefix.equals("")) {
            return this.defaultNS == null ? "" : this.defaultNS;
        }
        return (String)this.prefixToNamespaceURILookup.get(prefix);
    }

    public String getPrefixForNamespace(String nsURI) {
        if (nsURI == null) {
            return null;
        }
        if (nsURI.length() == 0) {
            return this.defaultNS == null ? "" : NO_NS_PREFIX;
        }
        if (nsURI.equals(this.defaultNS)) {
            return "";
        }
        return (String)this.namespaceURIToPrefixLookup.get(nsURI);
    }

    public String getPrefixedName(String localName, String nsURI) {
        if (nsURI == null || nsURI.length() == 0) {
            if (this.defaultNS != null) {
                return "N:" + localName;
            }
            return localName;
        }
        if (nsURI.equals(this.defaultNS)) {
            return localName;
        }
        String prefix = this.getPrefixForNamespace(nsURI);
        if (prefix == null) {
            return null;
        }
        return prefix + ":" + localName;
    }

    public List containingElements(int column, int line) {
        ArrayList<TemplateElement> elements = new ArrayList<TemplateElement>();
        TemplateElement element = this.rootElement;
        block0: while (element.contains(column, line)) {
            elements.add(element);
            Enumeration enumeration = element.children();
            while (enumeration.hasMoreElements()) {
                TemplateElement elem = (TemplateElement)enumeration.nextElement();
                if (!elem.contains(column, line)) continue;
                element = elem;
                continue block0;
            }
            break block0;
        }
        if (elements == null || elements.isEmpty()) {
            return null;
        }
        return elements;
    }

    public static class WrongEncodingException
    extends ParseException {
        private static final long serialVersionUID = 1L;
        public String specifiedEncoding;

        public WrongEncodingException(String specifiedEncoding) {
            this.specifiedEncoding = specifiedEncoding;
        }
    }

    private class LineTableBuilder
    extends FilterReader {
        StringBuffer lineBuf = new StringBuffer();
        int lastChar;

        LineTableBuilder(Reader r) {
            super(r);
        }

        public int read() throws IOException {
            int c = this.in.read();
            this.handleChar(c);
            return c;
        }

        public int read(char[] cbuf, int off, int len) throws IOException {
            int numchars = this.in.read(cbuf, off, len);
            for (int i = off; i < off + numchars; ++i) {
                char c = cbuf[i];
                this.handleChar(c);
            }
            return numchars;
        }

        public void close() throws IOException {
            if (this.lineBuf.length() > 0) {
                Template.this.lines.add(this.lineBuf.toString());
                this.lineBuf.setLength(0);
            }
            super.close();
        }

        private void handleChar(int c) {
            if (c == 10 || c == 13) {
                if (this.lastChar == 13 && c == 10) {
                    int lastIndex = Template.this.lines.size() - 1;
                    String lastLine = (String)Template.this.lines.get(lastIndex);
                    Template.this.lines.set(lastIndex, lastLine + '\n');
                } else {
                    this.lineBuf.append((char)c);
                    Template.this.lines.add(this.lineBuf.toString());
                    this.lineBuf.setLength(0);
                }
            } else if (c == 9) {
                int numSpaces = 8 - this.lineBuf.length() % 8;
                for (int i = 0; i < numSpaces; ++i) {
                    this.lineBuf.append(' ');
                }
            } else {
                this.lineBuf.append((char)c);
            }
            this.lastChar = c;
        }
    }
}

