/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.emf;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.TexturePaint;
import java.awt.Toolkit;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import org.freehep.graphics2d.PrintColor;
import org.freehep.graphics2d.font.FontEncoder;
import org.freehep.graphics2d.font.FontUtilities;
import org.freehep.graphicsio.AbstractPathConstructor;
import org.freehep.graphicsio.AbstractVectorGraphicsIO;
import org.freehep.graphicsio.emf.EMFConstants;
import org.freehep.graphicsio.emf.EMFHandleManager;
import org.freehep.graphicsio.emf.EMFOutputStream;
import org.freehep.graphicsio.emf.EMFPathConstructor;
import org.freehep.graphicsio.emf.gdi.AlphaBlend;
import org.freehep.graphicsio.emf.gdi.BeginPath;
import org.freehep.graphicsio.emf.gdi.CreateBrushIndirect;
import org.freehep.graphicsio.emf.gdi.DeleteObject;
import org.freehep.graphicsio.emf.gdi.EOF;
import org.freehep.graphicsio.emf.gdi.EndPath;
import org.freehep.graphicsio.emf.gdi.ExtCreateFontIndirectW;
import org.freehep.graphicsio.emf.gdi.ExtCreatePen;
import org.freehep.graphicsio.emf.gdi.ExtLogFontW;
import org.freehep.graphicsio.emf.gdi.ExtLogPen;
import org.freehep.graphicsio.emf.gdi.ExtTextOutW;
import org.freehep.graphicsio.emf.gdi.FillPath;
import org.freehep.graphicsio.emf.gdi.LogBrush32;
import org.freehep.graphicsio.emf.gdi.ModifyWorldTransform;
import org.freehep.graphicsio.emf.gdi.RestoreDC;
import org.freehep.graphicsio.emf.gdi.SaveDC;
import org.freehep.graphicsio.emf.gdi.SelectClipPath;
import org.freehep.graphicsio.emf.gdi.SelectObject;
import org.freehep.graphicsio.emf.gdi.SetBkMode;
import org.freehep.graphicsio.emf.gdi.SetMapMode;
import org.freehep.graphicsio.emf.gdi.SetMiterLimit;
import org.freehep.graphicsio.emf.gdi.SetPolyFillMode;
import org.freehep.graphicsio.emf.gdi.SetTextAlign;
import org.freehep.graphicsio.emf.gdi.SetTextColor;
import org.freehep.graphicsio.emf.gdi.SetViewportExtEx;
import org.freehep.graphicsio.emf.gdi.SetViewportOrgEx;
import org.freehep.graphicsio.emf.gdi.SetWindowExtEx;
import org.freehep.graphicsio.emf.gdi.SetWindowOrgEx;
import org.freehep.graphicsio.emf.gdi.SetWorldTransform;
import org.freehep.graphicsio.emf.gdi.StrokeAndFillPath;
import org.freehep.graphicsio.emf.gdi.StrokePath;
import org.freehep.graphicsio.emf.gdi.TextW;
import org.freehep.graphicsio.font.FontTable;
import org.freehep.util.UserProperties;
import org.freehep.util.images.ImageUtilities;

public class EMFGraphics2D
extends AbstractVectorGraphicsIO
implements EMFConstants {
    public static final String version = "$Revision$";
    private EMFHandleManager handleManager;
    private int penHandle;
    private int brushHandle;
    private Rectangle imageBounds;
    private OutputStream ros;
    private EMFOutputStream os;
    private Color textColor = null;
    private Color penColor = null;
    private Color brushColor = null;
    private Map fontTable;
    private Map unitFontTable;
    private EMFPathConstructor pathConstructor;
    private boolean evenOdd;
    private static final Rectangle dummy = new Rectangle(0, 0, 0, 0);
    private static final String rootKey = (class$org$freehep$graphicsio$emf$EMFGraphics2D == null ? (class$org$freehep$graphicsio$emf$EMFGraphics2D = EMFGraphics2D.class$("org.freehep.graphicsio.emf.EMFGraphics2D")) : class$org$freehep$graphicsio$emf$EMFGraphics2D).getName();
    public static final String TRANSPARENT = rootKey + "." + "Transparent";
    public static final String BACKGROUND = rootKey + "." + "Background";
    public static final String BACKGROUND_COLOR = rootKey + "." + "BackgroundColor";
    private static final UserProperties defaultProperties = new UserProperties();
    static /* synthetic */ Class class$org$freehep$graphicsio$emf$EMFGraphics2D;

    public static Properties getDefaultProperties() {
        return defaultProperties;
    }

    public static void setDefaultProperties(Properties newProperties) {
        defaultProperties.setProperties(newProperties);
    }

    public EMFGraphics2D(File file, Dimension size) throws FileNotFoundException {
        this((OutputStream)new FileOutputStream(file), size);
    }

    public EMFGraphics2D(File file, Component component) throws FileNotFoundException {
        this((OutputStream)new FileOutputStream(file), component);
    }

    public EMFGraphics2D(OutputStream os, Dimension size) {
        super(size, false);
        this.imageBounds = new Rectangle(0, 0, size.width, size.height);
        this.init(os);
    }

    public EMFGraphics2D(OutputStream os, Component component) {
        super(component, false);
        this.imageBounds = new Rectangle(0, 0, this.getSize().width, this.getSize().height);
        this.init(os);
    }

    private void init(OutputStream os) {
        this.fontTable = new HashMap();
        this.unitFontTable = new HashMap();
        this.evenOdd = false;
        this.handleManager = new EMFHandleManager();
        this.ros = os;
        this.initProperties((Properties)defaultProperties);
    }

    protected EMFGraphics2D(EMFGraphics2D graphics, boolean doRestoreOnDispose) {
        super((AbstractVectorGraphicsIO)graphics, doRestoreOnDispose);
        this.os = graphics.os;
        this.imageBounds = graphics.imageBounds;
        this.handleManager = graphics.handleManager;
        this.fontTable = graphics.fontTable;
        this.unitFontTable = graphics.unitFontTable;
        this.pathConstructor = graphics.pathConstructor;
        this.evenOdd = graphics.evenOdd;
        this.textColor = graphics.textColor;
        this.penColor = graphics.penColor;
        this.brushColor = graphics.brushColor;
    }

    public void writeHeader() throws IOException {
        this.ros = new BufferedOutputStream(this.ros);
        Dimension device = this.isDeviceIndependent() ? new Dimension(1024, 768) : Toolkit.getDefaultToolkit().getScreenSize();
        String producer = this.getClass().getName();
        if (!this.isDeviceIndependent()) {
            producer = producer + " " + version.substring(1, version.length() - 1);
        }
        this.os = new EMFOutputStream(this.ros, this.imageBounds, this.handleManager, this.getCreator(), producer, device);
        this.pathConstructor = new EMFPathConstructor(this.os, this.imageBounds);
        Point orig = new Point(this.imageBounds.x, this.imageBounds.y);
        Dimension size = new Dimension(this.imageBounds.width, this.imageBounds.height);
        this.os.writeTag(new SetMapMode(8));
        this.os.writeTag(new SetWindowOrgEx(orig));
        this.os.writeTag(new SetWindowExtEx(size));
        this.os.writeTag(new SetViewportOrgEx(orig));
        this.os.writeTag(new SetViewportExtEx(size));
        this.os.writeTag(new SetTextAlign(24));
        this.os.writeTag(new SetTextColor(this.getColor()));
        this.os.writeTag(new SetPolyFillMode(2));
    }

    public void writeGraphicsState() throws IOException {
        super.writeGraphicsState();
        AffineTransform n = AffineTransform.getScaleInstance(0.05, 0.05);
        this.os.writeTag(new SetWorldTransform(n));
    }

    public void writeBackground() throws IOException {
        if (this.isProperty(TRANSPARENT)) {
            this.setBackground(null);
            this.os.writeTag(new SetBkMode(1));
        } else if (this.isProperty(BACKGROUND)) {
            this.os.writeTag(new SetBkMode(2));
            this.setBackground(this.getPropertyColor(BACKGROUND_COLOR));
            this.clearRect(0.0, 0.0, this.getSize().width, this.getSize().height);
        } else {
            this.os.writeTag(new SetBkMode(2));
            this.setBackground(this.getComponent() != null ? this.getComponent().getBackground() : Color.WHITE);
            this.clearRect(0.0, 0.0, this.getSize().width, this.getSize().height);
        }
    }

    public void writeTrailer() throws IOException {
        int handle;
        while ((handle = this.handleManager.highestHandleInUse()) >= 0) {
            this.os.writeTag(new DeleteObject(handle));
            this.handleManager.freeHandle(handle);
        }
        this.os.writeTag(new EOF());
    }

    public void closeStream() throws IOException {
        this.os.close();
    }

    public Graphics create() {
        try {
            this.writeGraphicsSave();
        }
        catch (IOException e) {
            this.handleException(e);
        }
        return new EMFGraphics2D(this, true);
    }

    public Graphics create(double x, double y, double width, double height) {
        try {
            this.writeGraphicsSave();
        }
        catch (IOException e) {
            this.handleException(e);
        }
        EMFGraphics2D graphics = new EMFGraphics2D(this, true);
        graphics.translate(x, y);
        graphics.clipRect(0.0, 0.0, width, height);
        return graphics;
    }

    protected void writeGraphicsSave() throws IOException {
        this.os.writeTag(new SaveDC());
    }

    protected void writeGraphicsRestore() throws IOException {
        if (this.penHandle != 0) {
            this.os.writeTag(new DeleteObject(this.handleManager.freeHandle(this.penHandle)));
        }
        if (this.brushHandle != 0) {
            this.os.writeTag(new DeleteObject(this.handleManager.freeHandle(this.brushHandle)));
        }
        this.os.writeTag(new RestoreDC());
    }

    public void draw(Shape shape) {
        try {
            if (this.getStroke() instanceof BasicStroke) {
                this.writePen((BasicStroke)this.getStroke(), this.getColor());
                this.writePath(shape);
                this.os.writeTag(new StrokePath(this.imageBounds));
            } else {
                this.writeBrush(this.getColor());
                this.writePath(this.getStroke().createStrokedShape(shape));
                this.os.writeTag(new FillPath(this.imageBounds));
            }
        }
        catch (IOException e) {
            this.handleException(e);
        }
    }

    public void fill(Shape shape) {
        try {
            if (this.getPaint() instanceof Color) {
                this.writeBrush(this.getColor());
                this.writePath(shape);
                this.os.writeTag(new FillPath(this.imageBounds));
            } else {
                this.fill(shape, this.getPaint());
            }
        }
        catch (IOException e) {
            this.handleException(e);
        }
    }

    public void fillAndDraw(Shape shape, Color fillColor) {
        try {
            if (this.getPaint() instanceof Color) {
                this.writePen((BasicStroke)this.getStroke(), this.getColor());
                this.writeBrush(fillColor);
                this.writePath(shape);
                this.os.writeTag(new StrokeAndFillPath(this.imageBounds));
            } else {
                this.fill(shape, this.getPaint());
                this.draw(shape);
            }
        }
        catch (IOException e) {
            this.handleException(e);
        }
    }

    public void copyArea(int x, int y, int width, int height, int dx, int dy) {
        this.writeWarning(this.getClass() + ": copyArea(int, int, int, int, int, int) not implemented.");
    }

    protected void writeImage(RenderedImage image, AffineTransform xform, Color bkg) throws IOException {
        this.os.writeTag(new SaveDC());
        AffineTransform imageTransform = new AffineTransform(1.0, 0.0, 0.0, -1.0, 0.0, (double)image.getHeight());
        imageTransform.preConcatenate(xform);
        this.writeTransform(imageTransform);
        BufferedImage bufferedImage = ImageUtilities.createBufferedImage((RenderedImage)image, null, null);
        AlphaBlend alphaBlend = new AlphaBlend(this.imageBounds, this.toUnit(0.0), this.toUnit(0.0), this.toUnit(image.getWidth()), this.toUnit(image.getHeight()), new AffineTransform(), bufferedImage, bkg);
        this.os.writeTag(alphaBlend);
        this.os.writeTag(new RestoreDC());
    }

    public void writeString(String string, double x, double y) throws IOException {
        Color color;
        Paint paint = this.getPaint();
        if (paint instanceof Color) {
            color = (Color)paint;
        } else if (paint instanceof GradientPaint) {
            GradientPaint gp = (GradientPaint)paint;
            color = PrintColor.mixColor((Color)gp.getColor1(), (Color)gp.getColor2());
        } else {
            Color bkg = this.getBackground();
            color = bkg == null ? Color.BLACK : PrintColor.invert((Color)bkg);
        }
        if (!color.equals(this.textColor)) {
            this.textColor = color;
            this.os.writeTag(new SetTextColor(this.textColor));
        }
        Hashtable attributes = FontUtilities.getAttributes((Font)this.getFont());
        FontTable.normalize((Map)attributes);
        Font font = new Font(attributes);
        Font unitFont = (Font)this.unitFontTable.get(font);
        Integer fontIndex = (Integer)this.fontTable.get(font);
        if (fontIndex == null) {
            String fontName = font.getName();
            string = FontEncoder.getEncodedString((String)string, (String)fontName);
            String windowsFontName = FontUtilities.getWindowsFontName((String)fontName);
            unitFont = new Font(windowsFontName, font.getStyle(), font.getSize());
            unitFont = unitFont.deriveFont(font.getSize2D() * 1.0f * 20.0f);
            this.unitFontTable.put(font, unitFont);
            ExtLogFontW logFontW = new ExtLogFontW(unitFont);
            int handle = this.handleManager.getHandle();
            this.os.writeTag(new ExtCreateFontIndirectW(handle, logFontW));
            fontIndex = new Integer(handle);
            this.fontTable.put(font, fontIndex);
        }
        this.os.writeTag(new SelectObject(fontIndex));
        int[] widths = new int[string.length()];
        for (int i = 0; i < widths.length; ++i) {
            double w = unitFont.getStringBounds(string, i, i + 1, this.getFontRenderContext()).getWidth();
            widths[i] = (int)w;
        }
        this.translate(x, y);
        AffineTransform t = font.getTransform();
        if (!t.isIdentity()) {
            this.writeGraphicsSave();
            this.writeTransform(t);
        }
        TextW text = new TextW(new Point(0, 0), string, 0, dummy, widths);
        this.os.writeTag(new ExtTextOutW(this.imageBounds, 2, 1.0f, 1.0f, text));
        if (!t.isIdentity()) {
            this.writeGraphicsRestore();
        }
        this.translate(-x, -y);
    }

    protected void writeTransform(AffineTransform t) throws IOException {
        AffineTransform n = new AffineTransform(t.getScaleX(), t.getShearY(), t.getShearX(), t.getScaleY(), t.getTranslateX() * 1.0 * 20.0, t.getTranslateY() * 1.0 * 20.0);
        this.os.writeTag(new ModifyWorldTransform(n, 2));
    }

    protected void writeSetTransform(AffineTransform t) throws IOException {
        AffineTransform n = AffineTransform.getScaleInstance(0.05, 0.05);
        this.os.writeTag(new SetWorldTransform(n));
        this.writeTransform(t);
    }

    protected void writeSetClip(Shape s) throws IOException {
        if (!this.isProperty(AbstractVectorGraphicsIO.CLIP)) {
            return;
        }
        if (s == null && this.imageBounds != null) {
            s = new Rectangle(this.imageBounds);
            AffineTransform at = this.getTransform();
            if (at != null) {
                s = at.createTransformedShape(s);
            }
        }
        this.writePath(s);
        this.os.writeTag(new SelectClipPath(5));
    }

    protected void writeClip(Shape s) throws IOException {
        if (s == null || !this.isProperty(AbstractVectorGraphicsIO.CLIP)) {
            return;
        }
        this.writePath(s);
        this.os.writeTag(new SelectClipPath(1));
    }

    public void writeStroke(Stroke stroke) throws IOException {
        if (stroke instanceof BasicStroke) {
            this.writePen((BasicStroke)stroke, this.getColor());
        }
    }

    public void setPaintMode() {
        this.writeWarning(this.getClass() + ": setPaintMode() not implemented.");
    }

    public void setXORMode(Color c1) {
        this.writeWarning(this.getClass() + ": setXORMode(Color) not implemented.");
    }

    protected void writePaint(Color p) throws IOException {
    }

    protected void writePaint(GradientPaint p) throws IOException {
    }

    protected void writePaint(TexturePaint p) throws IOException {
    }

    protected void writePaint(Paint p) throws IOException {
    }

    protected void writeFont(Font font) throws IOException {
    }

    public GraphicsConfiguration getDeviceConfiguration() {
        this.writeWarning(this.getClass() + ": getDeviceConfiguration() not implemented.");
        return null;
    }

    public void writeComment(String comment) throws IOException {
        this.writeWarning(this.getClass() + ": writeComment(String) not implemented.");
    }

    public String toString() {
        return "EMFGraphics2D";
    }

    protected Shape createShape(double[] xPoints, double[] yPoints, int nPoints, boolean close) {
        GeneralPath path = new GeneralPath(0);
        if (nPoints > 0) {
            path.moveTo((float)xPoints[0], (float)yPoints[0]);
            double lastX = xPoints[0];
            double lastY = yPoints[0];
            if (close && Math.abs(xPoints[nPoints - 1] - lastX) < 1.0 && Math.abs(yPoints[nPoints - 1] - lastY) < 1.0) {
                --nPoints;
            }
            for (int i = 1; i < nPoints; ++i) {
                if (!(Math.abs(xPoints[i] - lastX) > 1.0) && !(Math.abs(yPoints[i] - lastY) > 1.0)) continue;
                path.lineTo((float)xPoints[i], (float)yPoints[i]);
                lastX = xPoints[i];
                lastY = yPoints[i];
            }
            if (close) {
                path.closePath();
            }
        }
        return path;
    }

    private boolean writePath(Shape shape) throws IOException {
        boolean eo = AbstractPathConstructor.isEvenOdd((Shape)shape);
        if (eo != this.evenOdd) {
            this.evenOdd = eo;
            this.os.writeTag(new SetPolyFillMode(this.evenOdd ? 1 : 2));
        }
        this.os.writeTag(new BeginPath());
        this.pathConstructor.addPath(shape);
        this.os.writeTag(new EndPath());
        return this.evenOdd;
    }

    private void writePen(BasicStroke stroke, Color color) throws IOException {
        if (color.equals(this.penColor) && stroke.equals(this.getStroke())) {
            return;
        }
        this.penColor = color;
        int style = 65536;
        switch (stroke.getEndCap()) {
            case 0: {
                style |= 0x200;
                break;
            }
            case 1: {
                style |= 0;
                break;
            }
            case 2: {
                style |= 0x100;
            }
        }
        switch (stroke.getLineJoin()) {
            case 0: {
                style |= 0x2000;
                break;
            }
            case 1: {
                style |= 0;
                break;
            }
            case 2: {
                style |= 0x1000;
            }
        }
        float[] dashArray = stroke.getDashArray();
        int[] dash = new int[dashArray != null ? dashArray.length : 0];
        style |= dash.length == 0 ? 0 : 7;
        for (int i = 0; i < dash.length; ++i) {
            dash[i] = this.toUnit(dashArray[i]);
        }
        int brushStyle = color.getAlpha() == 0 ? 1 : 0;
        ExtLogPen pen = new ExtLogPen(style, this.toUnit(stroke.getLineWidth()), brushStyle, this.getPrintColor(color), 0, dash);
        if (this.penHandle != 0) {
            this.os.writeTag(new DeleteObject(this.penHandle));
        } else {
            this.penHandle = this.handleManager.getHandle();
        }
        this.os.writeTag(new ExtCreatePen(this.penHandle, pen));
        this.os.writeTag(new SelectObject(this.penHandle));
        if (!(this.getStroke() instanceof BasicStroke) || ((BasicStroke)this.getStroke()).getMiterLimit() != stroke.getMiterLimit()) {
            this.os.writeTag(new SetMiterLimit(this.toUnit(stroke.getMiterLimit())));
        }
    }

    private void writeBrush(Color color) throws IOException {
        if (color.equals(this.brushColor)) {
            return;
        }
        this.brushColor = color;
        int brushStyle = color.getAlpha() == 0 ? 1 : 0;
        LogBrush32 brush = new LogBrush32(brushStyle, this.getPrintColor(color), 0);
        if (this.brushHandle != 0) {
            this.os.writeTag(new DeleteObject(this.brushHandle));
        } else {
            this.brushHandle = this.handleManager.getHandle();
        }
        this.os.writeTag(new CreateBrushIndirect(this.brushHandle, brush));
        this.os.writeTag(new SelectObject(this.brushHandle));
    }

    private int toUnit(double d) {
        return (int)Math.floor(d * 1.0 * 20.0);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        defaultProperties.setProperty(TRANSPARENT, true);
        defaultProperties.setProperty(BACKGROUND, false);
        defaultProperties.setProperty(BACKGROUND_COLOR, Color.GRAY);
        defaultProperties.setProperty(AbstractVectorGraphicsIO.CLIP, true);
        defaultProperties.setProperty(AbstractVectorGraphicsIO.TEXT_AS_SHAPES, false);
    }
}

