/*
 * Decompiled with CFR 0.152.
 */
package org.fortasoft.maven.plugin.gradle;

import groovy.lang.Binding;
import groovy.lang.GroovyShell;
import java.io.File;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Map;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.fortasoft.maven.plugin.gradle.GradleArgs;
import org.gradle.tooling.BuildLauncher;
import org.gradle.tooling.GradleConnectionException;
import org.gradle.tooling.GradleConnector;
import org.gradle.tooling.ProgressEvent;
import org.gradle.tooling.ProgressListener;
import org.gradle.tooling.ProjectConnection;
import org.gradle.tooling.ResultHandler;
import org.slf4j.impl.NewMojoLogger;

@Mojo(name="invoke")
public class GradleMojo
extends AbstractMojo {
    public static final String PROP_PREFIX = "gradle.prop.";
    public static final String SYS_PREFIX = "gradle.sys.";
    @Parameter(defaultValue="2.13", required=true)
    private String gradleVersion;
    @Parameter(defaultValue="${tasks}")
    private String[] tasks;
    @Parameter(defaultValue="${task}")
    private String task;
    @Parameter(defaultValue="${project.basedir}")
    private File gradleProjectDirectory;
    @Parameter
    private String checkInvokeScript;
    @Parameter
    private String[] args;
    @Parameter
    private String[] jvmArgs;
    @Parameter
    private File javaHome;
    @Parameter(defaultValue="${project.basedir}", required=true)
    private File mavenBaseDir;
    @Parameter
    private String gradleDistribution;
    @Parameter
    private File gradleUserHomeDir;
    @Parameter
    private File gradleInstallationDir;
    @Parameter(defaultValue="${session}", readonly=true)
    private MavenSession session;
    protected GradleConnectionException gradleConnectionException;
    volatile boolean invocationComplete = false;

    File getGradleProjectDirectory() {
        return this.gradleProjectDirectory;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    String[] getTasks() throws MojoFailureException {
        if (this.task != null) {
            if (this.tasks == null) return new String[]{this.task};
            throw new MojoFailureException("<task> and <tasks> are mutually exclusive");
        }
        if (this.tasks == null) throw new MojoFailureException("<task> or <tasks> elements are mandatory");
        if (this.tasks.length <= 0) throw new MojoFailureException("No <task> elements specified within <tasks>");
        return this.tasks;
    }

    protected boolean shouldExecute() throws MojoFailureException {
        boolean shouldExecute = true;
        if (this.checkInvokeScript != null && this.checkInvokeScript.trim().length() > 0) {
            Binding b = new Binding();
            b.setVariable("mavenBaseDir", (Object)this.mavenBaseDir);
            GroovyShell gs = new GroovyShell(b);
            Object rval = gs.evaluate(this.checkInvokeScript);
            if (rval != null && rval instanceof Boolean) {
                Boolean boolRval = (Boolean)rval;
                shouldExecute = boolRval;
            } else {
                throw new MojoFailureException("checkScript must return boolean");
            }
        }
        return shouldExecute;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        ProjectConnection connection = null;
        try {
            String[] finalArgs;
            NewMojoLogger.attachMojo(this);
            if (!this.shouldExecute()) {
                return;
            }
            GradleConnector c = GradleConnector.newConnector();
            this.getLog().info((CharSequence)("jvmArgs: " + this.args));
            this.getLog().info((CharSequence)("gradleProjectDirectory: " + this.getGradleProjectDirectory().getAbsolutePath()));
            c = c.useGradleVersion(this.gradleVersion).forProjectDirectory(this.getGradleProjectDirectory());
            if (this.gradleInstallationDir != null) {
                this.getLog().info((CharSequence)("gradleInstallation: " + this.gradleInstallationDir.getAbsolutePath()));
                c = c.useInstallation(this.gradleInstallationDir);
            }
            if (this.gradleUserHomeDir != null) {
                this.getLog().info((CharSequence)("gradleUserHome: " + this.gradleUserHomeDir.getAbsolutePath()));
                c = c.useGradleUserHomeDir(this.gradleUserHomeDir);
            }
            if (this.gradleDistribution != null) {
                this.getLog().info((CharSequence)("gradleDistributionUri: " + this.gradleDistribution));
                c = c.useDistribution(new URI(this.gradleDistribution));
            }
            connection = c.connect();
            BuildLauncher launcher = connection.newBuild();
            launcher.forTasks(this.getTasks());
            launcher.setStandardOutput((OutputStream)System.out);
            launcher.setStandardError((OutputStream)System.err);
            if (this.jvmArgs != null && this.jvmArgs.length > 0) {
                launcher.setJvmArguments(this.jvmArgs);
            }
            if ((finalArgs = this.buildFinalArgs(this.args)) != null && finalArgs.length > 0) {
                launcher.withArguments(finalArgs);
            }
            if (this.javaHome != null) {
                launcher.setJavaHome(this.javaHome);
            }
            launcher.addProgressListener((ProgressListener)new MyProgressListener());
            launcher.run((ResultHandler)new MyResultHandler());
            this.waitForGradleToComplete();
            if (this.gradleConnectionException != null) {
                throw new MojoFailureException((Object)this.gradleConnectionException, this.gradleConnectionException.toString(), this.gradleConnectionException.toString());
            }
        }
        catch (URISyntaxException e) {
            throw new MojoFailureException("gradleDistribution is not in URI syntax");
        }
        finally {
            if (connection != null) {
                connection.close();
            }
            NewMojoLogger.detachMojo();
        }
    }

    private String[] buildFinalArgs(String[] args) {
        boolean offline;
        ArrayList<String> argList = new ArrayList<String>();
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                argList.add(args[i]);
            }
        }
        if ((offline = this.session.getSettings().isOffline()) && !GradleArgs.OFFLINE.exists(argList)) {
            argList.add(GradleArgs.OFFLINE.getLongValue());
        }
        for (Map.Entry<Object, Object> entry : System.getProperties().entrySet()) {
            String arg;
            String key = (String)entry.getKey();
            if (key.startsWith(PROP_PREFIX)) {
                arg = "-P" + key.substring(PROP_PREFIX.length()) + "=" + entry.getValue().toString();
                this.getLog().info((CharSequence)("additional argument: " + arg));
                argList.add(arg);
                continue;
            }
            if (!key.startsWith(SYS_PREFIX)) continue;
            arg = "-D" + key.substring(SYS_PREFIX.length()) + "=" + entry.getValue().toString();
            this.getLog().info((CharSequence)("additional argument: " + arg));
            argList.add(arg);
        }
        return argList.toArray(new String[argList.size()]);
    }

    synchronized void waitForGradleToComplete() {
        while (!this.invocationComplete) {
            try {
                ((Object)((Object)this)).wait(50L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.getLog().debug((CharSequence)"waiting....");
        }
    }

    class MyResultHandler
    implements ResultHandler<Void> {
        MyResultHandler() {
        }

        public void onComplete(Void arg0) {
            GradleMojo.this.invocationComplete = true;
            GradleMojo.this.getLog().info((CharSequence)"gradle execution complete");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onFailure(GradleConnectionException arg0) {
            MyResultHandler myResultHandler = this;
            synchronized (myResultHandler) {
                GradleMojo.this.invocationComplete = true;
            }
            GradleMojo.this.gradleConnectionException = arg0;
        }
    }

    class MyProgressListener
    implements ProgressListener {
        MyProgressListener() {
        }

        public void statusChanged(ProgressEvent arg0) {
            GradleMojo.this.getLog().info((CharSequence)arg0.getDescription());
        }
    }
}

