/*
 * Decompiled with CFR 0.152.
 */
package org.fortasoft.maven.plugin.gradle;

import groovy.lang.Binding;
import groovy.lang.GroovyShell;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.gradle.tooling.BuildLauncher;
import org.gradle.tooling.GradleConnectionException;
import org.gradle.tooling.GradleConnector;
import org.gradle.tooling.ProgressEvent;
import org.gradle.tooling.ProgressListener;
import org.gradle.tooling.ProjectConnection;
import org.gradle.tooling.ResultHandler;
import org.slf4j.impl.NewMojoLogger;

public class GradleMojo
extends AbstractMojo {
    private String gradleVersion;
    private String[] tasks;
    private String task;
    private File gradleProjectDirectory;
    private String checkInvokeScript;
    private String[] args;
    private String[] jvmArgs;
    private File javaHome;
    private File mavenBaseDir;
    private String gradleDistribution;
    private File gradleUserHomeDir;
    private File gradleInstallationDir;
    protected GradleConnectionException gradleConnectionException;
    volatile boolean invocationComplete = false;

    File getGradleProjectDirectory() {
        return this.gradleProjectDirectory;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    String[] getTasks() throws MojoFailureException {
        if (this.task != null) {
            if (this.tasks == null) return new String[]{this.task};
            throw new MojoFailureException("<task> and <tasks> are mutually exclusive");
        }
        if (this.tasks == null) throw new MojoFailureException("<task> or <tasks> elements are mandatory");
        if (this.tasks.length <= 0) throw new MojoFailureException("No <task> elements specified within <tasks>");
        return this.tasks;
    }

    protected boolean shouldExecute() throws MojoFailureException {
        boolean shouldExecute = true;
        if (this.checkInvokeScript != null && this.checkInvokeScript.trim().length() > 0) {
            Binding b = new Binding();
            b.setVariable("mavenBaseDir", (Object)this.mavenBaseDir);
            GroovyShell gs = new GroovyShell(b);
            Object rval = gs.evaluate(this.checkInvokeScript);
            if (rval != null && rval instanceof Boolean) {
                Boolean boolRval = (Boolean)rval;
                shouldExecute = boolRval;
            } else {
                throw new MojoFailureException("checkScript must return boolean");
            }
        }
        return shouldExecute;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        ProjectConnection connection = null;
        try {
            NewMojoLogger.attachMojo(this);
            if (!this.shouldExecute()) {
                return;
            }
            GradleConnector c = GradleConnector.newConnector();
            this.getLog().info((CharSequence)("jvmArgs: " + this.args));
            this.getLog().info((CharSequence)("gradleProjectDirectory: " + this.getGradleProjectDirectory().getAbsolutePath()));
            c = c.useGradleVersion(this.gradleVersion).forProjectDirectory(this.getGradleProjectDirectory());
            if (this.gradleInstallationDir != null) {
                this.getLog().info((CharSequence)("gradleInstallation: " + this.gradleInstallationDir.getAbsolutePath()));
                c = c.useInstallation(this.gradleInstallationDir);
            }
            if (this.gradleUserHomeDir != null) {
                this.getLog().info((CharSequence)("gradleUserHome: " + this.gradleUserHomeDir.getAbsolutePath()));
                c = c.useGradleUserHomeDir(this.gradleUserHomeDir);
            }
            if (this.gradleDistribution != null) {
                this.getLog().info((CharSequence)("gradleDistributionUri: " + this.gradleDistribution));
                c = c.useDistribution(new URI(this.gradleDistribution));
            }
            connection = c.connect();
            BuildLauncher launcher = connection.newBuild();
            launcher.forTasks(this.getTasks());
            if (this.jvmArgs != null && this.jvmArgs.length > 0) {
                launcher.setJvmArguments(this.jvmArgs);
            }
            if (this.args != null && this.args.length > 0) {
                launcher.withArguments(this.args);
            }
            if (this.javaHome != null) {
                launcher.setJavaHome(this.javaHome);
            }
            launcher.addProgressListener((ProgressListener)new MyProgressListener());
            launcher.run((ResultHandler)new MyResultHandler());
            this.waitForGradleToComplete();
            if (this.gradleConnectionException != null) {
                throw new MojoFailureException((Object)this.gradleConnectionException, this.gradleConnectionException.toString(), this.gradleConnectionException.toString());
            }
        }
        catch (URISyntaxException e) {
            throw new MojoFailureException("gradleDistribution is not in URI syntax");
        }
        finally {
            if (connection != null) {
                connection.close();
            }
            NewMojoLogger.detachMojo();
        }
    }

    synchronized void waitForGradleToComplete() {
        while (!this.invocationComplete) {
            try {
                ((Object)((Object)this)).wait(50L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.getLog().debug((CharSequence)"waiting....");
        }
    }

    class MyResultHandler
    implements ResultHandler<Void> {
        MyResultHandler() {
        }

        public void onComplete(Void arg0) {
            GradleMojo.this.invocationComplete = true;
            GradleMojo.this.getLog().info((CharSequence)"gradle execution complete");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onFailure(GradleConnectionException arg0) {
            MyResultHandler myResultHandler = this;
            synchronized (myResultHandler) {
                GradleMojo.this.invocationComplete = true;
            }
            GradleMojo.this.gradleConnectionException = arg0;
        }
    }

    class MyProgressListener
    implements ProgressListener {
        MyProgressListener() {
        }

        public void statusChanged(ProgressEvent arg0) {
            GradleMojo.this.getLog().info((CharSequence)arg0.getDescription());
        }
    }
}

