/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.database.snowflake;

import java.io.IOException;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.internal.parser.Parser;
import org.flywaydb.core.internal.parser.ParserContext;
import org.flywaydb.core.internal.parser.ParsingContext;
import org.flywaydb.core.internal.parser.PeekingReader;
import org.flywaydb.core.internal.parser.Token;
import org.flywaydb.core.internal.parser.TokenType;

public class SnowflakeParser
extends Parser {
    private static final String ALTERNATIVE_QUOTE = "$$";
    private static final String ALTERNATIVE_QUOTE_SCRIPT = "DECLARE";

    public SnowflakeParser(Configuration configuration, ParsingContext parsingContext) {
        super(configuration, parsingContext, 7);
    }

    @Override
    protected boolean isAlternativeStringLiteral(String peek) {
        if (peek.startsWith(ALTERNATIVE_QUOTE) || peek.toUpperCase().startsWith(ALTERNATIVE_QUOTE_SCRIPT)) {
            return true;
        }
        return super.isAlternativeStringLiteral(peek);
    }

    @Override
    protected Token handleAlternativeStringLiteral(PeekingReader reader, ParserContext context, int pos, int line, int col) throws IOException {
        String text;
        String alternativeQuoteOpen = ALTERNATIVE_QUOTE;
        String alternativeQuoteEnd = ALTERNATIVE_QUOTE;
        if (reader.peek(ALTERNATIVE_QUOTE_SCRIPT)) {
            alternativeQuoteOpen = "BEGIN";
            alternativeQuoteEnd = "END";
            reader.swallowUntilExcluding(alternativeQuoteOpen);
            text = this.readBetweenRecursive(reader, alternativeQuoteOpen, alternativeQuoteEnd);
        } else {
            reader.swallow(alternativeQuoteOpen.length());
            text = reader.readUntilExcluding(alternativeQuoteOpen, alternativeQuoteEnd);
            reader.swallow(alternativeQuoteEnd.length());
        }
        return new Token(TokenType.STRING, pos, line, col, text, text, context.getParensDepth());
    }

    @Override
    protected boolean isSingleLineComment(String peek, ParserContext context, int col) {
        return peek.startsWith("--") || peek.startsWith("//");
    }

    private String readBetweenRecursive(PeekingReader reader, String prefix, String suffix) throws IOException {
        StringBuilder result = new StringBuilder();
        reader.swallow(prefix.length());
        while (!reader.peek(suffix)) {
            result.append(reader.readUntilExcluding(prefix, suffix));
            if (!reader.peek(prefix)) continue;
            result.append(prefix).append(this.readBetweenRecursive(reader, prefix, suffix)).append(suffix);
        }
        reader.swallow(suffix.length());
        return result.toString();
    }
}

