/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.database.cockroachdb;

import java.sql.SQLException;
import org.flywaydb.core.internal.database.InsertRowLock;
import org.flywaydb.core.internal.database.base.Table;
import org.flywaydb.core.internal.database.cockroachdb.CockroachDBDatabase;
import org.flywaydb.core.internal.database.cockroachdb.CockroachDBRetryingStrategy;
import org.flywaydb.core.internal.database.cockroachdb.CockroachDBSchema;
import org.flywaydb.core.internal.jdbc.JdbcTemplate;
import org.flywaydb.core.internal.util.SqlCallable;

public class CockroachDBTable
extends Table<CockroachDBDatabase, CockroachDBSchema> {
    private final InsertRowLock insertRowLock = new InsertRowLock();

    CockroachDBTable(JdbcTemplate jdbcTemplate, CockroachDBDatabase database, CockroachDBSchema schema, String name) {
        super(jdbcTemplate, database, schema, name);
    }

    @Override
    protected void doDrop() throws SQLException {
        new CockroachDBRetryingStrategy().execute(new SqlCallable<Integer>(){

            @Override
            public Integer call() throws SQLException {
                CockroachDBTable.this.doDropOnce();
                return null;
            }
        });
    }

    protected void doDropOnce() throws SQLException {
        this.jdbcTemplate.execute("DROP TABLE IF EXISTS " + ((CockroachDBDatabase)this.database).quote(((CockroachDBSchema)this.schema).getName(), this.name) + " CASCADE", new Object[0]);
    }

    @Override
    protected boolean doExists() throws SQLException {
        return new CockroachDBRetryingStrategy().execute(new SqlCallable<Boolean>(){

            @Override
            public Boolean call() throws SQLException {
                return CockroachDBTable.this.doExistsOnce();
            }
        });
    }

    protected boolean doExistsOnce() throws SQLException {
        if (((CockroachDBSchema)this.schema).cockroachDB1) {
            return this.jdbcTemplate.queryForBoolean("SELECT EXISTS (\n   SELECT 1\n   FROM   information_schema.tables \n   WHERE  table_schema = ?\n   AND    table_name = ?\n)", ((CockroachDBSchema)this.schema).getName(), this.name);
        }
        if (!((CockroachDBSchema)this.schema).hasSchemaSupport) {
            return this.jdbcTemplate.queryForBoolean("SELECT EXISTS (\n   SELECT 1\n   FROM   information_schema.tables \n   WHERE  table_catalog = ?\n   AND    table_schema = 'public'\n   AND    table_name = ?\n)", ((CockroachDBSchema)this.schema).getName(), this.name);
        }
        String sql = "SELECT EXISTS (\n   SELECT 1\n   FROM   information_schema.tables \n   WHERE  table_schema = ?\n   AND    table_name like '%" + this.name + "%' and length(table_name) = length(?)\n)";
        return this.jdbcTemplate.queryForBoolean(sql, ((CockroachDBSchema)this.schema).getName(), this.name);
    }

    @Override
    protected void doLock() throws SQLException {
        if (this.lockDepth == 0) {
            this.insertRowLock.doLock(this.jdbcTemplate, ((CockroachDBDatabase)this.database).getInsertStatement(this), ((CockroachDBDatabase)this.database).getBooleanTrue());
        }
    }

    @Override
    protected void doUnlock() throws SQLException {
        if (this.lockDepth == 1) {
            this.insertRowLock.doUnlock(this.jdbcTemplate, this.getDeleteLockTemplate());
        }
    }

    private String getDeleteLockTemplate() {
        return "DELETE FROM " + this + " WHERE version = '?' AND DESCRIPTION = 'flyway-lock'";
    }
}

