/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.database;

import java.math.BigInteger;
import java.sql.SQLException;
import java.util.Random;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.internal.jdbc.JdbcTemplate;
import org.flywaydb.core.internal.jdbc.Results;

public class InsertRowLock {
    private static final Log LOG = LogFactory.getLog(InsertRowLock.class);
    private static final Random random = new Random();
    private final String tableLockString = InsertRowLock.getNextRandomString();

    public void doLock(JdbcTemplate jdbcTemplate, String insertStatementTemplate, String booleanTrue) throws SQLException {
        int retryCount = 0;
        do {
            try {
                if (this.insertLockingRow(jdbcTemplate, insertStatementTemplate, booleanTrue)) {
                    return;
                }
                ++retryCount;
                LOG.debug("Waiting for lock on " + this);
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (retryCount < 50);
        throw new FlywayException("Unable to obtain table lock - another Flyway instance may be running");
    }

    private boolean insertLockingRow(JdbcTemplate jdbcTemplate, String insertStatementTemplate, String booleanTrue) {
        String insertStatement = String.format(insertStatementTemplate.replace("?", "%s"), -100, "'" + this.tableLockString + "'", "'flyway-lock'", "''", "''", 0, "''", 0, booleanTrue);
        Results results = jdbcTemplate.executeStatement(insertStatement);
        return results.getResults().size() > 0 && results.getResults().get(0).getUpdateCount() == 1L && results.getErrors().size() == 0;
    }

    public void doUnlock(JdbcTemplate jdbcTemplate, String selectLockTemplate, String deleteLockTemplate) throws SQLException {
        String selectLock = String.format(selectLockTemplate.replace("?", "%s"), this.tableLockString);
        int competingLocksTaken = jdbcTemplate.queryForInt(selectLock, new String[0]);
        if (competingLocksTaken > 0) {
            throw new FlywayException("Internal error: on unlocking, a competing lock was found");
        }
        String deleteLock = String.format(deleteLockTemplate.replace("?", "%s"), this.tableLockString);
        jdbcTemplate.executeStatement(deleteLock);
    }

    private static String getNextRandomString() {
        BigInteger bInt = new BigInteger(128, random);
        return bInt.toString(16);
    }
}

