/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.command;

import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.MigrationInfoService;
import org.flywaydb.core.api.callback.Event;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.api.resolver.MigrationResolver;
import org.flywaydb.core.internal.callback.CallbackExecutor;
import org.flywaydb.core.internal.database.base.Schema;
import org.flywaydb.core.internal.info.MigrationInfoServiceImpl;
import org.flywaydb.core.internal.schemahistory.SchemaHistory;

public class DbInfo {
    private final MigrationResolver migrationResolver;
    private final SchemaHistory schemaHistory;
    private final Configuration configuration;
    private final CallbackExecutor callbackExecutor;
    private final Schema[] schemas;

    public DbInfo(MigrationResolver migrationResolver, SchemaHistory schemaHistory, Configuration configuration, CallbackExecutor callbackExecutor, Schema[] schemas) {
        this.migrationResolver = migrationResolver;
        this.schemaHistory = schemaHistory;
        this.configuration = configuration;
        this.callbackExecutor = callbackExecutor;
        this.schemas = schemas;
    }

    public MigrationInfoService info() {
        MigrationInfoServiceImpl migrationInfoService;
        this.callbackExecutor.onEvent(Event.BEFORE_INFO);
        try {
            migrationInfoService = new MigrationInfoServiceImpl(this.migrationResolver, this.schemaHistory, this.schemas, this.configuration, this.configuration.getTarget(), this.configuration.isOutOfOrder(), this.configuration.getCherryPick(), true, true, true, true);
            migrationInfoService.refresh();
        }
        catch (FlywayException e) {
            this.callbackExecutor.onEvent(Event.AFTER_INFO_ERROR);
            throw e;
        }
        this.callbackExecutor.onEvent(Event.AFTER_INFO);
        return migrationInfoService;
    }
}

