/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.api.output;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.flywaydb.core.api.MigrationInfo;
import org.flywaydb.core.api.MigrationState;
import org.flywaydb.core.api.MigrationVersion;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.api.output.BaselineResult;
import org.flywaydb.core.api.output.CleanResult;
import org.flywaydb.core.api.output.InfoOutput;
import org.flywaydb.core.api.output.InfoResult;
import org.flywaydb.core.api.output.MigrateOutput;
import org.flywaydb.core.api.output.MigrateResult;
import org.flywaydb.core.api.output.RepairOutput;
import org.flywaydb.core.api.output.RepairResult;
import org.flywaydb.core.api.output.UndoOutput;
import org.flywaydb.core.api.output.UndoResult;
import org.flywaydb.core.api.output.ValidateResult;
import org.flywaydb.core.api.resolver.ResolvedMigration;
import org.flywaydb.core.internal.license.VersionPrinter;

public class CommandResultFactory {
    public InfoResult createInfoResult(Configuration configuration, MigrationInfo[] migrationInfos, MigrationInfo current, boolean allSchemasEmpty) {
        String flywayVersion = VersionPrinter.getVersion();
        String databaseName = this.getDatabaseName(configuration);
        Set<MigrationVersion> undoableVersions = CommandResultFactory.getUndoableVersions(migrationInfos);
        ArrayList<InfoOutput> infoOutputs = new ArrayList<InfoOutput>();
        for (MigrationInfo migrationInfo : migrationInfos) {
            infoOutputs.add(this.createInfoOutput(undoableVersions, migrationInfo));
        }
        MigrationVersion currentSchemaVersion = current == null ? MigrationVersion.EMPTY : current.getVersion();
        MigrationVersion schemaVersionToOutput = currentSchemaVersion == null ? MigrationVersion.EMPTY : currentSchemaVersion;
        String schemaVersion = schemaVersionToOutput.getVersion();
        return new InfoResult(flywayVersion, databaseName, schemaVersion, String.join((CharSequence)", ", configuration.getSchemas()), infoOutputs, allSchemasEmpty);
    }

    public MigrateResult createMigrateResult(String databaseName, Configuration configuration) {
        String flywayVersion = VersionPrinter.getVersion();
        return new MigrateResult(flywayVersion, databaseName, String.join((CharSequence)", ", configuration.getSchemas()));
    }

    public CleanResult createCleanResult(String databaseName) {
        String flywayVersion = VersionPrinter.getVersion();
        return new CleanResult(flywayVersion, databaseName);
    }

    public UndoResult createUndoResult(String databaseName, Configuration configuration) {
        String flywayVersion = VersionPrinter.getVersion();
        return new UndoResult(flywayVersion, databaseName, String.join((CharSequence)", ", configuration.getSchemas()));
    }

    public BaselineResult createBaselineResult(String databaseName) {
        String flywayVersion = VersionPrinter.getVersion();
        return new BaselineResult(flywayVersion, databaseName);
    }

    public ValidateResult createValidateResult(String databaseName, String validationError, int validationCount, List<String> warnings) {
        String flywayVersion = VersionPrinter.getVersion();
        boolean validationSuccessful = validationError == null;
        return new ValidateResult(flywayVersion, databaseName, validationError, validationSuccessful, validationCount, warnings);
    }

    public RepairResult createRepairResult(String databaseName) {
        String flywayVersion = VersionPrinter.getVersion();
        return new RepairResult(flywayVersion, databaseName);
    }

    private String getDatabaseName(Configuration configuration) {
        try {
            Connection connection = configuration.getDataSource().getConnection();
            String catalog = connection.getCatalog();
            connection.close();
            return catalog;
        }
        catch (Exception e) {
            return "";
        }
    }

    public InfoOutput createInfoOutput(Set<MigrationVersion> undoableVersions, MigrationInfo migrationInfo) {
        return new InfoOutput(this.getCategory(migrationInfo), migrationInfo.getVersion() != null ? migrationInfo.getVersion().getVersion() : "", migrationInfo.getDescription(), migrationInfo.getType() != null ? migrationInfo.getType().toString() : "", migrationInfo.getInstalledOn() != null ? migrationInfo.getInstalledOn().toString() : "", migrationInfo.getState().getDisplayName(), CommandResultFactory.getUndoableStatus(migrationInfo, undoableVersions), migrationInfo.getPhysicalLocation() != null ? migrationInfo.getPhysicalLocation() : "", migrationInfo.getInstalledBy() != null ? migrationInfo.getInstalledBy() : "", migrationInfo.getExecutionTime() != null ? migrationInfo.getExecutionTime() : 0);
    }

    public MigrateOutput createMigrateOutput(MigrationInfo migrationInfo) {
        return new MigrateOutput(this.getCategory(migrationInfo), migrationInfo.getVersion() != null ? migrationInfo.getVersion().getVersion() : "", migrationInfo.getDescription(), migrationInfo.getType() != null ? migrationInfo.getType().toString() : "", migrationInfo.getPhysicalLocation() != null ? migrationInfo.getPhysicalLocation() : "", migrationInfo.getExecutionTime() != null ? migrationInfo.getExecutionTime() : 0);
    }

    public UndoOutput createUndoOutput(ResolvedMigration undoMigrationInfo) {
        return new UndoOutput(undoMigrationInfo.getVersion().getVersion(), undoMigrationInfo.getDescription(), undoMigrationInfo.getPhysicalLocation() != null ? undoMigrationInfo.getPhysicalLocation() : "");
    }

    public RepairOutput createRepairOutput(MigrationInfo RepairMigrationInfo) {
        return new RepairOutput(RepairMigrationInfo.getVersion() != null ? RepairMigrationInfo.getVersion().getVersion() : "", RepairMigrationInfo.getDescription(), RepairMigrationInfo.getPhysicalLocation() != null ? RepairMigrationInfo.getPhysicalLocation() : "");
    }

    private static String getUndoableStatus(MigrationInfo migrationInfo, Set<MigrationVersion> undoableVersions) {
        return "";
    }

    private static Set<MigrationVersion> getUndoableVersions(MigrationInfo[] migrationInfos) {
        HashSet<MigrationVersion> result = new HashSet<MigrationVersion>();
        return result;
    }

    private static MigrationInfo[] removeAvailableUndos(MigrationInfo[] migrationInfos) {
        ArrayList<MigrationInfo> result = new ArrayList<MigrationInfo>();
        for (MigrationInfo migrationInfo : migrationInfos) {
            if (migrationInfo.getState().equals((Object)MigrationState.AVAILABLE)) continue;
            result.add(migrationInfo);
        }
        return result.toArray(new MigrationInfo[0]);
    }

    private String getCategory(MigrationInfo migrationInfo) {
        if (migrationInfo.getType().isSynthetic()) {
            return "";
        }
        if (migrationInfo.getVersion() == null) {
            return "Repeatable";
        }
        return "Versioned";
    }
}

